/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GRAPHICS_BRANCH_ITEM_H_
#define _GB2_GRAPHICS_BRANCH_ITEM_H_

#include <QtGui/QAbstractGraphicsShapeItem>

namespace GB2 {

class PhyNode;
class GraphicsButtonItem;

class GraphicsBranchItem: public QAbstractGraphicsShapeItem {
public:
    enum Direction { up, down };

    static const int TEXT_SPACE;
    static const int SELECTED_PEN_WIDTH;

private:
    GraphicsButtonItem* button;
    void initText(qreal d);

protected:
    QGraphicsSimpleTextItem* distanceText;
    QGraphicsSimpleTextItem* nameText;
    qreal width;
    bool collapsed;

    GraphicsBranchItem(const QString& name);
    GraphicsBranchItem(qreal d, bool withButton = true);

public:
    GraphicsBranchItem(bool withButton = true);

    GraphicsButtonItem* getButton() const { return button; }
    QGraphicsSimpleTextItem* getDistanceText() const { return distanceText; }
    QGraphicsSimpleTextItem* getNameText() const { return nameText; }
    qreal getWidth() const { return width; }
    void setWidthW(qreal w) { width = w; }
    void setWidth(qreal w);

    void setSelected(bool sel);
    virtual void collapse();
};

}//namespace;

#endif
