/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GRAPHICS_BUTTON_ITEM_H_
#define _GB2_GRAPHICS_BUTTON_ITEM_H_

#include <QtGui/QAbstractGraphicsShapeItem>

namespace GB2 {

class GraphicsBranchItem;

class GraphicsButtonItem: public QAbstractGraphicsShapeItem {
    static const qreal min_radius;
    static const qreal max_radius;
    bool mouse, selected;

protected:
    void hoverEnterEvent(QGraphicsSceneHoverEvent *e);
    void hoverLeaveEvent(QGraphicsSceneHoverEvent *e);
    void mousePressEvent(QGraphicsSceneMouseEvent *e);
    void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *e);

public:
    GraphicsButtonItem();
    QRectF boundingRect() const;
    QPainterPath shape() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

    void setSelected(bool sel);
    void collapse();
};

}//namespace;

#endif
