/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "TreeViewerState.h"
#include "TreeViewer.h"
#include "TreeViewerFactory.h"

#include <core_api/DocumentModel.h>
#include <gobjects/AnnotationTableObject.h>
#include <gobjects/PhyTreeObject.h>
#include <selection/DNASequenceSelection.h>

namespace GB2 {

#define VIEW_ID		QString("view_id")
#define PHY_OBJ		QString("phy_obj_ref")
#define X_POS       QString("x_pos")
#define Y_POS       QString("y_pos")

bool TreeViewerState::isValid() const {
	return stateData.value(VIEW_ID) == TreeViewerFactory::ID;
}

GObjectReference TreeViewerState::getPhyObject() const {
	return stateData.contains(PHY_OBJ) ? stateData[PHY_OBJ].value<GObjectReference>() : GObjectReference();
}

void TreeViewerState::setPhyObject(const GObjectReference& ref) {
    stateData[PHY_OBJ] = QVariant::fromValue<GObjectReference>(ref);
}


int TreeViewerState::getX() const {
	QVariant v = stateData.value(X_POS);
    if (v.type() == QVariant::Int) {
        return v.toInt();
    }
    return 0;
}

void TreeViewerState::setX(int x) {
    stateData[X_POS] = x;
}

int TreeViewerState::getY() const {
    QVariant v = stateData.value(Y_POS);
    if (v.type() == QVariant::Int) {
        return v.toInt();
    }
    return 0;
}

void TreeViewerState::setY(int y) {
    stateData[Y_POS] = y;
}


QVariantMap TreeViewerState::saveState(TreeViewer* v) {
	TreeViewerState ss;

    ss.stateData[VIEW_ID] = TreeViewerFactory::ID;

	PhyTreeObject* phyObj = v->getPhyObject();
    if (phyObj)
    	ss.setPhyObject(GObjectReference(phyObj));
	ss.setX(0);
	ss.setY(0);
	
	return ss.stateData;
}

} // namespace
