/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_UTILS__H_
#define _GB2_PROJECT_UTILS__H_

#include <core_api/ProjectModel.h>
#include <util_algorithm/GAutoDeleteList.h>

class QDomDocument;

typedef QMap<QString,QString> StrMap;

namespace GB2 {

class GB2_COREAPI_EXPORT ProjectParser : public QObject {
    Q_OBJECT
public:
    virtual Project* createProjectFromXMLModel(const QString& url, const QDomDocument& xmlDoc, TaskStateInfo& si) = 0;
    virtual QString getVersion(){assert(false); return QString();};
};

class GB2_COREAPI_EXPORT ProjectParserRegistry {
public:
    ProjectParser* getProjectParserByVersion(const QString& id);
    static ProjectParserRegistry* instance();

private:
    ProjectParserRegistry(ProjectParserRegistry &ppr){Q_UNUSED(ppr); assert(0);};
    ProjectParserRegistry(){init();};
    void init();
    GAutoDeleteList<ProjectParser> parsers;
};


class ProjectParser10 : public ProjectParser {
    Q_OBJECT
public:
    ProjectParser10(){};
    Project* createProjectFromXMLModel(const QString& url, const QDomDocument& xmlDoc, TaskStateInfo& si);
    QString getVersion(){return QString("1.0");};
};

class GB2_COREAPI_EXPORT ProjectFileUtils : public QObject {
    Q_OBJECT

public:

    static void saveProjectFile(TaskStateInfo& ts, Project* p, const QString& projectUrl,   const StrMap& docUrlRemap = StrMap());

    static void loadXMLProjectModel(const QString& url, TaskStateInfo& si, QDomDocument& doc, QString& version);
};



} //namespace

#endif
