/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REPEAT_FINDER_SETTINGS_H_
#define _GB2_REPEAT_FINDER_SETTINGS_H_

#include <core_api/Task.h>

namespace GB2 {

class DNAAlphabet;

enum RFAlgorithm {
    RFAlgorithm_Auto,
    RFAlgorithm_Diagonal,
    RFAlgorithm_Suffix
};

class RFResult {
public:
    RFResult() : x(0), y(0), l(0){}
    RFResult(int _x, int _y, int _len) : x(_x), y(_y), l(_len){}

    bool operator==(const RFResult& r) const {return x == r.x && y == r.y && l == r.l;}
    bool operator!=(const RFResult& r) const {return !(*this == r);}
    bool operator <(const RFResult& r) const {return (x != r.x) ? x < r.x : (y != r.y) ? y < r.y: (l < r.l);}

    int x;
    int y;
    int l;
};

class RFResultsListener {
public:
    virtual void onResult(const RFResult& r) = 0;
    virtual void onResults(const QVector<RFResult>& v) = 0;
};

struct RepeatFinderSettings {
	RepeatFinderSettings()
	:	_l(NULL), _seqX(NULL), _sizeX(0),
		_seqY(NULL), _sizeY(0),
		_al(NULL), _w(0), _mismatches(0),
		_alg(RFAlgorithm_Auto), _nThreads(0)
	{}

	RepeatFinderSettings(
		RFResultsListener* l, const char *seqX, int sizeX, 
		const char *seqY, int sizeY, 
		DNAAlphabet *al, int w, int mismatches,  
		RFAlgorithm alg, int nThreads = MAX_PARALLEL_SUBTASKS_AUTO
	)
	:	_l(l), _seqX(seqX), _sizeX(sizeX),
		_seqY(seqY), _sizeY(sizeY),
		_al(al), _w(w), _mismatches(mismatches),
		_alg(alg), _nThreads(nThreads)
	{}

	RFResultsListener* _l;
	const char *_seqX;
	int _sizeX;
	const char *_seqY;
	int _sizeY;
	DNAAlphabet *_al;
	int _w;
	int _mismatches;
	RFAlgorithm _alg;
	int _nThreads;

    bool operator==(const RepeatFinderSettings& op) const {
        return  _l == op._l &&
                _seqX == op._seqX &&
				_sizeX == op._sizeX &&
                _seqY == op._seqY &&
                _sizeY == op._sizeY &&
				_al == op._al &&
				_w == op._w &&
				_mismatches == op._mismatches &&
				_alg == op._alg &&
				_nThreads == op._nThreads;
    }
};

} // namespace

#endif
