/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SAVE_DOCUMENT_TASK_H_
#define _GB2_SAVE_DOCUMENT_TASK_H_

#include <core_api/GUrl.h>
#include <core_api/Task.h>
#include <gobjects/UnloadedObject.h>

#include <QtCore/QPointer>

namespace GB2 {

class Document;
class StateLock;
class IOAdapterFactory;
class DocumentFormat;

enum SaveDocFlag {
    SaveDoc_Overwrite = 0x0,
    SaveDoc_Append = 0x1, 
    SaveDoc_Roll = 0x2, 
    SaveDoc_DestroyAfter = 0x4
};

typedef QFlags<SaveDocFlag>  SaveDocFlags;

class GB2_COREAPI_EXPORT SaveDocumentTask : public Task {
    Q_OBJECT
public:
	SaveDocumentTask(Document* doc, IOAdapterFactory* iof = NULL, const GUrl& url = GUrl());
    SaveDocumentTask(Document* doc, SaveDocFlags flags, const QSet<QString>& excludeFileNames = QSet<QString>());

	virtual void prepare();

	virtual void run();

	ReportResult report();

    const GUrl& getURL() const {return url;}

    IOAdapterFactory* getIOAdapterFactory() const {return iof;}

    const QPointer<Document>& getDocument() const {return doc;}

    //used in file-name rolling mode
    void setExcludeFileNames(const QSet<QString>& _excludeFileNames) {excludeFileNames = _excludeFileNames;}

private:
	StateLock*          lock;
    QPointer<Document>  doc;
	IOAdapterFactory*   iof;
	GUrl				url;
    SaveDocFlags        flags;
    QSet<QString>       excludeFileNames;
};


class GB2_COREAPI_EXPORT SaveMiltipleDocuments: public Task {
    Q_OBJECT
public:

	SaveMiltipleDocuments(const QList<Document*>& docs, bool askBeforeSave);

	static QList<Document*> findModifiedDocuments(const QList<Document*>& docs);
};

enum UnloadDocumentTask_SaveMode {
    UnloadDocumentTask_SaveMode_Ask,
    UnloadDocumentTask_SaveMode_NotSave,
    UnloadDocumentTask_SaveMode_Save
};


class GB2_COREAPI_EXPORT UnloadDocumentTask: public Task {
    Q_OBJECT
public:
    UnloadDocumentTask(Document* doc, bool save);
    ReportResult report();

    static void runUnloadTaskHelper(const QList<Document*>& docs, UnloadDocumentTask_SaveMode sm);
    static QString checkSafeUnload(Document* d);

private:
    QPointer<Document>      doc;
    SaveDocumentTask*       saveTask;
};

class GB2_COREAPI_EXPORT SaveCopyAndAddToProjectTask : public Task {
    Q_OBJECT
public:
    SaveCopyAndAddToProjectTask(Document* doc, IOAdapterFactory* iof, const GUrl& url);
    ReportResult report();
private:
    SaveDocumentTask*           saveTask;
    QList<UnloadedObjectInfo>   info;
    GUrl						url;
    GUrl						origURL;
    DocumentFormat*             df;
    QVariantMap                 hints;
};


class GB2_COREAPI_EXPORT RelocateDocumentTask : public Task {
    Q_OBJECT
public:
    RelocateDocumentTask(const GUrl& fromURL, const GUrl& toURL);
    ReportResult report();

public:
    GUrl fromURL;
    GUrl toURL;
};

}//namespace

#endif
