/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PWM_CONVERSION_ALGORITHM_BVH_H_
#define _GB2_PWM_CONVERSION_ALGORITHM_BVH_H_

#include <core_api/core_api.h>

#include <datatype/PFMatrix.h>
#include <datatype/PWMatrix.h>

#include "PWMConversionAlgorithm.h"
#include "BuiltInPWMConversionAlgorithms.h"

namespace GB2 {

class GB2_COREAPI_EXPORT PWMConversionAlgorithmFactoryBVH : public PWMConversionAlgorithmFactory {
    Q_OBJECT
public:
    PWMConversionAlgorithmFactoryBVH(QObject* p = NULL);
    
    virtual PWMConversionAlgorithm* createAlgorithm(QObject* parent);
    
    virtual QString getDescription() const;

    virtual QString getName() const;

};

class GB2_COREAPI_EXPORT PWMConversionAlgorithmBVH : public PWMConversionAlgorithm {
	Q_OBJECT
public:

	PWMConversionAlgorithmBVH(PWMConversionAlgorithmFactory* factory, QObject* p = NULL);

	virtual PWMatrix convert(const PFMatrix& matrix);

};

}//namespace

#endif
