/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_LOCAL_DOMAIN_H_
#define _GB2_WORKFLOW_LOCAL_DOMAIN_H_

#include <workflow/IntegralBus.h>
#include <workflow/IntegralBusModel.h>
#include <workflow/WorkflowTransport.h>
#include <workflow/WorkflowManager.h>

#include <QtCore/QQueue>
#include <limits.h>

namespace GB2 {
namespace LocalWorkflow {
using namespace Workflow;

class WCOREAPI_EXPORT BaseWorker : public QObject, public Worker, public CommunicationSubject {
    Q_OBJECT
public:
    BaseWorker(Actor* a, bool autoTransitBus = true);
    virtual ~BaseWorker();
    
    virtual ActorId getActorId() const;
    virtual bool addCommunication(const QString& name, CommunicationChannel* _ch);
    virtual CommunicationChannel* getCommunication(const QString& name);
    
    // if you want your worker support scripts -> you should call this function to get Messages from channels
    // call this when channel has message
    // after calling: set all needed values for running your worker
    // called from 'tick' and then setup worker params
    virtual Message getMessageAndSetupScriptValues( CommunicationChannel * channel );
    
private:
    // bind values from input ports to script vars. 
    // This function is called before 'get' data from channel -> to set up parameters for scripting
    void bindScriptValues();
    
protected:
    Actor* actor;
    QMap<QString, IntegralBus*> ports;
    bool failFast;
    
}; // BaseWorker

class WCOREAPI_EXPORT SimplestSequentialScheduler : public Scheduler {
public:
    SimplestSequentialScheduler(Schema* sh);
    virtual ~SimplestSequentialScheduler();
    
    virtual void init();
    virtual bool isReady();
    virtual Task* tick();
    virtual bool isDone();
    virtual void cleanup();
    
    virtual WorkerState getWorkerState(ActorId);
    
private:
    Schema* schema;
    BaseWorker* lastWorker;
    Task* lastTask;
    
}; // SimplestSequentialScheduler

class WCOREAPI_EXPORT SimpleQueue : public CommunicationChannel {
public:
    SimpleQueue();
    virtual ~SimpleQueue(){}
    
    virtual Message get();
    virtual Message look() const;
    virtual void put(const Message& m);
    virtual int hasMessage() const;
    virtual int hasRoom(const DataType* ) const;
    virtual bool isEnded() const;
    virtual void setEnded();
    
    virtual int capacity() const;
    virtual void setCapacity(int);
    
protected:
    QQueue<Message> que;
    bool ended;
    
}; // SimpleQueue

class WCOREAPI_EXPORT LocalDomainFactory : public DomainFactory {
public:
    static const QString ID;

public:
    LocalDomainFactory();
    virtual ~LocalDomainFactory(){}
    
    virtual Worker* createWorker(Actor*);
    virtual CommunicationChannel* createConnection(Link*);
    virtual Scheduler* createScheduler(Schema*, Configuration*);
    virtual void destroy(Scheduler*, Schema*);
    
}; // LocalDomainFactory

}//Workflow namespace
}//GB2 namespace

#endif
