/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CIRCULAR_PAN_VIEW_H_
#define _GB2_CIRCULAR_PAN_VIEW_H_

#include <core_api/GObject.h>
#include <core_api/MainWindow.h>
#include <core_api/AppContext.h>
#include <core_api/DocumentModel.h>
#include <core_api/DNAAlphabet.h>
#include <core_api/ProjectModel.h>
#include <core_api/IOAdapter.h>
#include <core_api/Log.h>
#include <core_api/Task.h>

#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/GSequenceLineViewAnnotated.h>

#include <QtGui/QFont>
#include <QtGui/QAction>
#include <QtGui/QScrollBar>


namespace GB2 {

class CircularViewRenderArea;
class GScrollBar;
class GObjectView;
class PVRowsManager;
class AnnotationTableObject;
class Annotation;
class CircularAnnotationItem;
class CircularAnnotationLabel;
class CircularRuler;
class CircularViewSplitter;
class TextItem;
class CircularSelectionItem;

#define CV_REGION_ITEM_WIDTH 20
class CircularView : public GSequenceLineViewAnnotated {
    Q_OBJECT
public:
    CircularView(QWidget* p, ADVSequenceObjectContext* ctx);
    ~CircularView();
    void pack();
    void mousePressEvent(QMouseEvent * e);
    void mouseMoveEvent(QMouseEvent * e);
    void mouseReleaseEvent(QMouseEvent* e);
    void wheelEvent(QWheelEvent* we);
    void resizeEvent(QResizeEvent* e);
    virtual QSize sizeHint() const;

    virtual QList<AnnotationSelectionData> selectAnnotationByCoord(const QPoint& coord) const;

    int getScrollPos() const {return sBar->sliderPosition();}

    static qreal coordToAngle(const QPoint point);

    CircularViewRenderArea* getRenderArea() const;
    const QMap<Annotation*,CircularAnnotationItem*>& getCircularItems() const;
    const QList<CircularAnnotationLabel*>& getLabelList() const;
    CircularRuler* getRuler() const;
    TextItem* getSeqNameLabel() const;
    TextItem* getSeqLenLabel() const;
    CircularSelectionItem* getSelItem() const;

    bool isCircularTopology() { return isCircularDNA; }

protected slots: 
    virtual void sl_onAnnotationSelectionChanged(AnnotationSelection*, const QList<Annotation*>& added, const QList<Annotation*>& removed);
    virtual void sl_onDNASelectionChanged(LRegionsSelection* thiz, const QList<LRegion>& added, const QList<LRegion>& removed);

    void sl_onSBarMoved(int pos);
protected:
    void updateVerticalScrollBar(int areaHeight);

    QScrollBar* sBar;
    QVBoxLayout *layout;

    int lastMovePos;
    int currectSelectionLen;
    int lastMouseY;
    CircularViewRenderArea* ra;
    bool isCircularDNA;
};

class CircularViewRenderArea : public GSequenceLineViewAnnotatedRenderArea {
    friend class CircularView;
    friend class CircularAnnotationItem;
    friend class CircularAnnotationLabel;
    friend class CircurlarAnnotationRegionItem;
    Q_OBJECT
public:
    CircularViewRenderArea(CircularView* d);

    int getAnnotationYLevel (Annotation* a) const { return annotationYLevel.value(a); }
    
protected:
    void resizeEvent(QResizeEvent *e);
    virtual void drawAll(QPaintDevice* pd);
    virtual LRegion getAnnotationYRange(Annotation* a, const LRegion& r, const AnnotationSettings* as) const;
    void buildAnnotationItem(DrawAnnotationPass pass, Annotation* a, bool selected = false, const AnnotationSettings* as = NULL);
    virtual void drawAnnotations(QPainter& p);
    void buildAnnotationLabel(const QFont& font, Annotation* a, const AnnotationSettings* as);
    void drawSequenceName(QPainter& p);
    void drawRuler(QPainter& p);
    void drawAnnotationsSelection(QPainter& p);
    void drawSequenceSelection(QPainter& p);
    void drawMarker(QPainter& p);
    void evaluateLabelPositions();
private:
    static const int OUTER_ELLIPSE_SIZE;
    static const int ELLIPSE_DELTA;
    static const int INNER_ELLIPSE_SIZE;
    static const int RULER_ELLIPSE_SIZE;
    static const int MIDDLE_ELLIPSE_SIZE;
    static const int ARROW_LENGTH;
    static const int ARROW_HEIGHT_DELTA;
    static const int MAX_DISPLAYING_LABELS;

    int outerEllipseSize;
    int ellipseDelta;
    int innerEllipseSize;
    int rulerEllipseSize;
    int middleEllipseSize;
    int arrowLength;
    int arrowHeightDelta;
    int maxDisplayingLabels;

    CircularView* circularView;
    QList< QList <LRegion> > regionY;
    QMap< Annotation*, CircularAnnotationItem* > circItems;
    CircularRuler* ruler;
    TextItem* seqNameItem;
    TextItem* seqLenItem;
    CircularSelectionItem* selItem;
    QMap< Annotation* , int > annotationYLevel;
    QList<CircularAnnotationLabel*> labelList;
    qreal rotationDegree;
    qreal mouseAngle;
    QVector<QRect> labelEmptyPositions;
    QVector<QRect> labelEmptyInnerPositions;
};

}//namespace;

#endif
