/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <memory>
#include <QtNetwork/QTcpSocket>
#include <core_api/AppContext.h>
#include <distributed_computing/LocalTaskManager.h>
#include "DirectSocketProtocol.h"

namespace GB2 {

DirectSocketProtocol::DirectSocketProtocol()
{
    connect(&server, SIGNAL(newConnection()), SLOT(sl_newConnection()));
}

DirectSocketProtocol::~DirectSocketProtocol()
{
}

QString DirectSocketProtocol::getId() const
{
    return id;
}

void DirectSocketProtocol::setEnabled( bool enable )
{
    if(enable)
    {
        server.listen(QHostAddress::Any, 6666);
    }
    else
    {
        server.close();
    }
}

bool DirectSocketProtocol::isEnabled() const
{
    return server.isListening();
}

RemoteMachineScanner * DirectSocketProtocol::getScanner() const
{
    return NULL;
}

void DirectSocketProtocol::sl_newConnection()
{
    std::auto_ptr<QTcpSocket> socket(server.nextPendingConnection());
    QDataStream stream(socket.get());
    QVariant data;
    stream >> data;
    QVariantList result;
    result << false;
    result << QVariant();
    if(data.canConvert(QVariant::List))
    {
        QVariantList args = data.toList();
        QString methodName = args[0].toString();
        if(methodName.isEmpty())
        {
            QString methodName = args[0].toString();
            if("runRemoteTask" == methodName)
            {
                bool ok = false;
                result[1] = AppContext::getLocalTaskManager()->runLocalTask(args[1].toString(), args[2], &ok);
                result[0] = ok;
            }
            else if("cancelRemoteTask" == methodName)
            {
                bool convertOk = false;
                qint64 taskId = args[1].toLongLong(&convertOk);
                if(convertOk)
                {
                    bool ok = false;
                    AppContext::getLocalTaskManager()->cancelTask(taskId, &ok);
                    result[0] = ok;
                }
            }
            else if("deleteRemoteTask" == methodName)
            {
                bool convertOk = false;
                qint64 taskId = args[1].toLongLong(&convertOk);
                if(convertOk)
                {
                    bool ok = false;
                    AppContext::getLocalTaskManager()->deleteTask(taskId, &ok);
                    result[0] = ok;
                }
            }
            else if("getRemoteTaskCancelFlag" == methodName)
            {
                bool convertOk = false;
                qint64 taskId = args[1].toLongLong(&convertOk);
                if(convertOk)
                {
                    bool ok = false;
                    result[1] = AppContext::getLocalTaskManager()->getTaskCancelFlag(taskId, &ok);
                    result[0] = ok;
                }
            }
            else if("getRemoteTaskState" == methodName)
            {
                bool convertOk = false;
                qint64 taskId = args[1].toLongLong(&convertOk);
                if(convertOk)
                {
                    bool ok = false;
                    result[1] = AppContext::getLocalTaskManager()->getTaskState(taskId, &ok);
                    result[0] = ok;
                }
            }
            else if("getRemoteTaskProgress" == methodName)
            {
                bool convertOk = false;
                qint64 taskId = args[1].toLongLong(&convertOk);
                if(convertOk)
                {
                    bool ok = false;
                    result[1] = AppContext::getLocalTaskManager()->getTaskProgress(taskId, &ok);
                    result[0] = ok;
                }
            }
            else if("getRemoteTaskResult" == methodName)
            {
                bool convertOk = false;
                qint64 taskId = args[1].toLongLong(&convertOk);
                if(convertOk)
                {
                    bool ok = false;
                    result[1] = AppContext::getLocalTaskManager()->getTaskResult(taskId, &ok);
                    result[0] = ok;
                }
            }
            else if("getUuid" == methodName)
            {
                result[1] = AppContext::getLocalTaskManager()->getUuid().toString();
                result[0] = true;
            }
        }
    }
    stream << result;
}

const QString DirectSocketProtocol::id = "DirectSocketProtocol";

} // namespace GB2
