/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef DIRECTSOCKETREMOTETASKSERVER_H
#define DIRECTSOCKETREMOTETASKSERVER_H

#include <QtNetwork/QTcpServer>
#include <QtNetwork/QUdpSocket>
#include <distributed_computing/RemoteTaskServer.h>

namespace GB2 {

class DirectSocketRemoteTaskServer : public QObject, public RemoteTaskServer {
    Q_OBJECT
public:
    static const int DIRECT_SOCKET_TCP_SERVER_DEFAULT_PORT  = 23773;
    static const int DIRECT_SOCKET_UDP_PORT                 = 23774;
    
public:
    DirectSocketRemoteTaskServer();
    virtual ~DirectSocketRemoteTaskServer();

    virtual bool setEnabled( bool enable );
    virtual bool isEnabled() const;
    
    int getPort() const;
    void changePort( int newPort ); /* if server is running this leads to restarting of server */
    
private slots:
    void sl_newConnection();
    void sl_udpSocketReadyRead();

private:
    QTcpServer  server;
    int         port;
    QUdpSocket  udpSocket;
    
}; // DirectSocketRemoteTaskServer

} // namespace GB2

#endif // DIRECTSOCKETREMOTETASKSERVER_H
