/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_DIRECT_SOCKET_SCANNER_H_
#define _GB2_DIRECT_SOCKET_SCANNER_H_

#include <QtNetwork/QUdpSocket>
#include <QtNetwork/QNetworkInterface>
#include <QtCore/QMutex>

#include <distributed_computing/RemoteMachineScanner.h>

namespace GB2 {

class DirectSocketScanner : public RemoteMachineScanner {
    Q_OBJECT
public:
    static const QString    DIRECT_SOCKET_SCANNER_MSG;
    static const int        SCANNER_UDP_PORT = 23775;
    
public:
    DirectSocketScanner();
    ~DirectSocketScanner();
    
    virtual void startScan();
    virtual QList< RemoteMachineSettings * > takeScanned();
    bool isLocalhostAddr( const QHostAddress & addr ) const;
    
private:
    void cleanup();
    
private slots:
    void sl_readyRead();
    
private:
    QUdpSocket                          udpSocket;
    QList< RemoteMachineSettings * >    scannedMachineSettings;
    int                                 scanNumber;
    QMutex                              mtx;
    QList< QNetworkAddressEntry >       addrEntries;
    
}; // DirectSocketScanner

} // GB2

#endif // _GB2_DIRECT_SOCKET_SCANNER_H_
