/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CSVColumnConfigurationDialog.h"

#include <core_api/L10n.h>
#include <gobjects/AnnotationTableObject.h>

#include "QtGui/QMessageBox"

namespace GB2 {

CSVColumnConfigurationDialog::CSVColumnConfigurationDialog(QWidget* w, const ColumnConfig& _config) 
: QDialog(w), config(_config)
{
	setupUi(this);
    switch(config.role) {
        case ColumnRole_Ignore: 
            ignoreRB->setChecked(true); 
            break;
        case ColumnRole_Name: 
            nameRB->setChecked(true);
            break;
        case ColumnRole_Qualifier: 
            qualifierRB->setChecked(true);
            qualifierNameEdit->setText(config.qualifierName);
            break;
        case ColumnRole_StartPos:
            startRB->setChecked(true);
            startOffsetCheck->setChecked(config.startPositionOffset!=0);
            startOffsetValue->setValue(config.startPositionOffset);
            break;
        case ColumnRole_EndPos:
            endRB->setChecked(true);
            endInclusiveCheck->setChecked(config.endPositionIsInclusive);
            break;
        case ColumnRole_Length:
            lengthRB->setChecked(true);
            break;
        default:
            assert(0);
    }
}

void CSVColumnConfigurationDialog::accept() {
	config.reset();
	if (startRB->isChecked()) {
		config.role = ColumnRole_StartPos;
		config.startPositionOffset = startOffsetCheck->isChecked() ? startOffsetValue->value() : 0;
	} else if (endRB->isChecked()) {
		config.role = ColumnRole_EndPos;
		config.endPositionIsInclusive = endInclusiveCheck->isChecked();
	} else if (lengthRB->isChecked()) {
		config.role = ColumnRole_Length;
	} else if (qualifierRB->isChecked()) {
		config.role = ColumnRole_Qualifier;
		config.qualifierName = qualifierNameEdit->text();
		if (!Annotation::isValidQualifierName(config.qualifierName)) {
			QMessageBox::critical(this, L10N::errorTitle(), tr("Invalid qualifier name!"));
			qualifierNameEdit->setFocus();
			return;
		}
    } else if (nameRB->isChecked()) {
        config.role = ColumnRole_Name;
	} else {
		assert(ignoreRB->isChecked());
	}
	QDialog::accept();
}

} //namespace
