/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_ANNOTATIONS_2_CSV_TASK_H_
#define _GB2_EXPORT_ANNOTATIONS_2_CSV_TASK_H_

#include <core_api/Task.h>
#include <core_api/DNATranslation.h>

namespace GB2 {

class Annotation;

class ExportAnnotations2CSVTask : public Task {
    Q_OBJECT
public:
    ExportAnnotations2CSVTask(
		const QList<Annotation*>& annotations, 
		const QByteArray& sequence, 
		DNATranslation *complementTranslation, 
		bool exportSequence, const QString& url);

    void run();
private:
    QList<Annotation*> annotations;
    QByteArray sequence;
    DNATranslation *complementTranslation;
    bool exportSequence;
    QString url;
};

} // namespace GB2

#endif 
