/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ExportUtils.h"

#include "ExportSequencesDialog.h"
#include "ExportTasks.h"

namespace GB2 {

void ExportUtils::loadDNAExportSettingsFromDlg(ExportSequencesTaskSettings& s, const ExportSequencesDialog& d)  {
    s.fileName = d.file;
    s.merge = d.merge;
    s.mergeGap = d.mergeGap;
    s.allAminoStrands = d.translateAllFrames;
    s.strand = d.strand;
    s.formatId = d.formatId;
    s.useSpecificTable = d.useSpecificTable;
    s.translationTable = d.translationTable;
    s.backTranslate = d.backTranslate;
    s.mostProbable = d.mostProbable;
}

Task* ExportUtils::wrapExportTask(AbstractExportTask* t, bool addToProject) {
    if (!addToProject) {
        return t;
    }
    return new AddDocumentAndOpenViewTask(t);
}



QString ExportUtils::genUniqueName(const QSet<QString>& names, QString prefix) {
    if (!names.contains(prefix)) {
        return prefix;
    }
    QString name = prefix;
    int i=0;
    do {
        if (!names.contains(name)) {
            break;
        }
        name = prefix + "_" + QString::number(++i);
    } while(true);
    return name;
}

}//namespace
