/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_UTILS_H_
#define _GB2_EXPORT_UTILS_H_

#include <core_api/core_api.h>


namespace GB2 {

class Task;
class ExportSequencesDialog;
class ExportSequencesTaskSettings;
class AbstractExportTask;

class ExportUtils: public QObject {
    Q_OBJECT
public:

    static void loadDNAExportSettingsFromDlg(ExportSequencesTaskSettings& s, const ExportSequencesDialog& d);

    static Task* wrapExportTask(AbstractExportTask* t, bool addToProject);

    // generates unique name using prefix + numbers
    static QString genUniqueName(const QSet<QString>& names, QString prefix);
    
};

}//namespace

#endif
