/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DOT_PLOT_WIDGET_H_
#define _GB2_DOT_PLOT_WIDGET_H_

#include <util_ov_annotated_dna/ADVSplitWidget.h>
#include <core_api/LRegion.h>

class QMenu;

namespace GB2 {

class Task;
class ADVSequenceObjectContext;
class ADVSequenceWidget;
class GObjectView;
class LRegionsSelection;

class DotPlotResultsListener;
class DotPlotMiniMap;
struct DotPlotResults;


class DotPlotWidget : public ADVSplitWidget {
	Q_OBJECT

public:
	DotPlotWidget(AnnotatedDNAView* dnaView);
    ~DotPlotWidget();

    virtual bool acceptsGObject(GObject*) {return false;}
    virtual void updateState(const QVariantMap&) {}
    virtual void saveState(QVariantMap&) {}

	void buildPopupMenu(QMenu *) const;

	AnnotatedDNAView* getDnaView() const {return dnaView;}

signals:
	void si_removeDotPlot();

public slots:
	bool sl_showSettingsDialog();

private slots:
	void sl_taskFinished(Task*);
	void sl_showSaveImageDialog();
	bool sl_showSaveFileDialog();
	bool sl_showLoadFileDialog();
	void sl_showDeleteDialog();

	void sl_onXSequenceSelectionChanged(LRegionsSelection*, const QList<LRegion>& , const QList<LRegion>&);
	void sl_onYSequenceSelectionChanged(LRegionsSelection*, const QList<LRegion>& , const QList<LRegion>&);

	void sl_sequenceWidgetRemoved(ADVSequenceWidget*);

protected:
    void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);

	void wheelEvent(QWheelEvent *);
	void mousePressEvent(QMouseEvent *);
	void mouseMoveEvent(QMouseEvent *);
	void mouseReleaseEvent(QMouseEvent *);

private:

	AnnotatedDNAView* dnaView;

	bool selecting, shifting, miniMapLooking;
	LRegionsSelection *selectionX, *selectionY;
	ADVSequenceObjectContext *sequenceX, *sequenceY;

	float zoom, shiftX, shiftY;;
	int minLen, identity;

	bool pixMapUpdateNeeded, deleteDotPlotFlag;

	Task *dotPlotTask;
	QPixmap *pixMap;
	DotPlotMiniMap *miniMap;

	const DotPlotResults *nearestRepeat;

	QPointF clickedFirst, clickedSecond;

	DotPlotResultsListener *dotPlotResultsListener;

	QMenu* dotPlotMenu;
	QAction *showSettingsDialogAction;
	QAction *saveImageAction;
	QAction *saveDotPlotAction;
	QAction *loadDotPlotAction;
	QAction *deleteDotPlotAction;
	QMenu *saveMenu;

	static const int textSpace = 30;
	int w;
	int h;

	QColor dotPlotBGColor;
	QColor dotPlotDotColor;
	QColor dotPlotNearestRepeatColor;

	QByteArray sharedSeqX, sharedSeqY;

	void pixMapUpdate();

	void initActionsAndSignals();
	void connectSequenceSelectionSignals();

    void drawAll(QPainter&);
    void drawAxises(QPainter&) const;
    void drawDots(QPainter&);
    void drawSelection(QPainter&) const;
	void drawRulers(QPainter&) const;
	void drawMiniMap(QPainter&) const;
	void drawNearestRepeat(QPainter&) const;

	void sequencesMouseSelection(const QPointF &, const QPointF &);
	void sequencesCoordsSelection(const QPointF &, const QPointF &);

	void selectNearestRepeat(const QPointF &);
	const DotPlotResults* findNearestRepeat(const QPoint &) const;

	void calcZooming(float oldzoom, float newzoom, const QPoint &cursor);
	void resetZooming();
	void checkShift();

	void miniMapShift();

	void drawRectCorrect(QPainter &p, QRectF rect) const;

	QPoint toInnerCoords(int x, int y) const;
	QPointF unshiftedUnzoomed(const QPointF &p) const;
	QPoint sequenceCoords(const QPointF &c) const;

	QString getRoundedText(QPainter& p, int num, int size) const;
	bool getLineToDraw(const DotPlotResults &r, QLine *line, float ratioX, float ratioY) const;

	void addCloseDotPlotTask();
	void cancelRepeatFinderTask();
};

} // namespace

#endif // _GB2_DOT_PLOT_WIDGET_H_
