/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _HTTP_REQUEST_H_
#define _HTTP_REQUEST_H_


#include <core_api/Log.h>
#include <core_api/IOAdapter.h>
#include <core_api/AppContext.h>
#include <core_api/Task.h>
#include <core_api/DataBaseRegistry.h>

#include <QtCore/QtCore>
#include <QtXml/QDomNode>
#include <QtXml/QDomDocument>

#include "RemoteQueryConsts.h"

namespace GB2 {

class RemoteQueryTask;

struct ResponseBuffer {
    ResponseBuffer(){}
    ~ResponseBuffer() { buf.close(); }
    void setBuffer(QByteArray *arr) { buf.setBuffer(arr); }
    bool open(QIODevice::OpenMode openMode) { return buf.open(openMode); }
    void close() { buf.close(); }
    QByteArray readLine() { return buf.readLine(); }

    QBuffer buf;
};


class HttpRequestBLAST:public HttpRequest {
public:
    HttpRequestBLAST(Task *_task):HttpRequest(_task){};
    virtual void sendRequest(const QString &program,const QString &query);
    virtual void parseResult(const QByteArray &buf);
    virtual QByteArray getOutputFile();

private:
    class Waiter: public QThread {
    public:
        static void await(int mseconds) {
            msleep(mseconds);
        }
    };
    static const QString host;
    QByteArray output;
    void parseHit(const QDomNode &xml);
    void parseHsp(const QDomNode &xml,const QString &id, const QString &def, const QString &accession);
};

class HttpRequestCDD:public HttpRequest {
public:
    HttpRequestCDD(Task *_task):HttpRequest(_task){};
    virtual void sendRequest(const QString &program,const QString &query);
    virtual void parseResult(ResponseBuffer &buf);

private:
    static const QString host;
    void parseHit(QByteArray &b,ResponseBuffer &buf);
    QString extractText(const QByteArray &b);
    bool getLocations(QByteArray &b,int &from, int &to);
};

}

#endif
