/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _REMOTE_QUERY_WORKER_
#define _REMOTE_QUERY_WORKER_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>

#include "RemoteQueryTask.h"
#include "RemoteQueryConsts.h"

namespace GB2 {
namespace LocalWorkflow {

class RemoteQueryPrompter;
typedef PrompterBase<RemoteQueryPrompter> RemoteQueryPrompterBase;

class RemoteQueryPrompter : public RemoteQueryPrompterBase {
    Q_OBJECT
public:
    RemoteQueryPrompter(Actor* p = 0) : RemoteQueryPrompterBase(p) {}
protected:
    QString composeRichDoc();
};


class RemoteQueryWorker: public BaseWorker {
    Q_OBJECT
public:
    RemoteQueryWorker(Actor *a) : BaseWorker(a), input(NULL), output(NULL) {}
    virtual void init();
    virtual bool isReady();
    virtual bool isDone();
    virtual Task* tick();
    virtual void cleanup() {};
private slots:
    void sl_taskFinished();
protected:
    CommunicationChannel *input, *output;
    //QString resultName,transId;
    RemoteQueryTaskSettings cfg;
};

class RemoteQueryWorkerFactory:public DomainFactory {
    static const QString ACTOR_ID;
public:
    static void init();
    RemoteQueryWorkerFactory() : DomainFactory(ACTOR_ID) {}
    virtual Worker* createWorker(Actor* a) {return new RemoteQueryWorker(a);}

};

}
}




#endif
