/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ViewMatrixDialogController.h"

#include <core_api/AppContext.h>
#include <core_api/DNAAlphabet.h>

#include <util_weight_matrix/DIProperties.h>

#include <QtGui/QTableWidget>
#include <QtGui/QTableWidgetItem>

namespace GB2 {

ViewMatrixDialogController::ViewMatrixDialogController(QWidget *w) 
    : QDialog(w), logoArea(NULL) {

    setupUi(this);
    connect(closeButton, SIGNAL(clicked()), SLOT(sl_onCloseButton()));
}

ViewMatrixDialogController::ViewMatrixDialogController(PFMatrix matrix, QWidget *w) 
: QDialog(w), logoArea(NULL) {

    setupUi(this);
    if (matrix.getType() == PFM_MONONUCLEOTIDE) {
        tableWidget->setRowCount(4);
        tableWidget->setColumnCount(matrix.getLength());
        for (int i = 0, n = matrix.getLength(); i < n; i++) {
            tableWidget->setHorizontalHeaderItem(i, new QTableWidgetItem(QString("%1").arg(i + 1)));
        }
        for (int i = 0; i < 4; i++) {
            tableWidget->setVerticalHeaderItem(i, new QTableWidgetItem(QString(DiProperty::fromIndex(i))));
            for (int j = 0, n = matrix.getLength(); j < n; j++) {
                tableWidget->setItem(i, j, new QTableWidgetItem(QString("%1").arg(matrix.getValue(i, j))));
            }
        }
    } else {
        tableWidget->setRowCount(16);
        tableWidget->setColumnCount(matrix.getLength());
        for (int i = 0, n = matrix.getLength(); i < n; i++) {
            tableWidget->setHorizontalHeaderItem(i, new QTableWidgetItem(QString("%1").arg(i + 1)));
        }
        for (int i = 0; i < 16; i++) {
            tableWidget->setVerticalHeaderItem(i, new QTableWidgetItem(QString(DiProperty::fromIndexHi(i))+QString(DiProperty::fromIndexLo(i))));
            for (int j = 0, n = matrix.getLength(); j < n; j++) {
                tableWidget->setItem(i, j, new QTableWidgetItem(QString("%1").arg(matrix.getValue(i, j))));
            }
        }
    }
    tableWidget->resizeRowsToContents();

    tableWidget->resize(tableWidget->minimumSizeHint());

    int bitsize = 30;
    int logoheight = 150;

    int len = matrix.getLength();
    int size = 0;
    int n = matrix.getType() == PFM_MONONUCLEOTIDE ? 4 : 16;

    for (int i = 0; i < n; i++) {
        size += matrix.getValue(i, 0);
    }

    QList<MAlignmentRow> rows;
    for (int i = 0; i < size; i++) {
        QByteArray arr;
        for (int j = 0; j < len; j++) {
            int row = 0;
            int sum = i;
            while (row < n && sum >= matrix.getValue(row, j)) {
                sum -= matrix.getValue(row, j);
                row++;
            }
            if (row == n) row--;
            if (matrix.getType() == PFM_MONONUCLEOTIDE) {
                arr.append(DiProperty::fromIndex(row));
            } else {
                arr.append(DiProperty::fromIndexHi(row));
                if (j == len - 1) {
                    arr.append(DiProperty::fromIndexLo(row));
                }
            }
        }
        rows.append(MAlignmentRow("", arr));
    }
    DNAAlphabet* al = AppContext::getDNAAlphabetRegistry()->findById(BaseDNAAlphabetIds::NUCL_DNA_DEFAULT);
    MAlignment ma(QString("Temporary alignment"), al, rows);
    AlignmentLogoSettings logoSettings(ma);
    logoSettings.bitSize = bitsize;
    logoWidget->resize(logoWidget->width(), logoheight);
    logoWidget->setMinimumHeight(logoheight);
    if (logoArea != NULL) {
        logoArea->replaceSettings(logoSettings);   
    } else {
        logoArea = new AlignmentLogoRenderArea(logoSettings, logoWidget);
    }
    logoArea->repaint();
    this->resize(this->width(), this->minimumHeight());
    connect(closeButton, SIGNAL(clicked()), SLOT(sl_onCloseButton()));
}

ViewMatrixDialogController::ViewMatrixDialogController(PWMatrix matrix, QWidget *w) 
: QDialog(w), logoArea(NULL) {

    setupUi(this);
    if (matrix.getType() == PWM_MONONUCLEOTIDE) {
        tableWidget->setRowCount(4);
        tableWidget->setColumnCount(matrix.getLength());
        for (int i = 0, n = matrix.getLength(); i < n; i++) {
            tableWidget->setHorizontalHeaderItem(i, new QTableWidgetItem(QString("%1").arg(i + 1)));
        }
        for (int i = 0; i < 4; i++) {
            tableWidget->setVerticalHeaderItem(i, new QTableWidgetItem(QString(DiProperty::fromIndex(i))));
            for (int j = 0, n = matrix.getLength(); j < n; j++) {
                tableWidget->setItem(i, j, new QTableWidgetItem(QString("%1").arg(matrix.getValue(i, j))));
            }
        }
    } else {
        tableWidget->setRowCount(16);
        tableWidget->setColumnCount(matrix.getLength());
        for (int i = 0, n = matrix.getLength(); i < n; i++) {
            tableWidget->setHorizontalHeaderItem(i, new QTableWidgetItem(QString("%1").arg(i + 1)));
        }
        for (int i = 0; i < 16; i++) {
            tableWidget->setVerticalHeaderItem(i, new QTableWidgetItem(QString(DiProperty::fromIndexHi(i))+QString(DiProperty::fromIndexLo(i))));
            for (int j = 0, n = matrix.getLength(); j < n; j++) {
                tableWidget->setItem(i, j, new QTableWidgetItem(QString("%1").arg(matrix.getValue(i, j))));
            }
        }
    }
    tableWidget->resize(tableWidget->minimumSizeHint());
    this->resize(this->width(), this->minimumHeight());
    connect(closeButton, SIGNAL(clicked()), SLOT(sl_onCloseButton()));
}

void ViewMatrixDialogController::sl_onCloseButton() {
    QDialog::reject();
}

} //namespace