/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_WORFLOW_SIMPLE_LOCAL_TASK_H_
#define _GB2_WORFLOW_SIMPLE_LOCAL_TASK_H_

#include <distributed_computing/LocalTask.h>
#include <core_api/VirtualFileSystem.h>
#include <distributed_computing/RemoteMachine.h>
#include <distributed_computing/RemoteTask.h>

#include <workflow/Schema.h>
#include <workflow_support/WorkflowRunTask.h>

namespace GB2 {

using namespace Workflow;

class WorkflowSimpleLocalTaskSettings : public LocalTaskSettings {
public:
    static const int SERIALIZED_LIST_SZ = 4;
    static const QString ITERATIONS_ROOT_ELEMENT_NAME;
    
public:
    WorkflowSimpleLocalTaskSettings();
    WorkflowSimpleLocalTaskSettings( const Schema & sc, const QList< Iteration > & it, const VirtualFileSystem & vfs, const QString & );
    ~WorkflowSimpleLocalTaskSettings();
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
    Schema getSchema() const;
    QList<Iteration> getIterations() const;
    VirtualFileSystem & getVFS();
    QString getOutVfsName() const;
    
private:
    Schema              schema;
    QList< Iteration >  iterations;
    VirtualFileSystem   vfs;        // input files
    QString             outVfsName;
    
}; // WorkflowSimpleLocalTaskSettings

class WorkflowSimpleLocalTaskResult : public LocalTaskResult {
public:
    WorkflowSimpleLocalTaskResult();
    WorkflowSimpleLocalTaskResult( const VirtualFileSystem & vfs );
    virtual ~WorkflowSimpleLocalTaskResult();
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
    void setResult( const VirtualFileSystem & v );
    VirtualFileSystem getVfs() const;
    
private:
    VirtualFileSystem vfs; // output files to write
    
}; // WorkflowSimpleLocalTaskResult

class WorkflowSimpleLocalTask : public LocalTask {
    Q_OBJECT
public:
    // takes responsibility for settings
    WorkflowSimpleLocalTask( WorkflowSimpleLocalTaskSettings * settings );
    virtual ~WorkflowSimpleLocalTask();
    
    virtual void prepare();
    virtual ReportResult report();
    
    virtual const LocalTaskResult * getResult() const;
    
    virtual QString generateReport() const;
    
private:
    WorkflowSimpleLocalTaskSettings *   settings;
    WorkflowSimpleLocalTaskResult       result;
    WorkflowRunTask *                   workflowTask;
    
}; // WorfklowSimpleLocalTask

typedef SimpleLocalTaskFactoryImpl< WorkflowSimpleLocalTaskSettings, WorkflowSimpleLocalTask, WorkflowSimpleLocalTaskResult >
    WorkflowSimpleLocalTaskFactory;

class WorkflowRemoteRunTask : public Task {
    Q_OBJECT
public:
    WorkflowRemoteRunTask( RemoteMachineSettings * m, const Schema & sc, const QList<Iteration> & its );
    ~WorkflowRemoteRunTask();
    
    
    virtual void prepare();
    virtual ReportResult report();
    virtual QString generateReport() const;
    
private:
    // add url_location parameter to actors if there are no
    void preprocessSchema();
    
private:
    RemoteMachineSettings * machineSettings;
    RemoteMachine *         machine;
    Schema                  schema;
    QList<Iteration>        iterations;
    RemoteTask *            workflowTask;
    
}; // WorkflowRemoteRunTask

} // GB2

#endif // _GB2_WORFLOW_SIMPLE_LOCAL_TASK_H_
