/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "BowtieConstants.h"
#include "BowtiePlugin.h"
#include "BowtieTask.h"
#include "BowtieSettingsWidget.h"

#include <core_api/AppContext.h>
#include <core_api/Task.h>
#include <core_api/Log.h>
#include <core_api/DnaAssemblyAlgRegistry.h>

#include <workflow/WorkflowEnv.h>

#include <util_algorithm/GAutoDeleteList.h>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTest.h>
#include <test_framework/GTestFrameworkComponents.h>

#include "bowtie_tests/bowtieTests.h"
#include "BowtieWorker.h"

#define BOWTIE_ALG_NAME "Bowtie"

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    BowtiePlugin * plug = new BowtiePlugin();
    return plug;
}

LogCategory log(ULOG_CAT_BOWTIE);

const QString BowtiePlugin::EBWT_INDEX_TYPE_ID("ebwt");

DataTypePtr BowtiePlugin::EBWT_INDEX_TYPE()
{
	DataTypeRegistry* dtr = WorkflowEnv::getDataTypeRegistry();
	assert(dtr);
	static bool startup = true;
	if (startup)
	{
		dtr->registerEntry(DataTypePtr(new DataType(EBWT_INDEX_TYPE_ID, tr("EBWT index"), tr("EBWT Index for bowtie"))));
		startup = false;
	}
	return dtr->getById(EBWT_INDEX_TYPE_ID);
}
    
BowtiePlugin::BowtiePlugin() 
: Plugin(tr("Bowtie"), 
		 tr("An ultrafast memory-efficient short read aligner, http://bowtie-bio.sourceforge.net")),
         ctx(NULL)
{
	GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = BowtieTests ::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        Q_UNUSED(res);
        assert(res);
    }

	DnaAssemblyAlgRegistry* registry = AppContext::getDnaAssemblyAlgRegistry();

	if (AppContext::getMainWindow()) {
		DnaAssemblyGUIExtensionFactory* guiFactory = new BowtieSettingsWidget::Factory;
		registry->registerGUIExtension(BowtieTask::taskName, guiFactory);
	}

	DnaAssemblyToRefTaskFactory* taskFactory = new BowtieTask::Factory();
 	registry->registerTask(BOWTIE_ALG_NAME, taskFactory);

	LocalWorkflow::BowtieWorkerFactory::init();
	LocalWorkflow::BowtieBuildWorkerFactory::init();
	LocalWorkflow::BowtieIndexReaderWorkerFactory::init();
}

BowtiePlugin::~BowtiePlugin() {
    //nothing to do
}

}//namespace

