/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <QtGui/QMessageBox>

#include <core_api/AppContext.h>
#include <distributed_computing/RemoteMachineMonitor.h>
#include <distributed_computing/DistributedComputingUtil.h>
#include <util_gui/RemoteMachineMonitorDialogImpl.h>

//#include <Kalign_local_task/KalignLocalTask.h>
#include "KalignDialogController.h"

/* TRANSLATOR GB2::KalignDialogController */    

namespace GB2 {

KalignDialogController::KalignDialogController(QWidget* w, const MAlignment& _ma, KalignTaskSettings& _settings) 
: QDialog(w), ma(_ma), settings(_settings)
{
    setupUi(this);
//    connect( remoteRunPushButton, SIGNAL( clicked() ), SLOT( sl_remoteRunButtonClicked() ) );
}

void KalignDialogController::accept() {

	if(gapOpenCheckBox->isChecked()) {
		settings.gapOpenPenalty = gapOpenSpinBox->value();
	}
	if(gapExtensionPenaltyCheckBox->isChecked()) {
		settings.gapExtenstionPenalty = gapExtensionPenaltySpinBox->value();
	}
	if(terminalGapCheckBox->isChecked()) {
		settings.termGapPenalty = terminalGapSpinBox->value();
	}

    /*if (wholeRangeRB->isChecked()) {
        settings.regionToAlign = LRegion(0, ma.getLength());
        settings.alignRegion = false;
    } else {
        int startPos = rangeStartSB->value() - 1;
        int endPos = rangeEndSB->value();
        if (endPos - startPos < 2) {
            QMessageBox::critical(NULL, tr("Error"), tr("Illegal alignment region"));
            rangeStartSB->setFocus();
            return;
        }
        settings.alignRegion = true;
        settings.regionToAlign = LRegion(startPos,  endPos - startPos);
    }*/

    QDialog::accept();
}
}//namespace

