/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_KALIGN_TASK_H_
#define _GB2_KALIGN_TASK_H_

#include <core_api/Task.h>
#include <gobjects/MAlignmentObject.h>
#include <util_tasks/TLSTask.h>
#include <QtCore/QPointer>

#define KALIGN_CONTEXT_ID "kalign"

struct kalign_context;

namespace GB2 {

class StateLock;
class MAlignmentObject;
class LoadDocumentTask;

class KalignContext : public TLSContext {
public:
	KalignContext(kalign_context* _d) : TLSContext(KALIGN_CONTEXT_ID), d(_d) { }
	kalign_context* d;
};

class KalignTaskSettings {
public:
	KalignTaskSettings() {reset();}
	void reset();

	float gapOpenPenalty;
	float gapExtenstionPenalty;
	float termGapPenalty;
	float secret;
	//used only for KalignTaskOp_DoAlign
	//bool            alignRegion;
	//LRegion         regionToAlign;
};

class KalignTask : public TLSTask {
	Q_OBJECT
public:
	KalignTask(const MAlignment& ma, const KalignTaskSettings& config);

	void _run();
	void doAlign();
	ReportResult report();

	KalignTaskSettings          config;
	MAlignment                  inputMA;
	MAlignment                  resultMA;

	MAlignment                  inputSubMA;
	MAlignment                  resultSubMA;
protected:
	TLSContext* createContextInstance();
};

//locks MAlignment object and propagate KalignTask results to it
class  KalignGObjectTask : public Task {
	Q_OBJECT
public:
	KalignGObjectTask(MAlignmentObject* obj, const KalignTaskSettings& config);
	~KalignGObjectTask();

	virtual void prepare();
	ReportResult report();

	QPointer<MAlignmentObject>  obj;
	StateLock*                  lock;
	KalignTask*                 kalignTask;
	KalignTaskSettings          config;
};
}//namespace

#endif
