/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SITECON_SEARCH_TASK_H_
#define _GB2_SITECON_SEARCH_TASK_H_

#include "SiteconAlgorithm.h"

#include <core_api/LRegion.h>
#include <datatype/AnnotationData.h>
#include <util_tasks/SequenceWalkerTask.h>

#include <QtCore/QMutex>

namespace GB2 {

class SiteconSearchResult {
public:
    SiteconSearchResult() : complement(false), psum(-1), err1(0), err2(1){}

    SharedAnnotationData toAnnotation(const QString& name) const {
        SharedAnnotationData data;
        data = new AnnotationData;
        data->name = name;
        data->location.append(region);
        data->aminoStrand = TriState_No;
        data->complement = complement;
        if (!modelInfo.isEmpty()) {
            data->qualifiers.append(Qualifier("sitecon_model", modelInfo));
        }
        data->qualifiers.append(Qualifier("psum", QString::number(psum)));
        data->qualifiers.append(Qualifier("error_1", QString::number(err1, 'g', 4)));
        data->qualifiers.append(Qualifier("error_2", QString::number(err2, 'g', 4)));
        return data;
    }

    static QList<SharedAnnotationData> toTable(const QList<SiteconSearchResult>& res, const QString& name)
    {
        QList<SharedAnnotationData> list;
        foreach (const SiteconSearchResult& f, res) {
            list.append(f.toAnnotation(name));
        }
        return list;
    }


    LRegion region;
    bool    complement;
    float   psum;
    float   err1;
    float   err2;
    QString modelInfo;
};

class SiteconSearchCfg {
public:
    SiteconSearchCfg() : minPSUM(0), minE1(0.), maxE2(1.), complTT(NULL), complOnly(false) {}
    int minPSUM;
    float minE1;
    float maxE2;
    DNATranslation* complTT;
    bool complOnly; //FIXME use strand instead
};

class SiteconSearchTask : public Task, public SequenceWalkerCallback {
    Q_OBJECT
public:
    SiteconSearchTask(const SiteconModel& model, const char* seq, int len, const SiteconSearchCfg& cfg, int resultsOffset);
    
    virtual void onRegion(SequenceWalkerSubtask* t, TaskStateInfo& ti);
    QList<SiteconSearchResult> takeResults();

private:
    void addResult(const SiteconSearchResult& r);

    QMutex                      lock;
    SiteconModel                model;
    SiteconSearchCfg            cfg;
    QList<SiteconSearchResult>  results;
    int                         resultsOffset;
};

}//namespace

#endif
