/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_UMUSCLE_PLUGIN_H_
#define _GB2_UMUSCLE_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <core_api/ObjectViewModel.h>

#include <QtGui/QMenu>

#include <muscle_local_task/MuscleLocalTask.h>

namespace GB2 {

class MSAEditor;
class MuscleMSAEditorContext;
class XMLTestFactory;

class MusclePlugin : public Plugin {
    Q_OBJECT
public:
    MusclePlugin();
    ~MusclePlugin();

private:
    MuscleMSAEditorContext* ctx;
    MuscleLocalTaskFactory  muscleLocalTaskFactory;
    
};


class MuscleMSAEditorContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    MuscleMSAEditorContext(QObject* p);

protected slots:
    void sl_align();
    void sl_alignSequencesToProfile();
    void sl_alignProfileToProfile();

protected:
    virtual void initViewContext(GObjectView* view);
    virtual void buildMenu(GObjectView* v, QMenu* m);
};

class MuscleAction : public GObjectViewAction {
    Q_OBJECT
public:
    MuscleAction(QObject* p, GObjectView* v, const QString& text, int order) 
		: GObjectViewAction(p, v, text, order) {}

    MSAEditor*  getMSAEditor() const;

private slots:
    void sl_lockedStateChanged();
};

} //namespace

#endif
