/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOG_DRIVER_H_
#define _GB2_LOG_DRIVER_H_

#include <core_api/Log.h>
#include <core_services/LogSettings.h>

namespace GB2 {

class LogDriver : public QObject {
    Q_OBJECT
public:
    static const QString LOG_NO_SHOW_DATE_CMD_OPTION;
    static const QString LOG_NO_SHOW_LEVEL_CMD_OPTION;
    static const QString LOG_NO_SHOW_CATEGORY_CMD_OPTION;
    static const QString LOG_LEVEL_NONE_CMD_OPTION;
    static const QString LOG_LEVEL_ERROR_CMD_OPTION;
    static const QString LOG_LEVEL_INFO_CMD_OPTION;
    static const QString LOG_LEVEL_DETAILS_CMD_OPTION;
    static const QString LOG_LEVEL_TRACE_CMD_OPTION;
    static const QString LOG_SETTINGS_ACTIVE_FLAG;
    static const QString COLOR_OUTPUT_CMD_OPTION;
    static const QString TEAMCITY_OUTPUT_CMD_OPTION;
    
private:
    static bool helpRegistered;
    static void setLogCmdlineHelp();
    
public:
    LogDriver();
    virtual ~LogDriver() {}

    bool print_to_console;
    LogSettings* getSettings() {return &settings;}

private:
    void setCmdLineSettings();
    
private slots:
    void sl_onMessage(const LogMessage& msg);
    QString prepareText(const LogMessage& msg) const;

private:
    LogSettings settings;
};

} //namespace

#endif
