/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#include <QtCore/QDir>
#include <QtCore/QVariant>

#include <core_api/AppContext.h>
#include <core_api/PluginModel.h>
#include <cmdline/CMDLineRegistry.h>
#include <cmdline/CMDLineHelpProvider.h>
#include <distributed_computing/LocalTaskManager.h>

#include "MachineInfoWriter.h"

namespace GB2 {

const QString MachineInfoWriter::CREATE_MACHINE_INFO_FILE_CMD_OPTION = "local-task-info";

bool MachineInfoWriter::helpRegistered = false;

MachineInfoWriter::MachineInfoWriter() {
    if( !helpRegistered ) {
        setMachineInfoCmdlineHelp();
    }
    
    if( AppContext::getCMDLineRegistry()->hasParameter( CREATE_MACHINE_INFO_FILE_CMD_OPTION ) ) {
        connect( AppContext::getPluginSupport(), SIGNAL( si_allStartUpPluginsLoaded() ), SLOT( sl_writeMachineInfoFile() ) );
    }
}

void MachineInfoWriter::setMachineInfoCmdlineHelp() {
    assert( !helpRegistered );
    helpRegistered = false;
    
    CMDLineRegistry * cmdLineRegistry = AppContext::getCMDLineRegistry();
    assert( NULL != cmdLineRegistry );
    
    CMDLineHelpProvider * createMachineInfoSection = new CMDLineHelpProvider( CREATE_MACHINE_INFO_FILE_CMD_OPTION,
        tr( "Create machine info file" ) );
    cmdLineRegistry->registerCMDLineHelpProvider( createMachineInfoSection );
}

void MachineInfoWriter::sl_writeMachineInfoFile() {
    QDir tasksDirectory = QDir::homePath();
    QVariantMap machineInfoMap; // FIXME: move sftp constants to one place
    machineInfoMap.insert( "uuid", LocalTaskManager::getUuid().toString() );
    machineInfoMap.insert( "servicesList", LocalTaskManager::getServicesList() );
    machineInfoMap.insert( "hostname", LocalTaskManager::getHostName() );
    QVariantList resultList;
    resultList << RemoteTaskError( true, "" ).serialize();
    resultList << QVariant( machineInfoMap );
    
    QFile machineInfoFile( tasksDirectory.absoluteFilePath( "machineInfo" ) );
    machineInfoFile.open( QIODevice::WriteOnly );
    QDataStream stream( &machineInfoFile );
    stream << resultList;
    machineInfoFile.close();
}

} // GB2
