//
// Copyright 2022 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: cpld_interface_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // SIGNATURE_REGISTER         : 0x0 (cpld_interface_regs.v)
  // SCRATCH_REGISTER           : 0xC (cpld_interface_regs.v)
  // IPASS_CONTROL              : 0x10 (cpld_interface_regs.v)
  // MOTHERBOARD_CPLD_DIVIDER   : 0x20 (cpld_interface_regs.v)
  // DAUGHTERBOARD_CPLD_DIVIDER : 0x24 (cpld_interface_regs.v)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group CPLD_INTERFACE_REGS
//===============================================================================

  // SIGNATURE_REGISTER Register (from cpld_interface_regs.v)
  localparam SIGNATURE_REGISTER = 'h0; // Register Offset
  localparam SIGNATURE_REGISTER_SIZE = 32;  // register width in bits
  localparam SIGNATURE_REGISTER_MASK = 32'hFFFFFFFF;
  localparam PRODUCT_SIGNATURE_SIZE = 32;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE
  localparam PRODUCT_SIGNATURE_MSB  = 31;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE
  localparam PRODUCT_SIGNATURE      =  0;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE

  // SCRATCH_REGISTER Register (from cpld_interface_regs.v)
  localparam SCRATCH_REGISTER = 'hC; // Register Offset
  localparam SCRATCH_REGISTER_SIZE = 32;  // register width in bits
  localparam SCRATCH_REGISTER_MASK = 32'h0;

//===============================================================================
// Register Group CPLD_SPI_CONTROL_REGS
//===============================================================================

  // MOTHERBOARD_CPLD_DIVIDER Register (from cpld_interface_regs.v)
  localparam MOTHERBOARD_CPLD_DIVIDER = 'h20; // Register Offset
  localparam MOTHERBOARD_CPLD_DIVIDER_SIZE = 32;  // register width in bits
  localparam MOTHERBOARD_CPLD_DIVIDER_MASK = 32'hFFFF;
  localparam MB_DIVIDER_SIZE = 16;  //MOTHERBOARD_CPLD_DIVIDER:MB_DIVIDER
  localparam MB_DIVIDER_MSB  = 15;  //MOTHERBOARD_CPLD_DIVIDER:MB_DIVIDER
  localparam MB_DIVIDER      =  0;  //MOTHERBOARD_CPLD_DIVIDER:MB_DIVIDER

  // DAUGHTERBOARD_CPLD_DIVIDER Register (from cpld_interface_regs.v)
  localparam DAUGHTERBOARD_CPLD_DIVIDER = 'h24; // Register Offset
  localparam DAUGHTERBOARD_CPLD_DIVIDER_SIZE = 32;  // register width in bits
  localparam DAUGHTERBOARD_CPLD_DIVIDER_MASK = 32'hFFFF;
  localparam DB_DIVIDER_SIZE = 16;  //DAUGHTERBOARD_CPLD_DIVIDER:DB_DIVIDER
  localparam DB_DIVIDER_MSB  = 15;  //DAUGHTERBOARD_CPLD_DIVIDER:DB_DIVIDER
  localparam DB_DIVIDER      =  0;  //DAUGHTERBOARD_CPLD_DIVIDER:DB_DIVIDER

//===============================================================================
// Register Group IPASS_REGS
//===============================================================================

  // IPASS_CONTROL Register (from cpld_interface_regs.v)
  localparam IPASS_CONTROL = 'h10; // Register Offset
  localparam IPASS_CONTROL_SIZE = 32;  // register width in bits
  localparam IPASS_CONTROL_MASK = 32'h1;
  localparam IPASS_ENABLE_TRANSFER_SIZE = 1;  //IPASS_CONTROL:IPASS_ENABLE_TRANSFER
  localparam IPASS_ENABLE_TRANSFER_MSB  = 0;  //IPASS_CONTROL:IPASS_ENABLE_TRANSFER
  localparam IPASS_ENABLE_TRANSFER      = 0;  //IPASS_CONTROL:IPASS_ENABLE_TRANSFER
