;;;
;;; Copyright (c) 2003,2004 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;; Japanese EUC
(define ja-rk-rule
  '(
    ((("-"). ())("" "" ""))
    (((","). ())("" "" ""))
    ((("."). ())("" "" ""))
    ((("!"). ())("" "" "!"))
    ((("\""). ())("" "" "\""))
    ((("#"). ())("" "" "#"))
    ((("$"). ())("" "" "$"))
    ((("%"). ())("" "" "%"))
    ((("&"). ())("" "" "&"))
    ((("'"). ())("" "" "'"))
    ((("("). ())("" "" "("))
    (((")"). ())("" "" ")"))
    ((("~"). ())("" "" "~"))
    ((("="). ())("" "" "="))
    ((("^"). ())("" "" "^"))
    ((("\\"). ())("" "" "\\"))
    ((("|"). ())("" "" "|"))
    ((("`"). ())("" "" "`"))
    ((("@"). ())("" "" "@"))
    ((("{"). ())("" "" "{"))
    ((("["). ())("" "" ""))
    ((("+"). ())("" "" "+"))
    (((";"). ())("" "" ";"))
    ((("*"). ())("" "" "*"))
    (((":"). ())("" "" ":"))
    ((("}"). ())("" "" "}"))
    ((("]"). ())("" "" ""))
    ((("<"). ())("" "" "<"))
    (((">"). ())("" "" ">"))
    ((("?"). ())("" "" "?"))
    ((("/"). ())("" "" "/"))
    ((("_"). ())("" "" "_"))
    
    ((("1"). ())("1" "1" "1"))
    ((("2"). ())("2" "2" "2"))
    ((("3"). ())("3" "3" "3"))
    ((("4"). ())("4" "4" "4"))
    ((("5"). ())("5" "5" "5"))
    ((("6"). ())("6" "6" "6"))
    ((("7"). ())("7" "7" "7"))
    ((("8"). ())("8" "8" "8"))
    ((("9"). ())("9" "9" "9"))
    ((("0"). ())("0" "0" "0"))

    ((("a"). ())("" "" ""))
    ((("i"). ())("" "" ""))
    ((("u"). ())("" "" ""))
    ((("e"). ())("" "" ""))
    ((("o"). ())("" "" ""))

    ((("x" "a"). ())("" "" ""))
    ((("x" "i"). ())("" "" ""))
    ((("x" "u"). ())("" "" ""))
    ((("x" "e"). ())("" "" ""))
    ((("x" "o"). ())("" "" ""))

    ((("k" "k"). ("k"))("" "" ""))

    ((("k" "a"). ())("" "" ""))
    ((("k" "i"). ())("" "" ""))
    ((("k" "u"). ())("" "" ""))
    ((("k" "e"). ())("" "" ""))
    ((("k" "o"). ())("" "" ""))
    ((("k" "y" "a"). ())("" "" ""))
    ((("k" "y" "i"). ())("" "" ""))
    ((("k" "y" "u"). ())("" "" ""))
    ((("k" "y" "e"). ())("" "" ""))
    ((("k" "y" "o"). ())("" "" ""))

    ((("k" "w" "a"). ())("" "" ""))
    ((("k" "w" "i"). ())("" "" ""))
    ((("k" "w" "u"). ())("" "" ""))
    ((("k" "w" "e"). ())("" "" ""))
    ((("k" "w" "o"). ())("" "" ""))
 
    ((("g" "g"). ("g"))("" "" ""))


    ((("g" "a"). ())("" "" ""))
    ((("g" "i"). ())("" "" ""))
    ((("g" "u"). ())("" "" ""))
    ((("g" "e"). ())("" "" ""))
    ((("g" "o"). ())("" "" ""))

    ((("g" "y" "a"). ())("" "" "ގ"))
    ((("g" "y" "i"). ())("" "" "ގ"))
    ((("g" "y" "u"). ())("" "" "ގ"))
    ((("g" "y" "e"). ())("" "" "ގ"))
    ((("g" "y" "o"). ())("" "" "ގ"))

    ((("g" "w" "a"). ())("" "" "ގ"))
    ((("g" "w" "i"). ())("" "" "ގ")) 
    ((("g" "w" "u"). ())("" "" "ގ")) 
    ((("g" "w" "e"). ())("" "" "ގ")) 
    ((("g" "w" "o"). ())("" "" "ގ"))

    ((("s" "s"). ("s"))("" "" ""))

    ((("s" "s"). ())("s" "s" "s"))
    ((("s" "a"). ())("" "" ""))
    ((("s" "i"). ())("" "" ""))
    ((("s" "u"). ())("" "" ""))
    ((("s" "e"). ())("" "" ""))
    ((("s" "o"). ())("" "" ""))
    
    ((("s" "y" "a"). ())("" "" ""))
    ((("s" "y" "i"). ())("" "" ""))
    ((("s" "y" "u"). ())("" "" ""))
    ((("s" "y" "e"). ())("" "" ""))
    ((("s" "y" "o"). ())("" "" ""))
    
    ((("s" "h" "a"). ())("" "" ""))
    ((("s" "h" "i"). ())("" "" ""))
    ((("s" "h" "u"). ())("" "" ""))
    ((("s" "h" "e"). ())("" "" ""))
    ((("s" "h" "o"). ())("" "" ""))

    ((("s" "w" "a"). ())("" "" ""))
    ((("s" "w" "i"). ())("" "" ""))
    ((("s" "w" "u"). ())("" "" ""))
    ((("s" "w" "e"). ())("" "" ""))
    ((("s" "w" "o"). ())("" "" "")) 
    
    ((("z" "z"). ("z"))("" "" ""))

    ((("z" "a"). ())("" "" ""))
    ((("z" "i"). ())("" "" ""))
    ((("z" "u"). ())("" "" ""))
    ((("z" "e"). ())("" "" ""))
    ((("z" "o"). ())("" "" ""))
    ((("z" "y" "a"). ())("" "" "ގ"))
    ((("z" "y" "i"). ())("" "" "ގ"))
    ((("z" "y" "u"). ())("" "" "ގ"))
    ((("z" "y" "e"). ())("" "" "ގ"))
    ((("z" "y" "o"). ())("" "" "ގ"))
    
    ((("j" "j"). ("j"))("" "" ""))

    ((("j" "a"). ())("" "" "ގ"))
    ((("j" "i"). ())("" "" ""))
    ((("j" "u"). ())("" "" "ގ"))
    ((("j" "e"). ())("" "" "ގ"))
    ((("j" "o"). ())("" "" "ގ"))

    ((("j" "y" "a"). ())("" "" "ގ"))
    ((("j" "y" "i"). ())("" "" "ގ"))
    ((("j" "y" "u"). ())("" "" "ގ"))
    ((("j" "y" "e"). ())("" "" "ގ"))
    ((("j" "y" "o"). ())("" "" "ގ"))

    ((("t" "t"). ("t"))("" "" ""))
    ((("t" "c"). ("c"))("" "" ""))

    ((("t" "a"). ())("" "" ""))
    ((("t" "i"). ())("" "" ""))
    ((("t" "u"). ())("" "" ""))
    ((("t" "e"). ())("" "" ""))
    ((("t" "o"). ())("" "" ""))

    ((("t" "y" "a"). ())("" "" ""))
    ((("t" "y" "i"). ())("" "" ""))
    ((("t" "y" "u"). ())("" "" ""))
    ((("t" "y" "e"). ())("" "" ""))
    ((("t" "y" "o"). ())("" "" ""))

    ((("t" "w" "a"). ())("Ȥ" "ȥ" "Ď"))
    ((("t" "w" "i"). ())("Ȥ" "ȥ" "Ď"))
    ((("t" "w" "u"). ())("Ȥ" "ȥ" "Ď"))
    ((("t" "w" "e"). ())("Ȥ" "ȥ" "Ď"))
    ((("t" "w" "o"). ())("Ȥ" "ȥ" "Ď"))

    ((("t" "h" "a"). ())("Ƥ" "ƥ" "Î"))
    ((("t" "h" "i"). ())("Ƥ" "ƥ" "Î"))
    ((("t" "h" "u"). ())("Ƥ" "ƥ" "Î"))
    ((("t" "h" "e"). ())("Ƥ" "ƥ" "Î"))
    ((("t" "h" "o"). ())("Ƥ" "ƥ" "Î"))
    
    ((("t" "s" "a"). ())("Ĥ" "ĥ" ""))
    ((("t" "s" "i"). ())("Ĥ" "ĥ" ""))
    ((("t" "s" "u"). ())(""   ""   ""))
    ((("t" "s" "e"). ())("Ĥ" "ĥ" ""))
    ((("t" "s" "o"). ())("Ĥ" "ĥ" ""))    

    ((("c" "h" "a"). ())("" "" ""))
    ((("c" "h" "i"). ())("" "" ""))
    ((("c" "h" "u"). ())("" "" ""))
    ((("c" "h" "e"). ())("" "" ""))
    ((("c" "h" "o"). ())("" "" ""))
    
    ((("x" "t" "u"). ())("" "" ""))
    ((("x" "t" "s" "u"). ())("" "" ""))
    ((("c" "c"). ("c"))("" "" ""))

    ((("d" "d"). ("d"))("" "" ""))

    ((("d" "a"). ())("" "" ""))
    ((("d" "i"). ())("" "" ""))
    ((("d" "u"). ())("" "" ""))
    ((("d" "e"). ())("" "" "Î"))
    ((("d" "o"). ())("" "" "Ď"))

    ((("d" "y" "a"). ())("¤" "¥" "ގ"))
    ((("d" "y" "i"). ())("¤" "¥" "ގ"))
    ((("d" "y" "u"). ())("¤" "¥" "ގ"))
    ((("d" "y" "e"). ())("¤" "¥" "ގ"))
    ((("d" "y" "o"). ())("¤" "¥" "ގ"))

    ((("d" "h" "a"). ())("Ǥ" "ǥ" "Îގ"))
    ((("d" "h" "i"). ())("Ǥ" "ǥ" "Îގ"))
    ((("d" "h" "u"). ())("Ǥ" "ǥ" "Îގ"))
    ((("d" "h" "e"). ())("Ǥ" "ǥ" "Îގ"))
    ((("d" "h" "o"). ())("Ǥ" "ǥ" "Îގ"))


    ((("d" "w" "a"). ())("ɤ" "ɥ" " ގ"))
    ((("d" "w" "i"). ())("ɤ" "ɥ" " ގ"))
    ((("d" "w" "u"). ())("ɤ" "ɥ" "Ďގ"))
    ((("d" "w" "e"). ())("ɤ" "ɥ" " ގ"))
    ((("d" "w" "o"). ())("ɤ" "ɥ" " ގ"))

    ((("n" "n"). ())("" "" ""))
    ((("n"). ())("" "" ""))
    ((("n" ""). ())("" "" ""))

    ((("n" "a"). ())("" "" ""))
    ((("n" "i"). ())("" "" ""))
    ((("n" "u"). ())("" "" ""))
    ((("n" "e"). ())("" "" ""))
    ((("n" "o"). ())("" "" ""))

    ((("n" "y" "a"). ())("ˤ" "˥" "Ǝ"))
    ((("n" "y" "i"). ())("ˤ" "˥" "Ǝ"))
    ((("n" "y" "u"). ())("ˤ" "˥" "Ǝ"))
    ((("n" "y" "e"). ())("ˤ" "˥" "Ǝ"))
    ((("n" "y" "o"). ())("ˤ" "˥" "Ǝ"))

    ((("h" "h"). ("h"))("" "" ""))

    ((("h" "a"). ())("" "" ""))
    ((("h" "i"). ())("" "" ""))
    ((("h" "u"). ())("" "" ""))
    ((("h" "e"). ())("" "" ""))
    ((("h" "o"). ())("" "" ""))
    
    ((("h" "y" "a"). ())("Ҥ" "ҥ" "ˎ"))
    ((("h" "y" "i"). ())("Ҥ" "ҥ" "ˎ"))
    ((("h" "y" "u"). ())("Ҥ" "ҥ" "ˎ"))
    ((("h" "y" "e"). ())("Ҥ" "ҥ" "ˎ"))
    ((("h" "y" "o"). ())("Ҥ" "ҥ" "ˎ"))

    ((("f" "f"). ("f"))("" "" ""))

    ((("f" "a"). ())("դ" "ե" "̎"))
    ((("f" "i"). ())("դ" "ե" "̎"))
    ((("f" "u"). ())("" "" ""))
    ((("f" "e"). ())("դ" "ե" "̎"))
    ((("f" "o"). ())("դ" "ե" "̎"))
    
    ((("f" "y" "a"). ())("դ" "ե" "̎"))
    ((("f" "y" "i"). ())("դ" "ե" "̎"))
    ((("f" "y" "u"). ())("դ" "ե" "̎"))
    ((("f" "y" "e"). ())("դ" "ե" "̎"))
    ((("f" "y" "o"). ())("դ" "ե" "̎"))

    ((("f" "w" "u"). ())("դ" "ե" "   ")) 

    ((("b" "b"). ("b"))("" "" ""))

    ((("b" "a"). ())("" "" "ʎ"))
    ((("b" "i"). ())("" "" "ˎ"))
    ((("b" "u"). ())("" "" "̎"))
    ((("b" "e"). ())("" "" "͎"))
    ((("b" "o"). ())("" "" "Ύ"))
    
    ((("b" "y" "a"). ())("Ӥ" "ӥ" "ˎގ"))
    ((("b" "y" "i"). ())("Ӥ" "ӥ" "ˎގ"))
    ((("b" "y" "u"). ())("Ӥ" "ӥ" "ˎގ"))
    ((("b" "y" "e"). ())("Ӥ" "ӥ" "ˎގ"))
    ((("b" "y" "o"). ())("Ӥ" "ӥ" "ˎގ"))
    
    ((("p" "p"). ("p"))("" "" ""))

    ((("p" "a"). ())("" "" "ʎ"))
    ((("p" "i"). ())("" "" "ˎ"))
    ((("p" "u"). ())("" "" "̎"))
    ((("p" "e"). ())("" "" "͎"))
    ((("p" "o"). ())("" "" "Ύ"))

    ((("p" "y" "a"). ())("Ԥ" "ԥ" "ˎߎ"))
    ((("p" "y" "i"). ())("Ԥ" "ԥ" "ˎߎ"))
    ((("p" "y" "u"). ())("Ԥ" "ԥ" "ˎߎ"))
    ((("p" "y" "e"). ())("Ԥ" "ԥ" "ˎߎ"))
    ((("p" "y" "o"). ())("Ԥ" "ԥ" "ˎߎ"))

    ((("m" "m"). ("m"))("" "" ""))

    ((("m" "b"). ("b"))("" "" ""))
    ((("m" "p"). ("p"))("" "" ""))

    ((("m" "a"). ())("" "" ""))
    ((("m" "i"). ())("" "" ""))
    ((("m" "u"). ())("" "" ""))
    ((("m" "e"). ())("" "" ""))
    ((("m" "o"). ())("" "" ""))

    ((("m" "y" "a"). ())("ߤ" "ߥ" "Ў"))
    ((("m" "y" "i"). ())("ߤ" "ߥ" "Ў"))
    ((("m" "y" "u"). ())("ߤ" "ߥ" "Ў"))
    ((("m" "y" "e"). ())("ߤ" "ߥ" "Ў"))
    ((("m" "y" "o"). ())("ߤ" "ߥ" "Ў"))

    ((("y" "y"). ("y"))("" "" ""))

    ((("y" "a"). ())("" "" ""))
    ((("y" "u"). ())("" "" ""))
    ((("y" "e"). ())("" "" ""))
    ((("y" "o"). ())("" "" ""))
   
    ((("x" "k" "a"). ())("" "" ""))
    ((("x" "k" "e"). ())("" "" ""))
 
    ((("x" "y" "a"). ())("" "" ""))
    ((("x" "y" "u"). ())("" "" ""))
    ((("x" "y" "o"). ())("" "" ""))

    ((("r" "r"). ("r"))("" "" ""))

    ((("r" "a"). ())("" "" ""))
    ((("r" "i"). ())("" "" ""))
    ((("r" "u"). ())("" "" ""))
    ((("r" "e"). ())("" "" ""))
    ((("r" "o"). ())("" "" ""))
    
    ((("r" "y" "a"). ())("" "" "؎"))
    ((("r" "y" "i"). ())("ꤣ" "ꥣ" "؎"))
    ((("r" "y" "u"). ())("" "" "؎"))
    ((("r" "y" "e"). ())("ꤧ" "ꥧ" "؎"))
    ((("r" "y" "o"). ())("" "" "؎"))

    ((("w" "w"). ("w"))("" "" ""))

    ((("x" "w" "a"). ())("" "" ""))
    ((("w" "a"). ())("" "" ""))
    ((("w" "i"). ())("" "" ""))
    ((("x" "w" "i"). ())("" "" ""))
    ((("w" "u"). ())("" "" ""))
    ((("w" "e"). ())("" "" ""))
    ((("x" "w" "e"). ())("" "" ""))
    ((("w" "o"). ())("" "" ""))
    ((("w" "h" "a"). ())("" "" "")) 
    ((("w" "h" "o"). ())("" "" "")) 

    ((("v" "v"). ("v"))("" "" ""))

    ((("v" "a"). ())("" "" "ގ"))
    ((("v" "i"). ())("" "" "ގ"))
    ((("v" "u"). ())("" "" ""))
    ((("v" "e"). ())("" "" "ގ"))
    ((("v" "o"). ())("" "" "ގ"))

    ((("v" "y" "a"). ())("" "" "ގ")) 
    ((("v" "y" "u"). ())("" "" "ގ")) 
    ((("v" "y" "o"). ())("" "" "ގ")) 

    ((("z" "k"). ())("" ""))
    ((("z" "j"). ())("" ""))
    ((("z" "h"). ())("" ""))
    ((("z" "l"). ())("" ""))
    ((("z" "-"). ())("" ""))
    ((("z" "["). ())("" ""))
    ((("z" "]"). ())("" ""))
    ((("z" ","). ())("" ""))
    ((("z" "."). ())("" ""))
    ((("z" "/"). ())("" ""))
    ))

(define ja-wide-rule
  '(("a" "")
    ("b" "")
    ("c" "")
    ("d" "")
    ("e" "")
    ("f" "")
    ("g" "")
    ("h" "")
    ("i" "")
    ("j" "")
    ("k" "")
    ("l" "")
    ("m" "")
    ("n" "")
    ("o" "")
    ("p" "")
    ("q" "")
    ("r" "")
    ("s" "")
    ("t" "")
    ("u" "")
    ("v" "")
    ("w" "")
    ("x" "")
    ("y" "")
    ("z" "")
    ("A" "")
    ("B" "")
    ("C" "")
    ("D" "")
    ("E" "")
    ("F" "")
    ("G" "")
    ("H" "")
    ("I" "")
    ("J" "")
    ("K" "")
    ("L" "")
    ("M" "")
    ("N" "")
    ("O" "")
    ("P" "")
    ("Q" "")
    ("R" "")
    ("S" "")
    ("T" "")
    ("U" "")
    ("V" "")
    ("W" "")
    ("X" "")
    ("Y" "")
    ("Z" "")

    ("1" "")
    ("2" "")
    ("3" "")
    ("4" "")
    ("5" "")
    ("6" "")
    ("7" "")
    ("8" "")
    ("9" "")
    ("0" "")

    ("-" "")
    ("," "")
    ("." "")
    ("!" "")
    ("\"" "")
    ("#" "")
    ("$" "")
    ("%" "")
    ("&" "")
    ("'" "")
    ("(" "")
    (")" "")
    ("~" "")
    ("=" "")
    ("^" "")
    ("\\" "")
    ("|" "")
    ("`" "")
    ("@" "")
    ("{" "")
    ("[" "")
    ("+" "")
    (";" "")
    ("*" "")
    (":" "")
    ("}" "")
    ("]" "")
    ("<" "")
    (">" "")
    ("?" "")
    ("/" "")
    ("_"  "")
    ))

;(define ja-rk-rule ja-kana-rule)

;; What's intended? The name "ja-direct-rule" makes me confused
;; because it acts in non-direct modes. This rule makes
;; uim-anthy improper as always sending zenkaku-space in
;; hanakaku-kana mode. This seems to be used to "always commit
;; zenkaku-space regardless input mode". If it's true, This rule
;; should be able to be disabled. -- YamaKen
(define ja-direct-rule
  '((" " "")
    ))

;;
(define ja-find-rec
  (lambda (c rule)
    (if (null? rule)
	#f
	(let ((r (car rule)))
	  (if (string=? c (car r))
	      (cadr r)
	      (ja-find-rec c (cdr rule)))))))

(define ja-wide
  (lambda (c)
    (ja-find-rec c ja-wide-rule)))

(define ja-direct
  (lambda (c)
    (ja-find-rec c ja-direct-rule)))

(define using-kana-table? #f)

(define load-kana-table
  (lambda ()
    (require "japanese-kana.scm")
    (set! ja-rk-rule ja-kana-rule)
    (set! using-kana-table? #t)
    (define-key anthy-kana-toggle-key? "")
    (define-key anthy-latin-key? generic-on-key?)
    (define-key anthy-wide-latin-key? "")
    ))

(define load-azik-table
  (lambda ()
    (require "japanese-azik.scm")
    (set! ja-rk-rule (append ja-rk-rule ja-azik-rule))
    ))

;;
(require "rk.scm")
