/* screen-tick.c: screen-uim output for backtick */
/* $Id: screen-tick.c,v 1.6 2003/12/01 07:57:41 knok Exp $ */

/*
Copyright (C) 2003 NOKUBI Takatsugu <knok@daionet.gr.jp>
This is free software with ABSOLUTELY NO WARRANTY.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#include "udlib.h"

#define BUFSIZE (2048)

void sighandler(int);

char *sockpath = NULL;

static char *
usersockname()
{
    static char buf[BUFSIZE];
    sprintf(buf, "/tmp/screen-uim-%s", getenv("USER"));
    return buf;
}

int main(int argc, char *argv[])
{
  int sfd;
  if (argc > 1) {
    sockpath = argv[1];
  } else {
    sockpath = usersockname();
  }

  signal(SIGINT, sighandler);
  signal(SIGQUIT, sighandler);
  signal(SIGTERM, sighandler);
  signal(SIGHUP, sighandler);

  unlink(sockpath);
  sfd = mkudservd(sockpath);
  if (sfd < 0)
    return 1;
  while (1) {
    char *tmp;
    tmp = udreadline(sfd);
    if (tmp == NULL)
	break;
    printf("%s\n", tmp);
    fflush(stdout);
  }
  return 0;
}

void sighandler(int s)
{
  exit(0);
}
