/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#include "user_conf.h"
#include "ukui_login_sound.h"
#include <QDebug>
#include <QString>
#include <QCoreApplication>
#include <QFile>
#include <ukui-log4qt.h>
#include <QDir>
#include <syslog.h>

//默认音频设备
#define DEFAULT_AUDIO_DEV   "default"
//声卡存放文件
#define AUDIO_JSON  "/.config/audio.json"
//开机按钮选项
#define IS_STARTUP_PLAY_JSON  "/.config/startupMusic.json"

/* define hw sound card dirvers */
#define HI3XXX_HI6405 "hi3xxx_hi6405"
#define HI3XXX_DA_COMBINE_V5 "hi3xxx_DA_combine_v5"
#define DA_COMBINE_V5_MACHINE "da_combine_v5_machine"


int main(int argc, char *argv[])
{
//    initUkuiLog4qt("ukui-login-sound");

    QCoreApplication a(argc, argv);

    //配置信息：设备、用户
    UserConf info;

    //播放开机音乐
    UkuiLoginSound playback;

    //    playback.power_on_smartpa();
    QFile file("/tmp/PlayStartupWav.json");
    if(!file.exists())
    {
        syslog (LOG_INFO, "start up");
        syslog (LOG_INFO, "create /tmp/PlayStartupWav.json");
        info.insertJson();

        if((info.readLightdmConf()=="")&&(info.readLastUser()==""))
        {
            //1、装机第一次登录的情况，使用默认设备进行播放
            syslog (LOG_INFO, "1 First enter");
            system("/usr/share/hw-audio/hwaudioservice -o");
            playback.aplayMain(2,PLAY_STARTUP_WAV,DEFAULT_AUDIO_DEV);
        }else
        {
            QString userFilePath = "/home/";
            QString audioDEV = "default";

            //判断用户是否开启开机音乐
            if(info.readLightdmConf()!="")
            {
                //2、存在自动登录用户的情况下，使用自动登录用户的设备进行播放
                userFilePath += info.readLightdmConf();
                audioDEV = info.readJson(userFilePath,AUDIO_JSON, "card").toString();
                syslog (LOG_DEBUG, "2 user.readLightdmConf()!=null audioDEV:%s  userFilePath:%s", audioDEV.toLatin1().data(), userFilePath.toLatin1().data());

            }
            else if(info.readLastUser()!="")
            {
                //3、没有自动登录用户的时候,使用上一次用户的播放设备
                userFilePath += info.readLastUser();
                audioDEV =info.readJson(userFilePath, AUDIO_JSON, "card").toString();
                syslog (LOG_DEBUG, "3 user.readLastUser()!="" audioDEV: %s  readLastUserFile:%s", audioDEV.toLatin1().data(), userFilePath.toLatin1().data());
            }

            //检测pcm是否正确
            audioDEV = UkuiLoginSound::checkPcm(audioDEV.toLatin1().data());

            QString StartupState = info.readJson(userFilePath, IS_STARTUP_PLAY_JSON, "startupPlayMusic").toString();
            syslog (LOG_INFO," StartupState %s  %s  %s", StartupState.toLatin1().data(), userFilePath.toLatin1().data(), audioDEV.toLatin1().data());
            if(StartupState == "true") {
               /* read mute and volume */
                bool mute = info.readJson(userFilePath, AUDIO_JSON, "mute").toBool();
                int volume = info.readJson(userFilePath, AUDIO_JSON, "volume").toInt();
                syslog(LOG_DEBUG, "get card info, card :%s, mute :%d, volume :%d", audioDEV.toLatin1().data(), mute, volume);
                /* if  */
//                if (!mute && (audioDEV.contains(HI3XXX_HI6405) ||
//                    audioDEV.contains(HI3XXX_DA_COMBINE_V5) ||
//                    audioDEV.contains(DA_COMBINE_V5_MACHINE)))

                if (!mute)
                    system("/usr/share/hw-audio/hwaudioservice -o");

                if (!playback.wav_convert(volume, mute))
                    playback.aplayMain(2, TMP_STARTUP_WAV_PATH, audioDEV.toLatin1().data());
                else
                    playback.aplayMain(2, PLAY_STARTUP_WAV, audioDEV.toLatin1().data());
            }
        }
    }
    else{
        syslog (LOG_INFO, "not first enter,so will not play startup.wav");
    }
    file.close();
    return 0;
}

