#include "FileIsSameDialog.h"
#include "ui_fileIsSameDialog.h"
#include "TransferThread.h"
#include "../../../cpp11addition.h"

#ifdef Q_OS_WIN32
#define CURRENTSEPARATOR "\\"
#else
#define CURRENTSEPARATOR "/"
#endif

#include <QMessageBox>

FileIsSameDialog::FileIsSameDialog(QWidget *parent, INTERNALTYPEPATH fileInfo,
                                   std::string firstRenamingRule, std::string otherRenamingRule,FacilityInterface * facilityEngine) :
    QDialog(parent),
    ui(new Ui::fileIsSameDialog)
{
    Qt::WindowFlags flags = windowFlags();
    #ifdef Q_OS_LINUX
    flags=flags & ~Qt::X11BypassWindowManagerHint;
    #endif
    flags=flags | Qt::WindowStaysOnTopHint;
    setWindowFlags(flags);

    ui->setupUi(this);
    action=FileExists_Cancel;
    oldName=TransferThread::resolvedName(TransferThread::internalStringTostring(fileInfo));
    destinationInfo=TransferThread::internalStringTostring(fileInfo);
    ui->lineEditNewName->setText(QString::fromStdString(oldName));
    ui->lineEditNewName->setPlaceholderText(QString::fromStdString(oldName));
    ui->label_content_file_name->setText(QString::fromStdString(TransferThread::resolvedName(TransferThread::internalStringTostring(fileInfo))));
    std::string folder=FSabsolutePath(TransferThread::internalStringTostring(fileInfo));
    if(folder.size()>80)
        folder=folder.substr(0,38)+"..."+folder.substr(folder.size()-38);
    ui->label_content_folder->setText(QString::fromStdString(folder));
    updateRenameButton();
#ifdef Q_OS_WIN32
    WIN32_FILE_ATTRIBUTE_DATA fileInfoW;
    if(GetFileAttributesExW(fileInfo.c_str(),GetFileExInfoStandard,&fileInfoW))
    {
        uint64_t mdate=fileInfoW.ftLastWriteTime.dwHighDateTime;
        mdate<<=32;
        mdate|=fileInfoW.ftLastWriteTime.dwLowDateTime;
        uint64_t size=fileInfoW.nFileSizeHigh;
        size<<=32;
        size|=fileInfoW.nFileSizeLow;
#else
    struct stat source_statbuf;
    #ifdef Q_OS_UNIX
    if(lstat(TransferThread::internalStringTostring(fileInfo).c_str(), &source_statbuf)==0)
    #else
    if(stat(TransferThread::internalStringTostring(fileInfo).c_str(), &source_statbuf)==0)
    #endif
    {
        #ifdef Q_OS_UNIX
            #ifdef Q_OS_MAC
            const uint64_t mdate=source_statbuf.st_mtimespec.tv_sec;
            #else
            const uint64_t mdate=*reinterpret_cast<int64_t*>(&source_statbuf.st_mtim);
            #endif
        #else
        const uint64_t mdate=*reinterpret_cast<int64_t*>(&source_statbuf.st_mtime);
        #endif
        const uint64_t size=source_statbuf.st_size;
#endif
        ui->label_content_size->setText(QString::fromStdString(facilityEngine->sizeToString(size)));
        ui->label_content_size->setVisible(true);
        if(ULTRACOPIER_PLUGIN_MINIMALYEAR_TIMESTAMPS<mdate)
        {
            ui->label_modified->setVisible(true);
            ui->label_content_modified->setVisible(true);
            ui->label_content_modified->setText(QDateTime::fromMSecsSinceEpoch(mdate*1000).toString());
        }
        else
        {
            ui->label_modified->setVisible(false);
            ui->label_content_modified->setVisible(false);
        }
    }
    else
    {
        ui->label_content_size->setVisible(false);
        ui->label_size->setVisible(false);
        ui->label_modified->setVisible(false);
        ui->label_content_modified->setVisible(false);
    }
    this->firstRenamingRule=firstRenamingRule;
    this->otherRenamingRule=otherRenamingRule;
    on_SuggestNewName_clicked();
}

FileIsSameDialog::~FileIsSameDialog()
{
    delete ui;
}

void FileIsSameDialog::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

std::string FileIsSameDialog::getNewName()
{
    if(oldName==ui->lineEditNewName->text().toStdString() || ui->checkBoxAlways->isChecked())
        return oldName;
    else
        return ui->lineEditNewName->text().toStdString();
}

void FileIsSameDialog::on_SuggestNewName_clicked()
{
    std::string destinationInfo=this->destinationInfo;
    QString absolutePath=QString::fromStdString(FSabsolutePath(destinationInfo));
    QString fileName=QString::fromStdString(TransferThread::resolvedName(destinationInfo));
    QString suffix="";
    QString destination;
    QString newFileName;
    //resolv the suffix
    if(fileName.contains(QRegularExpression(QStringLiteral("^(.*)(\\.[a-z0-9]+)$"))))
    {
        suffix=fileName;
        suffix.replace(QRegularExpression(QStringLiteral("^(.*)(\\.[a-z0-9]+)$")),QStringLiteral("\\2"));
        fileName.replace(QRegularExpression(QStringLiteral("^(.*)(\\.[a-z0-9]+)$")),QStringLiteral("\\1"));
    }
    //resolv the new name
    int num=1;
    do
    {
        if(num==1)
        {
            if(firstRenamingRule.empty())
                newFileName=tr("%name% - copy%suffix%");
            else
                newFileName=QString::fromStdString(firstRenamingRule);
        }
        else
        {
            if(otherRenamingRule.empty())
                newFileName=tr("%name% - copy (%number%)%suffix%");
            else
                newFileName=QString::fromStdString(otherRenamingRule);
            newFileName.replace(QStringLiteral("%number%"),QString::number(num));
        }
        newFileName.replace(QStringLiteral("%name%"),fileName);
        newFileName.replace(QStringLiteral("%suffix%"),suffix);
        destination=absolutePath;
        if(!destination.endsWith('/')
            #ifdef Q_OS_WIN32
                && !destination.endsWith('\\')
            #endif
                )
            destination+=CURRENTSEPARATOR;
        destination+=newFileName;
        destinationInfo=destination.toStdString();
        num++;
    }
    while(TransferThread::exists(destinationInfo.c_str()));
    ui->lineEditNewName->setText(newFileName);
}

void FileIsSameDialog::on_Rename_clicked()
{
    action=FileExists_Rename;
    this->close();
}

void FileIsSameDialog::on_Skip_clicked()
{
    action=FileExists_Skip;
    this->close();
}

void FileIsSameDialog::on_Cancel_clicked()
{
    action=FileExists_Cancel;
    this->close();
}

FileExistsAction FileIsSameDialog::getAction()
{
    return action;
}

bool FileIsSameDialog::getAlways()
{
    return ui->checkBoxAlways->isChecked();
}

void FileIsSameDialog::updateRenameButton()
{
    ui->Rename->setEnabled(ui->checkBoxAlways->isChecked() || (!ui->lineEditNewName->text().contains(QRegularExpression("[/\\\\\\*]")) && oldName!=ui->lineEditNewName->text().toStdString() && !ui->lineEditNewName->text().isEmpty()));
}

void FileIsSameDialog::on_lineEditNewName_textChanged(const QString &arg1)
{
    Q_UNUSED(arg1);
    updateRenameButton();
}

void FileIsSameDialog::on_checkBoxAlways_toggled(bool checked)
{
    Q_UNUSED(checked);
    updateRenameButton();
}

void FileIsSameDialog::on_lineEditNewName_returnPressed()
{
    updateRenameButton();
    if(ui->Rename->isEnabled())
        on_Rename_clicked();
    else
        QMessageBox::warning(this,tr("Error"),tr("Try rename with using special characters"));
}

void FileIsSameDialog::on_lineEditNewName_editingFinished()
{
    updateRenameButton();
}
