/* UltraPoint -- the GGI presentation program.

   Copyright (C) 2000 Daiki Ueno <ueno@unixuser.org>

   Author: Daiki Ueno <ueno@unixuser.org>
   Created: 2000-05-16

   This file is part of UltraPoint.

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2, or (at your option)  
   any later version.                                                   

   This program is distributed in the hope that it will be useful,      
   but WITHOUT ANY WARRANTY; without even the implied warranty of       
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the        
   GNU General Public License for more details.                         

   You should have received a copy of the GNU General Public License    
   along with GNU Emacs; see the file COPYING.  If not, write to the    
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
   Boston, MA 02111-1307, USA.                                          

*/

#ifndef __UPT_H_
#define __UPT_H_

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unicode.h>
#include <ggi/ggi.h>
#include <glib.h>
#include "config.h"

#ifdef ENABLE_NLS
# include <libintl.h>
# ifdef PACKAGE
#  undef _
#  define _(String) dgettext(PACKAGE,String)
# else
#  define _(String) gettext(String)
# endif   /* PACKAGE */
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif   /* gettext_noop */
#else
# define _(String) (String)
# define N_(String) (String)
# define textdomain(String) (String)
# define gettext(String) (String)
# define dgettext(Domain,String) (String)
# define dcgettext(Domain,String,Type) (String)
# define bindtextdomain(Domain,Directory) (Domain) 
#endif  /* ENABLE_NLS */

#ifndef G_N_ELEMENTS
#define G_N_ELEMENTS(arr)               (sizeof (arr) / sizeof ((arr)[0]))
#endif

#define upt_object_unref(Object) \
  (--(Object)->ref_count < 0 && ((*(Object)->free) ((Object)), 0))

#define upt_object_ref(Object) ((Object)->ref_count++)

extern gboolean use_background_image;

#endif
