/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef EXPRESSION_H_INCLUDED
#define EXPRESSION_H_INCLUDED

#include <stdio.h>

#include "types.h"

Expr *EXPR_new(void *s, ExpressionType t);
Expr *EXPR_new_int(int s);
void EXPR_link_sx(Expr *parent, Expr *child);
void EXPR_link_dx(Expr *parent, Expr *child);
Expr *EXPR_new_sx(void *data, ExpressionType t, Expr *child);
Expr *EXPR_new_dx(void *data, ExpressionType t, Expr *child);
Expr *EXPR_new_linked(void *s, ExpressionType t, Expr *sx, Expr *dx);
int EXPR_is_label(Expr *e);

int EXPR_eval(Expr *e, int *res);

void EXPR_print_tree(Expr *parent, FILE *t);

Expr *EXPR_copy(Expr *o);

void EXPR_free(Expr *parent);

#endif

