#! /bin/sh
#
# Scans src/token_enum.h and creates token_names.h
#
# $Id: make_token_names.sh 576 2006-11-18 01:24:47Z bengardner $
#

infile="token_enum.h"
outfile="token_names.h"

if [ -d src ] ; then
  infile="src/"$infile
  outfile="src/"$outfile
fi

names=$(grep "CT_" $infile | sed -e 's/,.*//g')

# do a little trick to prevent CVS from expanding the id tag
idstr="Id: $"

cat > $outfile <<EOF
/*
 * Generated by $(basename $0) on $(date)
 * \$$idstr
 */

#ifndef TOKEN_NAMES_H_INCLUDED
#define TOKEN_NAMES_H_INCLUDED

const char *token_names[] =
{
EOF

for item in $names ; do
    echo "   \"${item#CT_}\"," >> $outfile
done

cat >> $outfile <<EOF
};

#endif  /* TOKEN_NAMES_H_INCLUDED */

EOF

