/**
 * @file unc_ctype.h
 * The ctype function are only required to handle values 0-255 and EOF.
 * A char is sign-extended when cast to an int.
 * With some C libraries, these values cause a crash.
 * These wrappers will properly handle all char values.
 *
 * @author  Ben Gardner
 * @license GPL v2+
 *
 * $Id: unc_ctype.h 1317 2008-08-04 01:06:49Z bengardner $
 */
#ifndef UNC_CTYPE_H_INCLUDED
#define UNC_CTYPE_H_INCLUDED

#include <cctype>

/**
 * Truncate anything except EOF (-1) to 0-255
 */
static inline int unc_fix_ctype(int ch)
{
   return((ch == -1) ? -1 : (ch & 0xff));
}

static inline int unc_isspace(int ch)
{
   return(isspace(unc_fix_ctype(ch)));
}
static inline int unc_isprint(int ch)
{
   return(isprint(unc_fix_ctype(ch)));
}
static inline int unc_isalpha(int ch)
{
   return(isalpha(unc_fix_ctype(ch)));
}
static inline int unc_isalnum(int ch)
{
   return(isalnum(unc_fix_ctype(ch)));
}
static inline int unc_toupper(int ch)
{
   return(toupper(unc_fix_ctype(ch)));
}
static inline int unc_tolower(int ch)
{
   return(tolower(unc_fix_ctype(ch)));
}
static inline int unc_isxdigit(int ch)
{
   return(isxdigit(unc_fix_ctype(ch)));
}
static inline int unc_isdigit(int ch)
{
   return(isdigit(unc_fix_ctype(ch)));
}

#endif /* UNC_CTYPE_H_INCLUDED */
