/* Chromium Unity integration extension
 * 
 *   Copyright 2012 Canonical Ltd.
 *
 *   This program is free software: you can redistribute it and/or modify it 
 *   under the terms of the GNU General Public License version 3, as published 
 *   by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but 
 *   WITHOUT ANY WARRANTY; without even the implied warranties of 
 *   MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 *   PURPOSE.  See the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along 
 *   with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

// this is meant to be removed once we settle on a common infrastructure for
// FF & chromium for implementation specific things (e.g. TLD, logs, imports, ...)

var Components = {
    utils: {
	import: function (resource) {
	    if ( ! resource || ! typeof (resource) === 'string') {
		return;
	    }
	    
	    var resourceQualifier = 'resource://';
	    
	    if (resource.indexOf (resourceQualifier) == -1) {
		return;
	    }
		
	    // very hacky, we don't have the same structure as FF (should)
	    // so we dont consider paths
	    var idx = resource.lastIndexOf ('/');
	    if (idx == -1) {
		return;
	    }
	    
	    var getResourceContent = function (resourcename) {
		var content = null;
		var xhr = new XMLHttpRequest();
		
		xhr.onreadystatechange = function() {
		    if (xhr.readyState == 4) {
			content = xhr.responseText;
		    }
		};
		// mmh blocking
		xhr.open("GET", resourcename, false);
		
		try { xhr.send(); } catch(e) { }
		
		return content;
	    };
	    
	    var content = getResourceContent (chrome.runtime.getURL (resource.slice (idx+1)));
	    
	    if (   null != content
		   && typeof (content) === 'string'
		   && 0 != content.length) {
		
		/// yeah! eval!
		try {
		    eval.call (window, content);
		} 
		catch (e) {
		    // mmmh ?
		    console.log ('Components.utils.import: ' + String(e));
		}
	    }
	}
    }
};


/*var consoleService = {
    logStringMessage: function (msg) {
	if (settings && settings.logging) {
	    console.log (msg);
	}
    }
};*/
				  

