/*
 * notify-binding.c
 * Copyright (C) Canonical LTD 2012
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <glib.h>

#include <libnotify/notify.h>

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"
#include "unity-npapi-binding-utils.h"
#include "wrapped-ptr-type.h"
#include "wrapped-callback-type.h"

NPVariant
binding_notify_notification_init (NPP instance,
                                  NPObject * npobject,
                                  const NPVariant *args,
                                  uint32_t argCount)
{
  NPVariant result;
  NULL_TO_NPVARIANT (result);
  if (argCount != 1)
    {
      NPN_SetException(npobject, "Invalid argument count for npapi call: notify_init");
      return result;
    }

  if ( ! NPVARIANT_IS_STRING (args[0]))
    {
      NPN_SetException(npobject, "Invalid argument type for npapi call: notify_init");
      return result;
    }

  char * app_name = NULL;

  if (!is_null_or_void (args[0]))
    {
      app_name = create_safe_string_for (&args[0]);
    }
  
  gboolean ret_val = notify_init (app_name);
  BOOLEAN_TO_NPVARIANT (ret_val, result);

  g_free (app_name);

  return result;
}


NPVariant
binding_notify_notification_is_initted (NPP instance,
                                        NPObject * npobject,
                                        const NPVariant *args,
                                        uint32_t argCount)
{
  NPVariant result;
  NULL_TO_NPVARIANT (result);

  gboolean ret_val = notify_is_initted ();

  BOOLEAN_TO_NPVARIANT (ret_val, result);

  return result;
}


NPVariant
binding_notify_notification_new (NPP instance,
                                 NPObject * npobject,
                                 const NPVariant *args,
                                 uint32_t argCount)
{
  NPVariant result;
  NULL_TO_NPVARIANT (result);

  if (argCount != 3)
    {
      NPN_SetException(npobject, "Invalid argument count for npapi call: notify_notification_new");
      return result;
    }

  if ( ! NPVARIANT_IS_STRING(args[0])
       || ! NPVARIANT_IS_STRING(args[1])
       || ( ! NPVARIANT_IS_STRING(args[2]) && ! is_null_or_void(args[2]) )
       )
    {
      NPN_SetException(npobject, "Invalid argument type for npapi call: notify_notification_new");
      return result;
    }

  char * summary = NULL;
  char * body = NULL;
  char * icon = NULL;

  if ( ! is_null_or_void (args[0]))
    {
      summary = create_safe_string_for (&args[0]);
    }

  if ( ! is_null_or_void (args[1]))
    {
      body = create_safe_string_for (&args[1]);
    }

  if ( ! is_null_or_void (args[2]))
    {
      icon = create_safe_string_for (&args[2]);
    }

  NotifyNotification * ret_val = notify_notification_new (summary, body, icon);

  g_free (summary);
  g_free (body);
  g_free (icon);

  if (NULL == ret_val)
    return result;

  NPObject * object = create_wrapped_ptr_object_for (instance, ret_val);
  if (NULL == object)
    {
      return result;
    }

  OBJECT_TO_NPVARIANT(object, result);

  return result;
}


NPVariant
binding_notify_notification_show (NPP instance,
                                  NPObject * npobject,
                                  const NPVariant *args,
                                  uint32_t argCount)
{
  NPVariant result;
  NULL_TO_NPVARIANT (result);

  if (argCount != 2)
    {
      NPN_SetException(npobject, "Invalid argument count for npapi call: notify_notification_show");
      return result;
    }

  if (   ( ! NPVARIANT_IS_OBJECT(args[0]) && ! is_null_or_void(args[0]) )
      || ( ! NPVARIANT_IS_OBJECT(args[1]) && ! is_null_or_void(args[1]) )
     )
    {
      NPN_SetException(npobject, "Invalid argument type for npapi call: notify_notification_show");
      return result;
    }

  NotifyNotification * notification = NULL;

  if (!is_null_or_void (args[0]))
    {
      notification = (void*) ((wrapped_void_ptr_t *) args[0].value.objectValue)->pWrapped;
    }

  GError * error = NULL;

  gboolean ret_val = notify_notification_show (notification, &error);
  
  if (! ret_val)
    {
      NPN_SetException(npobject, error->message);
      g_error_free (error);
      return result;
    }

  BOOLEAN_TO_NPVARIANT (ret_val, result);

  return result;
}


NPVariant
binding_notify_notification_destroy (NPP instance,
                                     NPObject * npobject,
                                     const NPVariant *args,
                                     uint32_t argCount)
{
  NPVariant result;
  NULL_TO_NPVARIANT (result);

  if (argCount != 1)
    {
      NPN_SetException(npobject, "Invalid argument count for npapi call: notify_unref");
      return result;
    }

  if ( ! NPVARIANT_IS_OBJECT(args[0]) && ! is_null_or_void(args[0]) )
    {
      NPN_SetException(npobject, "Invalid argument type for npapi call: notify_unref");
      return result;
    }

  gpointer object = NULL;
  if (!is_null_or_void (args[0]))
    {
      object = (void*) ((wrapped_void_ptr_t *) args[0].value.objectValue)->pWrapped;
    }
  g_object_unref (object);

  return result;
}

