# Copyright (C) 2007  Lars Wirzenius <liw@iki.fi>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


"""Unperish Null pluging, for testing purposes."""


import unperishlib


class Null(unperishlib.Operation):

    name = "null"
    
    provided_options = ["null"]
    
    def __init__(self):
        self.count = 0

    def add_options(self, option_parser):
        option_parser.add_option("--null")

    def do_it(self, options):
        self.count += 1
        if options.null is None:
            options.null = "null"
