#!/usr/bin/env python
#
from setuptools import setup

setup(name="uoa-integration-tests",
      version="0.2",
      author="Alberto Mardegan",
      author_email="alberto.mardegan@canonical.com",
      url="http://launchpad.net/uoa-integration-tests",
      license="GNU General Public License v3 (GPLv3)",
      data_files=[
    ('share/accounts/providers', [
        'data/fake-oauth.provider',
        'data/fake-oauth1.provider',
        'data/test-login.provider',
        ]),
    ('share/accounts/qml-plugins/fake-oauth', ['qml/fake-oauth/Main.qml']),
    ('share/accounts/qml-plugins/fake-oauth1', ['qml/fake-oauth1/Main.qml']),
    ('share/accounts/qml-plugins/test-login', [
        'qml/test-login/Main.qml',
        'qml/test-login/NewAccount.qml',
        ]),
    ('share/accounts/services', [
        'data/fake-service.service',
        'data/test-login-photos.service',
        ]),
    ('share/accounts/applications', ['data/uoa-integration-tests.application']),
    ('/etc/ssl/certs', ['data/uoa-test-server.pem']),
    ('/etc/signon-ui/webkit-options.d', ['data/localhost.conf']),
    ('share/uoa_integration_tests', ['tests/test_env.sh']),
    ],
      packages=['uoa_integration_tests'],
      package_dir = {'': 'python'},
      test_suite='uoa_integration_tests.selftests')
