#!/usr/local/bin/perl
# index.cgi
# Show fetchmail configurations

require './fetchmail-lib.pl';
&header($text{'index_title'}, "", undef, 0, 1);
print "<hr>\n";

# Check if fetchmail is installed
if (!&has_command($config{'fetchmail_path'})) {
	print "<p>",&text('index_efetchmail',
			  "<tt>$config{'fetchmail_path'}</tt>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

@conf = &parse_config_file($fetchmail_config);
@conf = grep { $_->{'poll'} } @conf;
&show_polls(\@conf, $fetchmail_config, $remote_user_info[0]);

if (@conf) {
	# Show the fetchmail daemon form
	print "<hr>\n";
	print "<table width=100%>\n";

	if (&foreign_check("cron")) {
		# Show button to manage cron job
		print "<form action=edit_cron.cgi>\n";
		print "<tr> <td><input type=submit ",
		      "value='$text{'index_cron'}'></td>\n";
		print "<td>$text{'index_crondesc'}</td> </tr></form>\n";
		}

	print "<tr><td>\n";
	foreach $pf ("$remote_user_info[7]/.fetchmail.pid",
		     "$remote_user_info[7]/.fetchmail") {
		if (open(PID, $pf) && ($line=<PID>) &&
		    (($pid,$interval) = split(/\s+/, $line)) && $pid &&
		    kill(0, $pid)) {
			$running = $pf;
			last;
			}
		}
	if ($running) {
		# daemon is running - offer to stop it
		print "<form action=stop.cgi>\n";
		print "<input type=submit value='$text{'index_stop'}'></td>\n";
		print "<td>",&text('index_stopmsg', $interval),"</td>\n";
		}
	else {
		# daemon isn't running - offer to start it
		print "<form action=start.cgi>\n";
		print "<input type=submit value='$text{'index_start'}'></td>\n";
		print "<td>",&text('index_startmsg',
			   "<input name=interval size=5 value='60'>"),"</td>\n";
		}
	print "</td></tr></table></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

# show_polls(&polls, file, user)
sub show_polls
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_poll'}</b></td> ",
      "<td><b>$text{'index_active'}</b></td> ",
      "<td><b>$text{'index_proto'}</b></td> ",
      "<td><b>$text{'index_users'}</b></td> </tr>\n" if (@{$_[0]});
foreach $p (@{$_[0]}) {
	print "<tr $cb>\n";
	print "<td valign=top><a href='edit_poll.cgi?file=$_[1]&",
	      "idx=$p->{'index'}&user=$_[2]'>",&html_escape($p->{'poll'}),
	      "</a></td>\n";
	print "<td>",$p->{'skip'} ? "<font color=#ff0000>$text{'no'}</font>"
				  : $text{'yes'},"</td>\n";
	print "<td>",$p->{'proto'} ? &html_escape(uc($p->{'proto'}))
				   : $text{'default'},"</td>\n";
	print "<td>\n";
	foreach $u (@{$p->{'users'}}) {
		printf "%s -> %s<br>\n",
			&html_escape($u->{'user'}),
			&html_escape(@{$u->{'is'}} ? join(" ", @{$u->{'is'}})
						   : $_[2]);
		}
	print "</td> </tr>\n";
	}
print "</table>\n";
if (!@{$_[0]}) {
	print "<b>$text{'index_noservers'}</b><p>\n";
	}
print "<a href='edit_poll.cgi?new=1&file=$_[1]&user=$_[2]'>$text{'index_add'}</a>\n";
print "&nbsp;&nbsp;\n";
print "<a href='edit_global.cgi?file=$_[1]&user=$_[2]'>$text{'index_global'}</a>\n";
print "&nbsp;&nbsp;\n";
if (@{$_[0]}) {
	print "<a href='check.cgi?file=$_[1]&user=$_[2]'>$text{'index_run'}</a>\n";
	}
print "<p>\n";
}

