#!/usr/local/bin/perl
# backup_form.cgi
# Display a form for backup the database

require './postgresql-lib.pl' ;

&ReadParse ( ) ;

&error_setup ( $text{'backup_err'} ) ;
$access{'backup'} || &error($text{'backup_ecannot'});
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});

&has_command($config{'dump_cmd'}) ||
	&error(&text('backup_ecmd', "<tt>$config{'dump_cmd'}</tt>"));

&header ( $text{'backup_title'}, "", "backup_form" ) ;
print "<hr>\n" ;

$cron = !$module_info{'usermin'} &&
        !$access{'user'} && &foreign_installed("cron");
print &text('backup_desc', "<tt>$in{'db'}</tt>"),"\n";
if ($cron) {
        print "$text{'backup_desc2'}\n";
        }
print "<p>\n";
%c = $module_info{'usermin'} ? %userconfig : %config;

print "<form action=backup.cgi method=post>\n" ;
print "<input type=hidden name=db value=\"$in{'db'}\">\n" ;
print "<table border>\n" ;
print "<tr $tb> <td><b>$text{'backup_header'}</b></td> </tr>\n" ;
print "<tr $cb> <td><table>\n" ;

$p = $c{'backup_'.$in{'db'}} || "$config{'repository'}/";
print "<tr> <td><b>$text{'backup_path'}</b></td>\n" ;
print "<td>\n" ;
print "<input type=text name=path value='$p' size=64></td></tr>\n" ;

$f = $c{'backup_format_'.$in{'db'}};
print "<tr> <td><b>$text{'backup_format'}</b></td>\n";
print "<td><select name=format>\n";
foreach $t ('p', 't', 'c') {
	printf "<option value=%s %s>%s\n",
		$t, $f eq $t ? "selected" : "", $text{'backup_format_'.$t};
	}
print "</select></td> </tr>\n";

if ($cron) {
	$b = $c{'backup_before_'.$in{'db'}};
	print "<tr> <td><b>$text{'backup_before'}</b></td>\n";
	printf "<td><input name=before size=50 value='%s'></td> </tr>\n", $b;

	$a = $c{'backup_after_'.$in{'db'}};
	print "<tr> <td><b>$text{'backup_after'}</b></td>\n";
	printf "<td><input name=after size=50 value='%s'></td> </tr>\n", $a;

	&foreign_require("cron", "cron-lib.pl");
	@jobs = &cron::list_cron_jobs();
	($job) = grep { $_->{'command'} eq "$cron_cmd $in{'db'}" } @jobs;

	print "<tr> <td><b>$text{'backup_sched'}</b></td>\n";
	printf "<td><input type=radio name=sched value=0 %s> %s\n",
		$job ? "" : "checked", $text{'no'};
	printf "<input type=radio name=sched value=1 %s> %s</td> </tr>\n",
		$job ? "checked" : "", $text{'backup_sched1'};

	print "<tr> <td colspan=2><table border width=100%>\n";
	$job ||= { 'mins' => 0,
		   'hours' => 0,
		   'days' => '*',
		   'months' => '*',
		   'weekdays' => '*' };
	&cron::show_times_input($job);
	print "</table></td> </tr>\n";
	}

print "<tr $cb> <td colspan=2 align=right>\n";
if ($cron) {
	print "<input type=submit name=backup value='$text{'backup_ok1'}'>\n";
	print "<input type=submit name=save value='$text{'backup_ok2'}'>\n";
	}
else {
	print "<input type=submit name=backup value='$text{'backup_ok'}'>\n";
	}
print "</td> </tr>\n" ;

print "</table></td></tr></table></form>\n" ;

print "<hr>\n" ;

&footer("edit_dbase.cgi?db=$in{'db'}", $text{'dbase_return'},
	"", $text{'index_return'});

