#!/usr/local/bin/perl
# delete_mail.cgi
# Delete, mark, move or copy multiple messages

require './mailbox-lib.pl';
&ReadParse();
@delete = sort { $a <=> $b } split(/\0/, $in{'d'});
@folders = &list_folders();
$folder = $folders[$in{'folder'}];

if ($in{'mark1'} || $in{'mark2'}) {
	# Marking emails with some status
	@delete || &error($text{'delete_emnone'});
	@mail = &mailbox_list_mails($delete[0], $delete[@delete-1], $folder);
	dbmopen(%read, "$user_module_config_directory/read", 0600);
	local $m = $in{'mark1'} ? $in{'mode1'} : $in{'mode2'};
	foreach $d (@delete) {
		local $hid = $mail[$d]->{'header'}->{'message-id'};
		if ($m) {
			$read{$hid} = $m;
			}
		else {
			delete($read{$hid});
			}
		}
	dbmclose(%read);
	$perpage = $folder->{'perpage'} || $userconfig{'perpage'};
	$s = int((@mail - $delete[0] - 1) / $perpage) * $perpage;
	&redirect("index.cgi?start=$s&folder=$in{'folder'}");
	}
elsif ($in{'move1'} || $in{'move2'}) {
	# Moving mails to some other folder
	&check_modification($folder);
	@delete || &error($text{'delete_emnone'});
	$mfolder = $folders[$in{'move1'} ? $in{'mfolder1'} : $in{'mfolder2'}];
	@mail = &mailbox_list_mails($delete[0], $delete[@delete-1], $folder);
	foreach $d (@delete) {
		$mail[$d] || &error($text{'mail_eexists'});
		push(@movemail, $mail[$d]);
		}
	&lock_folder($folder);
	&lock_folder($mfolder);
	&mailbox_move_mail($folder, $mfolder, @movemail);
	&unlock_folder($mfolder);
	&unlock_folder($folder);
	&redirect("index.cgi?folder=$in{'folder'}");
	}
elsif ($in{'copy1'} || $in{'copy2'}) {
	# Copying mails to some other folder
	@delete || &error($text{'delete_emnone'});
	$cfolder = $folders[$in{'copy1'} ? $in{'mfolder1'} : $in{'mfolder2'}];
	@mail = &mailbox_list_mails($delete[0], $delete[@delete-1], $folder);
	foreach $d (@delete) {
		$mail[$d] || &error($text{'mail_eexists'});
		push(@copymail, $mail[$d]);
		}
	&lock_folder($cfolder);
	&mailbox_copy_mail($folder, $cfolder, @copymail);
	&unlock_folder($cfolder);
	&redirect("index.cgi?folder=$in{'folder'}");
	}
elsif ($in{'forward'}) {
	# Forwarding selected mails .. redirect
	@delete || &error($text{'delete_efnone'});
	&redirect("reply_mail.cgi?folder=$in{'folder'}&".
		  join("&", map { "mailforward=$_" } @delete));
	}
elsif ($in{'new'}) {
	# Need to redirect to compose form
	&redirect("reply_mail.cgi?new=1&folder=$in{'folder'}");
	}
else {
	# Just deleting emails
	&check_modification($folder);
	@delete || $in{'all'} || &error($text{'delete_enone'});
	if (!$in{'confirm'} && &need_delete_warn($folder)) {
		# Need to ask for confirmation before deleting
		&ui_print_header(undef, $text{'confirm_title'}, "");
		print &check_clicks_function();

		print "<form action=delete_mail.cgi>\n";
		foreach $i (keys %in) {
			foreach $v (split(/\0/, $in{$i})) {
				print "<input type=hidden name=$i value='",
				      &html_escape($v),"'>\n";
				}
			}
		print "<center><b>\n";
		if ($in{'all'}) {
			print &text('confirm_warnall'),"<br>\n";
			}
		else {
			print &text('confirm_warn', scalar(@delete)),"<br>\n";
			}
		if ($userconfig{'delete_warn'} ne 'y') {
			print "$text{'confirm_warn2'}<p>\n"
			}
		else {
			print "$text{'confirm_warn4'}<p>\n"
			}
		print "</b><p><input type=submit name=confirm ",
		      "value='$text{'confirm_ok'}' ",
		      "onClick='return check_clicks(form)'></center></form>\n";
		
		&ui_print_footer("index.cgi?folder=$in{'folder'}", $text{'index'});
		}
	else {
		# Go ahead and delete
		$gconfig{'logfiles'} = 0;
		&lock_folder($folder);
		if ($in{'all'}) {
			# Clear the whole folder
			&mailbox_empty_folder($folder);
			}
		else {
			# Just delete selected messages
			@mail = &mailbox_list_mails($delete[0],
						    $delete[@delete-1],
						    $folder);
			foreach $d (@delete) {
				$mail[$d] || &error($text{'mail_eexists'});
				push(@delmail, $mail[$d]);
				}
			&mailbox_delete_mail($folder, @delmail);
			}
		&unlock_folder($folder);
		&redirect("index.cgi?folder=$in{'folder'}");
		}
	}
&pop3_logout_all();
