#!/usr/local/bin/perl
# index.cgi
# Display a menu of spamassassin config category icons

require './spam-lib.pl';
$hsl = $module_info{'usermin'} ? undef :
		&help_search_link("spamassassin", "perl", "google");
if (!&has_command($config{'spamassassin'}) ||
    (!$module_info{'usermin'} && !($vers = &get_spamassassin_version(\$out)))) {
	# Program not found
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, undef, $hsl);
	print &text('index_ecmd', "<tt>$config{'spamassassin'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&read_acl(\%acl, undef);
	if ($acl{$base_remote_user, 'cpan'}) {
		# Offer to install perl module
		$modname = "Mail::SpamAssassin";
		print &text('index_cpan', "<tt>$modname</tt>",
			    "../cpan/download.cgi?source=3&cpan=$modname&mode=2&return=/$module_name/&returndesc=".&urlize($module_info{'desc'})),"<p>\n";
		}
	}
else {
	$vtext = $module_info{'usermin'} ? undef :
			&text('index_version', $vers);
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, undef, $hsl,
		undef, undef, $vtext);

	if (!-r $local_cf && !-d $local_cf && !$module_info{'usermin'}) {
		# Config not found
		print "<p>",&text('index_econfig',
			"<tt>$config{'local_cf'}</tt>",
			"$gconfig{'webprefix'}/config.cgi?$module_name"),
			"<p>\n";
		}
	else {
		# Work out of SpamAssassin is enabled in procmail
		if ($config{'warn_procmail'} && &foreign_check("procmail")) {
			&foreign_require("procmail", "procmail-lib.pl");
			$enabled = 0;
			@pmrcs = &get_procmailrc();
			foreach $pmrc (@pmrcs) {
				local @recipes =
					&procmail::parse_procmail_file($pmrc);
				foreach $r (@recipes) {
					if ($r->{'action'} =~ /spamassassin/i ||
					    $r->{'action'} =~ /spamc/i) {
						# Looks like it is!
						$enabled = 1;
						last;
						}
					foreach $c (@{$r->{'conds'}}) {
						if ($c->[1] =~ /X-Spam/i) {
							# A condition exists
							$enabled = 1;
							last;
							}
						}
					}
				last if ($enabled);
				}
			}
		else {
			$enabled = -1;	# don't know, or checking disabled
			}
		if ($enabled == 0) {
			if ($module_info{'usermin'}) {
				print &text('index_warn_usermin',
					    "<tt>$pmrcs[0]</tt>",
					    "<tt>$pmrcs[1]</tt>"),"<p>\n";
				}
			else {
				print &text('index_warn_webmin',
					    "<tt>$pmrcs[0]</tt>"),"<p>\n";
				}
			}

		# Check if razor is set up
		if ($module_info{'usermin'}) {
			$razor = 1
				if (-r "$remote_user_info[7]/.razor/identity");
			}

		# Show icons
		@pages = ( 'white', 'score', 'report', 'user' );
		push(@pages, 'header') if (!$module_info{'usermin'} ||
					   &find_default("allow_user_rules", 0));
		push(@pages, 'priv') if (!$module_info{'usermin'});
		push(@pages, 'mail') if ($module_info{'usermin'} &&
					 $userconfig{'spam_file'});
		push(@pages, 'razor') if (!$razor && $module_info{'usermin'});
		push(@pages, 'setup') if ($enabled == 0);
		@pages = grep { &can_use_page($_) } @pages;
		@links = map { $_ eq "mail" ? "mail.cgi" : "edit_${_}.cgi" }
			     @pages;
		@icons = map { "images/${_}.gif" } @pages;
		@titles = map { $text{"${_}_title"} } @pages;
		&icons_table(\@links, \@titles, \@icons);

		# Show buttons for HUPing spamd processes (if any)
		if (!$module_info{'usermin'} &&
		    (@pids = &get_process_pids())) {
			print "<hr>\n";
			print "<form action=apply.cgi>\n";
			print "<table>\n";
			print "<tr> <td><input type=submit ",
			      "value='$text{'index_apply'}'></td>\n";
			print "<td>",&text('index_applydesc',
				"<tt>".join(" and ", &unique(
				map { $_->[1] } @pids))."</tt>"),"</td>\n";
			print "</table>\n";
			}
		}
	}

&ui_print_footer("/", $text{'index'});

