-- do not edit; automatically generated by UU.AG
module Transform where

import List (partition, elem)
import qualified UU.DData.Map as Map
import UU.DData.Map (Map)
import UU.DData.Set as Set (Set, member, union, toList, fromList, empty, single, member, unions, size, fold, intersection, difference, insert)
import UU.DData.Seq as Seq (Seq, empty, (<>), single, cons, toList, fromList)
import UU.Scanner.Position(noPos)

import ConcreteSyntax
import AbstractSyntax
import ErrorMessages
import Patterns (Patterns(..),Pattern(..))
import Expression (Expression)

import Options(Options, withSelf, withCycle, withSeq, strictData, strictWrap, unbox, visit, cases, wrappers)
import CommonTypes

import UU.Scanner.Position (Pos)
import Patterns   (Pattern)
import Expression (Expression)
import CommonTypes

-- Patterns.ag imports
import UU.Scanner.Position(Pos)
import CommonTypes (Constructor,Name)
type DefinedSets = Map Name (Set Nonterminal) 
type FieldMap  = [(Name, Type)] 
type DataTypes = Map.Map Nonterminal (Map.Map Constructor FieldMap) 
type AttrName = (Name,Name) 
type RuleInfo = ([AttrName]->Pattern, Expression, [AttrName], Bool, String) 
type SigInfo  = (Identifier,Type) 


checkDuplicate :: (Identifier -> Identifier -> Error)
               -> Identifier -> val -> Map Identifier val -> (Map Identifier val,Seq Error)
checkDuplicate dupError key val m
  = case Map.lookupIndex key m of
     Just ix -> let (key',_) = Map.elemAt ix m
                in  (m,Seq.single (dupError key key'))
     Nothing -> (Map.insert key val m,Seq.empty)

checkDuplicates :: (Identifier -> Identifier -> Error)
                -> [(Identifier, val)] -> Map Identifier val -> (Map Identifier val,Seq Error)
checkDuplicates dupError new m = foldErrors check m new
 where  check = uncurry (checkDuplicate dupError)

foldErrors f e xs = foldl g (e,Seq.empty) xs
  where g ~(e,es) x = let (e',es') = f x e
                      in (e', es <> es')


checkForDuplicates :: (Identifier -> Identifier -> Error)  ->  [Identifier]  ->  [Error]
checkForDuplicates err [] = []
checkForDuplicates err (x:xs) = let (same,other) = List.partition (equalId x) xs
                                in  map (err x) same ++ checkForDuplicates err other

equalId :: Identifier -> Identifier -> Bool
equalId x y = getName x == getName y


type RulesAndErrors = ([Rule], Seq Error)
type SigsAndErrors  = ([TypeSig], Seq Error)
type AttrOverwrite  = Map AttrName Bool
type AccumRuleCheck = (RulesAndErrors, AttrOverwrite)
type AccumDefiCheck = (Seq Error, AttrOverwrite, [AttrName], [AttrName])

checkRules :: Map Nonterminal (Attributes, Attributes) -> Map Nonterminal (Map Constructor FieldMap) -> Nonterminal -> Constructor -> [RuleInfo] -> RulesAndErrors
checkRules attributes fields nt con rs 
  = let fieldmap :: FieldMap
        fieldmap = (_LHS,NT nt) : (_LOC,NT undefined) : Map.findWithDefault [] con (Map.findWithDefault Map.empty nt fields)
  
        hasAttrib f tp attr  = Map.member attr (f (Map.findWithDefault (Map.empty,Map.empty) tp attributes))
  
        checkRule :: RuleInfo -> AccumRuleCheck -> AccumRuleCheck
        checkRule (pat,exp,as,owrt,str) ((r1,e1),m1) 
          = let (e2,m2,u2,b2) = foldr (checkDefi owrt) (e1,m1,[],[]) as
            in  ( (Rule (pat u2) exp owrt str : r1, e2), m2)

        checkDefi :: Bool -> AttrName -> AccumDefiCheck -> AccumDefiCheck
        checkDefi owrt fa@(field,attr) (e,m,u,bs)
         = case lookup field fieldmap 
            of  Just (NT tp) -> if field == _LOC
                                   || hasAttrib (if getName field==getName _LHS then snd else fst) tp attr
                                 then case Map.lookupIndex fa m 
                                       of  Just ix -> let ((_,attr2),b) = Map.elemAt ix m
                                                       in  if b && not (fa `elem` bs)
                                                            then (                                             e, Map.insert fa owrt m, fa:u, fa:bs)
                                                            else (Seq.cons (DupRule nt con field attr2 attr)   e,                    m, fa:u,    bs)
                                           Nothing ->            (                                             e, Map.insert fa owrt m,    u, fa:bs)
                                 else                            (Seq.cons (SuperfluousRule nt con field attr) e,                    m, fa:u,    bs)
                _            ->                                  (Seq.cons (UndefChild nt con field)           e,                    m, fa:u,    bs )

    in  fst (foldr checkRule (([],Seq.empty),Map.empty) rs)
    
checkSigs :: Nonterminal -> Constructor -> [SigInfo] -> SigsAndErrors
checkSigs nt con sis 
  = let checkSig (ide,typ) (sigs,errs)
         = if   ide `elem` map (\(TypeSig n _)->n) sigs
           then (sigs, Seq.cons (DupSig nt con ide) errs)
           -- else if not (ide `elem` locattrdefs)
           -- then (sigs, Seq.cons (SupSig nt con ide) errs)
           else (TypeSig ide typ:sigs, errs)
    in  foldr checkSig ([],Seq.empty) sis

flattenDatas :: DataTypes -> Map Nonterminal (Set Nonterminal)
flattenDatas ds = Map.map flatten ds
  where flatten cs =  Set.fromList [ nt | (_,NT nt) <- concatMap snd (Map.toList cs)]

reachableFrom :: Map Nonterminal (Set Nonterminal) -> Set Nonterminal -> Set Nonterminal
reachableFrom table nts = reach nts
  where reach nts = let nts' = Set.unions (nts : [ ns  | nt <- Set.toList nts
                                                 , let ns = Map.findWithDefault Set.empty nt table ])
                    in if Set.size nts' > Set.size nts
                          then reach nts'
                          else nts
invert :: Map Nonterminal (Set Nonterminal) -> Map Nonterminal (Set Nonterminal)
invert m = foldr inv Map.empty (Map.toList m)
  where inv (x,ns) m = fold (\n m -> Map.insertWith Set.union n (Set.single x) m) m ns

path :: Map Nonterminal (Set Nonterminal) -> Nonterminal -> Nonterminal -> Set Nonterminal
path table from to = let children = Map.findWithDefault Set.empty from table
                         forward  = reachableFrom table children
                         backward = reachableFrom (invert table)
                                                  (Set.single to)
                     in  Set.intersection forward backward

mergeDerivings m1 m2 = foldr (\(n,cs) m -> Map.insertWith Set.union n cs m) m2 (Map.toList m1)

merge x y = foldr f y (Map.toList x)
 where f ~(k,v) m = Map.insertWith (Map.union) k v m

checkAttrs allFields nts inherited synthesized decls = foldErrors check decls nts where
  check nt decls | not (nt `Map.member` allFields) = (decls,Seq.single(UndefNont nt))
                 | otherwise = let (inh,syn) = Map.findWithDefault (Map.empty,Map.empty) nt decls
                                   (inh',einh) = checkDuplicates (DupInhAttr nt) inherited   inh
                                   (syn',esyn) = checkDuplicates (DupSynAttr nt) synthesized syn
                               in (Map.insert nt (inh',syn') decls,einh <> esyn)

addSelf name atMap = let (eInh,eSyn) = Map.findWithDefault(Map.empty,Map.empty) name atMap
                     in  Map.insert name (eInh, Map.insert (Ident "self" noPos) (NT _SELF) eSyn)atMap

makeType :: Set Nonterminal -> Type -> Type
makeType nts tp@(NT x) | x == _SELF       = tp
                       | Set.member x nts = tp
                       | otherwise        = Haskell (getName x)
makeType _   tp                           = tp

constructGrammar ::    Set Nonterminal
                    -> DataTypes
                    -> Map Nonterminal (Attributes, Attributes)
                    -> Map Nonterminal (Map Name (String, String, String))
                    -> Derivings
                    -> Set Nonterminal
                    -> Map Nonterminal (Map Constructor [Rule])
                    -> Map Nonterminal (Map Constructor [TypeSig])
                    -> TypeSyns
                    -> Grammar

constructGrammar nts gram attrs uses derivings wrappers allrules tsigs tsyns =
   let gr = [ (nt,Map.toList alts) | (nt,alts) <- Map.toList gram]
       prods = map prod gr
       prod (nt,alts) =  let (inh,syn) = Map.findWithDefault (Map.empty,Map.empty) nt attrs
                             rmap      = Map.findWithDefault Map.empty             nt allrules
                             tsmap     = Map.findWithDefault Map.empty             nt tsigs
                             alt (con,flds) =
                                   let rules = maybe [] id (Map.lookup con rmap)          
                                       tsigs = maybe [] id (Map.lookup con tsmap)
                                       child (nm, tp) =
                                          let (inh,syn) = case tp of
                                                 NT nt -> Map.findWithDefault (Map.empty,Map.empty) nt attrs
                                                 _     -> (Map.empty,Map.empty)
                                          in Child nm tp inh syn 
                                   in Alternative con (map child flds) rules tsigs
                            in Production nt inh syn (map alt alts)
   in Grammar tsyns uses derivings wrappers prods
 

mapUnionWithSetUnion = Map.unionWith Set.union
mapUnionWithPlusPlus = Map.unionWith (++)	
-- AG ----------------------------------------------------------
{-
   inherited attributes:
      options              : Options

   chained attributes:

   synthesised attributes:
      blocks               : Blocks
      errors               : Seq Error
      output               : Grammar
      pragmas              : Options -> Options

-}
{-
   local variables for AG.AG:
      errs5
      errs4
      errs3
      errs2
      errs1
      checkedSigs
      checkedRules
      allSigsErrs
      allRulesErrs
      allSigs
      allRules
      allConstrs
      allFields
      allNonterminals
      allAttrDecls

-}
-- semantic domain
newtype T_AG = T_AG ((Options) ->
                     ( (Blocks),(Seq Error),(Grammar),(Options -> Options)))
-- cata
sem_AG :: (AG) ->
          (T_AG)
sem_AG ((AG (_elems))) =
    (sem_AG_AG ((sem_Elems (_elems))))
data Inh_AG = Inh_AG {options_Inh_AG :: Options}
data Syn_AG = Syn_AG {blocks_Syn_AG :: Blocks,errors_Syn_AG :: Seq Error,output_Syn_AG :: Grammar,pragmas_Syn_AG :: Options -> Options}
wrap_AG :: (T_AG) ->
           (Inh_AG) ->
           (Syn_AG)
wrap_AG ((T_AG (sem))) ((Inh_AG (i1))) =
    let ( s1,s2,s3,s4) =
            (sem (i1))
    in  (Syn_AG (s1) (s2) (s3) (s4))
sem_AG_AG :: (T_Elems) ->
             (T_AG)
sem_AG_AG ((T_Elems (elems_))) =
    (T_AG (\ _lhsIoptions ->
               let _lhsOblocks :: (Blocks)
                   _lhsOerrors :: (Seq Error)
                   _lhsOoutput :: (Grammar)
                   _lhsOpragmas :: (Options -> Options)
                   _elemsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                   _elemsIblocks :: (Blocks)
                   _elemsIcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                   _elemsIcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                   _elemsIcollectedNames :: (Set Name)
                   _elemsIcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                   _elemsIcollectedSetNames :: (Set Name)
                   _elemsIcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                   _elemsIdefSets :: (Map Name (Set Nonterminal,Set Name))
                   _elemsIderivings :: (Derivings)
                   _elemsIerrors :: (Seq Error)
                   _elemsIpragmas :: (Options -> Options)
                   _elemsItypeSyns :: (TypeSyns)
                   _elemsIuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                   _elemsIwrappers :: (Set Nonterminal)
                   _elemsOallConstructors :: (Map Nonterminal (Set Constructor))
                   _elemsOallFields :: (DataTypes)
                   _elemsOallNonterminals :: (Set Nonterminal)
                   _elemsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                   _elemsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                   _elemsOdefinedSets :: (DefinedSets)
                   ( _elemsIattrDecls,_elemsIblocks,_elemsIcollectedConstructorsMap,_elemsIcollectedFields,_elemsIcollectedNames,_elemsIcollectedRules,_elemsIcollectedSetNames,_elemsIcollectedSigs,_elemsIdefSets,_elemsIderivings,_elemsIerrors,_elemsIpragmas,_elemsItypeSyns,_elemsIuseMap,_elemsIwrappers) =
                       (elems_ (_elemsOallConstructors) (_elemsOallFields) (_elemsOallNonterminals) (_elemsOattrDecls) (_elemsOdefSets) (_elemsOdefinedSets))
                   -- "Transform.ag"(line 43, column 8)
                   (_lhsOoutput@_) =
                       constructGrammar _allNonterminals
                                        _allFields
                                        _allAttrDecls
                                        _elemsIuseMap
                                        _elemsIderivings
                                        (if wrappers _lhsIoptions then _allNonterminals     else _elemsIwrappers)
                                        _checkedRules
                                        _checkedSigs
                                        _elemsItypeSyns
                   -- "Transform.ag"(line 246, column 10)
                   (_lhsOerrors@_) =
                       _elemsIerrors <> _errs1 <> _errs2 <> _errs3 <> _errs4 <> _errs5
                   -- "Transform.ag"(line 243, column 10)
                   (_errs5@_) =
                       let  f m s = Map.fold ((<>) . snd) s m
                       in Map.fold f Seq.empty _allSigsErrs
                   -- "Transform.ag"(line 240, column 10)
                   (_errs4@_) =
                       let  f m s = Map.fold ((<>) . snd) s m
                       in Map.fold f Seq.empty _allRulesErrs
                   -- "Transform.ag"(line 236, column 10)
                   (_errs3@_) =
                       let f (nt,cons) = checkForDuplicates (DupAlt nt) cons
                       in   Seq.empty
                   -- "Transform.ag"(line 232, column 10)
                   (_errs2@_) =
                       let g nt (con,fm) = checkForDuplicates (DupChild nt con) (map fst fm)
                           f (nt,cfm)    = concat . map (g nt) . Map.toList $ cfm
                       in  Seq.fromList . concat . map f . Map.toList $ _allFields
                   -- "Transform.ag"(line 229, column 10)
                   (_errs1@_) =
                       let f = checkForDuplicates (DupSynonym)
                       in  Seq.fromList . f . map fst $ _elemsItypeSyns
                   -- "Transform.ag"(line 227, column 10)
                   (_checkedSigs@_) =
                       Map.map (Map.map fst) _allSigsErrs
                   -- "Transform.ag"(line 226, column 10)
                   (_checkedRules@_) =
                       Map.map (Map.map fst) _allRulesErrs
                   -- "Transform.ag"(line 224, column 10)
                   (_allSigsErrs@_) =
                       Map.mapWithKey (Map.mapWithKey . (checkSigs                          )) _allSigs
                   -- "Transform.ag"(line 223, column 10)
                   (_allRulesErrs@_) =
                       Map.mapWithKey (Map.mapWithKey . (checkRules _allAttrDecls _allFields)) _allRules
                   -- "Transform.ag"(line 220, column 10)
                   (_allSigs@_) =
                       let f (nt,con,t) = Map.insertWith (Map.unionWith (++)) nt (Map.single con [t])
                       in  foldr f (Map.empty) _elemsIcollectedSigs
                   -- "Transform.ag"(line 217, column 10)
                   (_allRules@_) =
                       let f (nt,con,r) = Map.insertWith (Map.unionWith (++)) nt (Map.single con [r])
                       in  foldr f (Map.empty) _elemsIcollectedRules
                   -- "Transform.ag"(line 214, column 10)
                   (_allConstrs@_) =
                       let f (nt,con,_) = Map.insertWith (++) nt [con]
                       in  foldr f (Map.empty) _elemsIcollectedFields
                   -- "Transform.ag"(line 211, column 10)
                   (_allFields@_) =
                       let f (nt,con,fm) = Map.insertWith (Map.unionWith (++)) nt (Map.single con fm)
                       in  foldr f (Map.empty) _elemsIcollectedFields
                   -- "Transform.ag"(line 313, column 10)
                   (_allNonterminals@_) =
                       _elemsIcollectedNames `Set.difference` _elemsIcollectedSetNames
                   -- "Transform.ag"(line 333, column 8)
                   (_elemsOallConstructors@_) =
                       _elemsIcollectedConstructorsMap
                   -- "Transform.ag"(line 388, column 8)
                   (_elemsOdefinedSets@_) =
                       Map.map fst _elemsIdefSets
                   -- "Transform.ag"(line 387, column 8)
                   (_elemsOdefSets@_) =
                       Map.fromList (map (\x->(x,(Set.single x, Set.empty))) (Set.toList _allNonterminals    ))
                   -- "Transform.ag"(line 515, column 8)
                   (_elemsOattrDecls@_) =
                       Map.empty
                   -- "Transform.ag"(line 554, column 9)
                   (_allAttrDecls@_) =
                       if withSelf _lhsIoptions
                        then foldr addSelf _elemsIattrDecls (Set.toList _allNonterminals    )
                        else               _elemsIattrDecls
                   -- use rule
                   (_lhsOblocks@_) =
                       _elemsIblocks
                   -- use rule
                   (_lhsOpragmas@_) =
                       _elemsIpragmas
                   -- copy rule (from local)
                   (_elemsOallFields@_) =
                       _allFields
                   -- copy rule (from local)
                   (_elemsOallNonterminals@_) =
                       _allNonterminals
               in  ( _lhsOblocks,_lhsOerrors,_lhsOoutput,_lhsOpragmas)))
-- Alt ---------------------------------------------------------
{-
   inherited attributes:
      allConstructors      : Map Nonterminal (Set Constructor)
      allNonterminals      : Set Nonterminal
      nts                  : Set Nonterminal

   chained attributes:

   synthesised attributes:
      collectedConstructorNames : Set Constructor
      collectedFields      : [(Nonterminal, Constructor, FieldMap)]

-}
{-
   local variables for Alt.Alt:

-}
-- semantic domain
newtype T_Alt = T_Alt ((Map Nonterminal (Set Constructor)) ->
                       (Set Nonterminal) ->
                       (Set Nonterminal) ->
                       ( (Set Constructor),([(Nonterminal, Constructor, FieldMap)])))
-- cata
sem_Alt :: (Alt) ->
           (T_Alt)
sem_Alt ((Alt (_pos) (_names) (_fields))) =
    (sem_Alt_Alt (_pos) ((sem_ConstructorSet (_names))) (_fields))
data Inh_Alt = Inh_Alt {allConstructors_Inh_Alt :: Map Nonterminal (Set Constructor),allNonterminals_Inh_Alt :: Set Nonterminal,nts_Inh_Alt :: Set Nonterminal}
data Syn_Alt = Syn_Alt {collectedConstructorNames_Syn_Alt :: Set Constructor,collectedFields_Syn_Alt :: [(Nonterminal, Constructor, FieldMap)]}
wrap_Alt :: (T_Alt) ->
            (Inh_Alt) ->
            (Syn_Alt)
wrap_Alt ((T_Alt (sem))) ((Inh_Alt (i1) (i2) (i3))) =
    let ( s1,s2) =
            (sem (i1) (i2) (i3))
    in  (Syn_Alt (s1) (s2))
sem_Alt_Alt :: (Pos) ->
               (T_ConstructorSet) ->
               (Fields) ->
               (T_Alt)
sem_Alt_Alt (pos_) ((T_ConstructorSet (names_))) (fields_) =
    (T_Alt (\ _lhsIallConstructors
              _lhsIallNonterminals
              _lhsInts ->
                let _lhsOcollectedConstructorNames :: (Set Constructor)
                    _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                    _namesIcollectedConstructorNames :: (Set Constructor)
                    _namesIconstructors :: ((Set Constructor->Set Constructor))
                    _namesIerrors :: (Seq Error)
                    ( _namesIcollectedConstructorNames,_namesIconstructors,_namesIerrors) =
                        (names_ )
                    -- "Transform.ag"(line 196, column 10)
                    (_lhsOcollectedFields@_) =
                        let fieldTable =
                             [ (attr, makeType _lhsIallNonterminals tp)
                             | (attr, tp) <- fields_
                             ]
                        in   [ (nt, con, fieldTable)
                             | nt  <- Set.toList _lhsInts
                             , con <- Set.toList (_namesIconstructors (Map.findWithDefault Set.empty nt _lhsIallConstructors))
                             ]
                    -- use rule
                    (_lhsOcollectedConstructorNames@_) =
                        _namesIcollectedConstructorNames
                in  ( _lhsOcollectedConstructorNames,_lhsOcollectedFields)))
-- Alts --------------------------------------------------------
{-
   inherited attributes:
      allConstructors      : Map Nonterminal (Set Constructor)
      allNonterminals      : Set Nonterminal
      nts                  : Set Nonterminal

   chained attributes:

   synthesised attributes:
      collectedConstructorNames : Set Constructor
      collectedFields      : [(Nonterminal, Constructor, FieldMap)]

-}
{-
   local variables for Alts.Cons:

-}
{-
   local variables for Alts.Nil:

-}
-- semantic domain
newtype T_Alts = T_Alts ((Map Nonterminal (Set Constructor)) ->
                         (Set Nonterminal) ->
                         (Set Nonterminal) ->
                         ( (Set Constructor),([(Nonterminal, Constructor, FieldMap)])))
-- cata
sem_Alts :: (Alts) ->
            (T_Alts)
sem_Alts (list) =
    (Prelude.foldr (sem_Alts_Cons) (sem_Alts_Nil) ((Prelude.map sem_Alt list)))
data Inh_Alts = Inh_Alts {allConstructors_Inh_Alts :: Map Nonterminal (Set Constructor),allNonterminals_Inh_Alts :: Set Nonterminal,nts_Inh_Alts :: Set Nonterminal}
data Syn_Alts = Syn_Alts {collectedConstructorNames_Syn_Alts :: Set Constructor,collectedFields_Syn_Alts :: [(Nonterminal, Constructor, FieldMap)]}
wrap_Alts :: (T_Alts) ->
             (Inh_Alts) ->
             (Syn_Alts)
wrap_Alts ((T_Alts (sem))) ((Inh_Alts (i1) (i2) (i3))) =
    let ( s1,s2) =
            (sem (i1) (i2) (i3))
    in  (Syn_Alts (s1) (s2))
sem_Alts_Cons :: (T_Alt) ->
                 (T_Alts) ->
                 (T_Alts)
sem_Alts_Cons ((T_Alt (hd_))) ((T_Alts (tl_))) =
    (T_Alts (\ _lhsIallConstructors
               _lhsIallNonterminals
               _lhsInts ->
                 let _lhsOcollectedConstructorNames :: (Set Constructor)
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _hdIcollectedConstructorNames :: (Set Constructor)
                     _hdIcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _hdOallConstructors :: (Map Nonterminal (Set Constructor))
                     _hdOallNonterminals :: (Set Nonterminal)
                     _hdOnts :: (Set Nonterminal)
                     _tlIcollectedConstructorNames :: (Set Constructor)
                     _tlIcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _tlOallConstructors :: (Map Nonterminal (Set Constructor))
                     _tlOallNonterminals :: (Set Nonterminal)
                     _tlOnts :: (Set Nonterminal)
                     ( _hdIcollectedConstructorNames,_hdIcollectedFields) =
                         (hd_ (_hdOallConstructors) (_hdOallNonterminals) (_hdOnts))
                     ( _tlIcollectedConstructorNames,_tlIcollectedFields) =
                         (tl_ (_tlOallConstructors) (_tlOallNonterminals) (_tlOnts))
                     -- use rule
                     (_lhsOcollectedConstructorNames@_) =
                         _hdIcollectedConstructorNames `Set.union` _tlIcollectedConstructorNames
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         _hdIcollectedFields ++ _tlIcollectedFields
                     -- copy rule (down)
                     (_hdOallConstructors@_) =
                         _lhsIallConstructors
                     -- copy rule (down)
                     (_hdOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_hdOnts@_) =
                         _lhsInts
                     -- copy rule (down)
                     (_tlOallConstructors@_) =
                         _lhsIallConstructors
                     -- copy rule (down)
                     (_tlOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_tlOnts@_) =
                         _lhsInts
                 in  ( _lhsOcollectedConstructorNames,_lhsOcollectedFields)))
sem_Alts_Nil :: (T_Alts)
sem_Alts_Nil  =
    (T_Alts (\ _lhsIallConstructors
               _lhsIallNonterminals
               _lhsInts ->
                 let _lhsOcollectedConstructorNames :: (Set Constructor)
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     -- use rule
                     (_lhsOcollectedConstructorNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                 in  ( _lhsOcollectedConstructorNames,_lhsOcollectedFields)))
-- Attrs -------------------------------------------------------
{-
   inherited attributes:
      allFields            : DataTypes
      allNonterminals      : Set Nonterminal
      nts                  : Set Nonterminal

   chained attributes:
      attrDecls            : Map Nonterminal (Attributes, Attributes)

   synthesised attributes:
      errors               : Seq Error
      useMap               : Map Nonterminal (Map Name (String,String,String))

-}
{-
   local variables for Attrs.Attrs:
      inherited
      synthesized
      useMap
      attrDecls
      errors

-}
-- semantic domain
newtype T_Attrs = T_Attrs ((DataTypes) ->
                           (Set Nonterminal) ->
                           (Map Nonterminal (Attributes, Attributes)) ->
                           (Set Nonterminal) ->
                           ( (Map Nonterminal (Attributes, Attributes)),(Seq Error),(Map Nonterminal (Map Name (String,String,String)))))
-- cata
sem_Attrs :: (Attrs) ->
             (T_Attrs)
sem_Attrs ((Attrs (_pos) (_inh) (_chn) (_syn))) =
    (sem_Attrs_Attrs (_pos) (_inh) (_chn) (_syn))
data Inh_Attrs = Inh_Attrs {allFields_Inh_Attrs :: DataTypes,allNonterminals_Inh_Attrs :: Set Nonterminal,attrDecls_Inh_Attrs :: Map Nonterminal (Attributes, Attributes),nts_Inh_Attrs :: Set Nonterminal}
data Syn_Attrs = Syn_Attrs {attrDecls_Syn_Attrs :: Map Nonterminal (Attributes, Attributes),errors_Syn_Attrs :: Seq Error,useMap_Syn_Attrs :: Map Nonterminal (Map Name (String,String,String))}
wrap_Attrs :: (T_Attrs) ->
              (Inh_Attrs) ->
              (Syn_Attrs)
wrap_Attrs ((T_Attrs (sem))) ((Inh_Attrs (i1) (i2) (i3) (i4))) =
    let ( s1,s2,s3) =
            (sem (i1) (i2) (i3) (i4))
    in  (Syn_Attrs (s1) (s2) (s3))
sem_Attrs_Attrs :: (Pos) ->
                   (AttrNames) ->
                   (AttrNames) ->
                   (AttrNames) ->
                   (T_Attrs)
sem_Attrs_Attrs (pos_) (inh_) (chn_) (syn_) =
    (T_Attrs (\ _lhsIallFields
                _lhsIallNonterminals
                _lhsIattrDecls
                _lhsInts ->
                  let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _lhsOerrors :: (Seq Error)
                      _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                      -- "Transform.ag"(line 533, column 11)
                      (_lhsOuseMap@_) =
                          Map.fromList (zip (Set.toList _lhsInts) (repeat _useMap))
                      -- "Transform.ag"(line 525, column 15)
                      ((_inherited@_,_synthesized@_,_useMap@_)) =
                          let splitAttrs xs = unzip [ ((n,makeType _lhsIallNonterminals t),(n,ud))
                                                    | (n,t,ud) <- xs
                                                    ]
                              (inh,_)     = splitAttrs inh_
                              (chn,uses1) = splitAttrs chn_
                              (syn,uses2) = splitAttrs syn_
                              isUse (n,(e1,e2,_)) = not (null e1 || null e2)
                          in (inh++chn,chn++syn, Map.fromList (Prelude.filter isUse (uses1++uses2)))
                      -- "Transform.ag"(line 523, column 15)
                      ((_attrDecls@_,_errors@_)) =
                          checkAttrs _lhsIallFields (Set.toList _lhsInts) _inherited _synthesized _lhsIattrDecls
                      -- use rule
                      (_lhsOerrors@_) =
                          _errors
                      -- copy rule (from local)
                      (_lhsOattrDecls@_) =
                          _attrDecls
                  in  ( _lhsOattrDecls,_lhsOerrors,_lhsOuseMap)))
-- ConstructorSet ----------------------------------------------
{-
   inherited attributes:

   chained attributes:

   synthesised attributes:
      collectedConstructorNames : Set Constructor
      constructors         : (Set Constructor->Set Constructor)
      errors               : Seq Error

-}
{-
   local variables for ConstructorSet.CAll:

-}
{-
   local variables for ConstructorSet.CDifference:

-}
{-
   local variables for ConstructorSet.CName:

-}
{-
   local variables for ConstructorSet.CUnion:

-}
-- semantic domain
newtype T_ConstructorSet = T_ConstructorSet (( (Set Constructor),((Set Constructor->Set Constructor)),(Seq Error)))
-- cata
sem_ConstructorSet :: (ConstructorSet) ->
                      (T_ConstructorSet)
sem_ConstructorSet ((CAll )) =
    (sem_ConstructorSet_CAll )
sem_ConstructorSet ((CDifference (_set1) (_set2))) =
    (sem_ConstructorSet_CDifference ((sem_ConstructorSet (_set1))) ((sem_ConstructorSet (_set2))))
sem_ConstructorSet ((CName (_name))) =
    (sem_ConstructorSet_CName (_name))
sem_ConstructorSet ((CUnion (_set1) (_set2))) =
    (sem_ConstructorSet_CUnion ((sem_ConstructorSet (_set1))) ((sem_ConstructorSet (_set2))))
data Inh_ConstructorSet = Inh_ConstructorSet {}
data Syn_ConstructorSet = Syn_ConstructorSet {collectedConstructorNames_Syn_ConstructorSet :: Set Constructor,constructors_Syn_ConstructorSet :: (Set Constructor->Set Constructor),errors_Syn_ConstructorSet :: Seq Error}
wrap_ConstructorSet :: (T_ConstructorSet) ->
                       (Inh_ConstructorSet) ->
                       (Syn_ConstructorSet)
wrap_ConstructorSet ((T_ConstructorSet (sem))) ((Inh_ConstructorSet )) =
    let ( s1,s2,s3) =
            (sem )
    in  (Syn_ConstructorSet (s1) (s2) (s3))
sem_ConstructorSet_CAll :: (T_ConstructorSet)
sem_ConstructorSet_CAll  =
    (T_ConstructorSet (let _lhsOcollectedConstructorNames :: (Set Constructor)
                           _lhsOconstructors :: ((Set Constructor->Set Constructor))
                           _lhsOerrors :: (Seq Error)
                           -- "Transform.ag"(line 454, column 17)
                           (_lhsOconstructors@_) =
                               \ds -> ds
                           -- use rule
                           (_lhsOcollectedConstructorNames@_) =
                               Set.empty
                           -- use rule
                           (_lhsOerrors@_) =
                               Seq.empty
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)))
sem_ConstructorSet_CDifference :: (T_ConstructorSet) ->
                                  (T_ConstructorSet) ->
                                  (T_ConstructorSet)
sem_ConstructorSet_CDifference ((T_ConstructorSet (set1_))) ((T_ConstructorSet (set2_))) =
    (T_ConstructorSet (let _lhsOcollectedConstructorNames :: (Set Constructor)
                           _lhsOconstructors :: ((Set Constructor->Set Constructor))
                           _lhsOerrors :: (Seq Error)
                           _set1IcollectedConstructorNames :: (Set Constructor)
                           _set1Iconstructors :: ((Set Constructor->Set Constructor))
                           _set1Ierrors :: (Seq Error)
                           _set2IcollectedConstructorNames :: (Set Constructor)
                           _set2Iconstructors :: ((Set Constructor->Set Constructor))
                           _set2Ierrors :: (Seq Error)
                           ( _set1IcollectedConstructorNames,_set1Iconstructors,_set1Ierrors) =
                               (set1_ )
                           ( _set2IcollectedConstructorNames,_set2Iconstructors,_set2Ierrors) =
                               (set2_ )
                           -- "Transform.ag"(line 453, column 17)
                           (_lhsOconstructors@_) =
                               \ds -> _set1Iconstructors ds `Set.difference` _set2Iconstructors ds
                           -- use rule
                           (_lhsOcollectedConstructorNames@_) =
                               _set1IcollectedConstructorNames `Set.union` _set2IcollectedConstructorNames
                           -- use rule
                           (_lhsOerrors@_) =
                               _set1Ierrors Seq.<> _set2Ierrors
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)))
sem_ConstructorSet_CName :: (Constructor) ->
                            (T_ConstructorSet)
sem_ConstructorSet_CName (name_) =
    (T_ConstructorSet (let _lhsOcollectedConstructorNames :: (Set Constructor)
                           _lhsOconstructors :: ((Set Constructor->Set Constructor))
                           _lhsOerrors :: (Seq Error)
                           -- "Transform.ag"(line 321, column 11)
                           (_lhsOcollectedConstructorNames@_) =
                               Set.single name_
                           -- "Transform.ag"(line 451, column 17)
                           (_lhsOconstructors@_) =
                               \ds -> Set.single name_
                           -- use rule
                           (_lhsOerrors@_) =
                               Seq.empty
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)))
sem_ConstructorSet_CUnion :: (T_ConstructorSet) ->
                             (T_ConstructorSet) ->
                             (T_ConstructorSet)
sem_ConstructorSet_CUnion ((T_ConstructorSet (set1_))) ((T_ConstructorSet (set2_))) =
    (T_ConstructorSet (let _lhsOcollectedConstructorNames :: (Set Constructor)
                           _lhsOconstructors :: ((Set Constructor->Set Constructor))
                           _lhsOerrors :: (Seq Error)
                           _set1IcollectedConstructorNames :: (Set Constructor)
                           _set1Iconstructors :: ((Set Constructor->Set Constructor))
                           _set1Ierrors :: (Seq Error)
                           _set2IcollectedConstructorNames :: (Set Constructor)
                           _set2Iconstructors :: ((Set Constructor->Set Constructor))
                           _set2Ierrors :: (Seq Error)
                           ( _set1IcollectedConstructorNames,_set1Iconstructors,_set1Ierrors) =
                               (set1_ )
                           ( _set2IcollectedConstructorNames,_set2Iconstructors,_set2Ierrors) =
                               (set2_ )
                           -- "Transform.ag"(line 452, column 17)
                           (_lhsOconstructors@_) =
                               \ds -> _set1Iconstructors ds `Set.union`      _set2Iconstructors ds
                           -- use rule
                           (_lhsOcollectedConstructorNames@_) =
                               _set1IcollectedConstructorNames `Set.union` _set2IcollectedConstructorNames
                           -- use rule
                           (_lhsOerrors@_) =
                               _set1Ierrors Seq.<> _set2Ierrors
                       in  ( _lhsOcollectedConstructorNames,_lhsOconstructors,_lhsOerrors)))
-- Elem --------------------------------------------------------
{-
   inherited attributes:
      allConstructors      : Map Nonterminal (Set Constructor)
      allFields            : DataTypes
      allNonterminals      : Set Nonterminal
      definedSets          : DefinedSets

   chained attributes:
      attrDecls            : Map Nonterminal (Attributes, Attributes)
      defSets              : Map Name (Set Nonterminal,Set Name)

   synthesised attributes:
      blocks               : Blocks
      collectedConstructorsMap : Map Nonterminal (Set Constructor)
      collectedFields      : [(Nonterminal, Constructor, FieldMap)]
      collectedNames       : Set Name
      collectedRules       : [ (Nonterminal, Constructor, RuleInfo)]
      collectedSetNames    : Set Name
      collectedSigs        : [ (Nonterminal, Constructor, SigInfo) ]
      derivings            : Derivings
      errors               : Seq Error
      pragmas              : Options -> Options
      typeSyns             : TypeSyns
      useMap               : Map Nonterminal (Map Name (String,String,String))
      wrappers             : Set Nonterminal

-}
{-
   local variables for Elem.Attr:

-}
{-
   local variables for Elem.Data:

-}
{-
   local variables for Elem.Deriving:

-}
{-
   local variables for Elem.Pragma:

-}
{-
   local variables for Elem.Sem:

-}
{-
   local variables for Elem.Set:
      defSets2
      errs

-}
{-
   local variables for Elem.Txt:

-}
{-
   local variables for Elem.Type:
      argType
      expanded

-}
{-
   local variables for Elem.Wrapper:

-}
-- semantic domain
newtype T_Elem = T_Elem ((Map Nonterminal (Set Constructor)) ->
                         (DataTypes) ->
                         (Set Nonterminal) ->
                         (Map Nonterminal (Attributes, Attributes)) ->
                         (Map Name (Set Nonterminal,Set Name)) ->
                         (DefinedSets) ->
                         ( (Map Nonterminal (Attributes, Attributes)),(Blocks),(Map Nonterminal (Set Constructor)),([(Nonterminal, Constructor, FieldMap)]),(Set Name),([ (Nonterminal, Constructor, RuleInfo)]),(Set Name),([ (Nonterminal, Constructor, SigInfo) ]),(Map Name (Set Nonterminal,Set Name)),(Derivings),(Seq Error),(Options -> Options),(TypeSyns),(Map Nonterminal (Map Name (String,String,String))),(Set Nonterminal)))
-- cata
sem_Elem :: (Elem) ->
            (T_Elem)
sem_Elem ((Attr (_pos) (_names) (_attrs))) =
    (sem_Elem_Attr (_pos) ((sem_NontSet (_names))) ((sem_Attrs (_attrs))))
sem_Elem ((Data (_pos) (_names) (_attrs) (_alts) (_ext))) =
    (sem_Elem_Data (_pos) ((sem_NontSet (_names))) ((sem_Attrs (_attrs))) ((sem_Alts (_alts))) (_ext))
sem_Elem ((Deriving (_pos) (_set) (_classes))) =
    (sem_Elem_Deriving (_pos) ((sem_NontSet (_set))) (_classes))
sem_Elem ((Pragma (_pos) (_names))) =
    (sem_Elem_Pragma (_pos) (_names))
sem_Elem ((Sem (_pos) (_names) (_attrs) (_alts))) =
    (sem_Elem_Sem (_pos) ((sem_NontSet (_names))) ((sem_Attrs (_attrs))) ((sem_SemAlts (_alts))))
sem_Elem ((Set (_pos) (_name) (_set))) =
    (sem_Elem_Set (_pos) (_name) ((sem_NontSet (_set))))
sem_Elem ((Txt (_pos) (_name) (_lines))) =
    (sem_Elem_Txt (_pos) (_name) (_lines))
sem_Elem ((Type (_pos) (_name) (_type))) =
    (sem_Elem_Type (_pos) (_name) (_type))
sem_Elem ((Wrapper (_pos) (_set))) =
    (sem_Elem_Wrapper (_pos) ((sem_NontSet (_set))))
data Inh_Elem = Inh_Elem {allConstructors_Inh_Elem :: Map Nonterminal (Set Constructor),allFields_Inh_Elem :: DataTypes,allNonterminals_Inh_Elem :: Set Nonterminal,attrDecls_Inh_Elem :: Map Nonterminal (Attributes, Attributes),defSets_Inh_Elem :: Map Name (Set Nonterminal,Set Name),definedSets_Inh_Elem :: DefinedSets}
data Syn_Elem = Syn_Elem {attrDecls_Syn_Elem :: Map Nonterminal (Attributes, Attributes)
                         ,blocks_Syn_Elem :: Blocks
                         ,collectedConstructorsMap_Syn_Elem :: Map Nonterminal (Set Constructor)
                         ,collectedFields_Syn_Elem :: [(Nonterminal, Constructor, FieldMap)]
                         ,collectedNames_Syn_Elem :: Set Name
                         ,collectedRules_Syn_Elem :: [ (Nonterminal, Constructor, RuleInfo)]
                         ,collectedSetNames_Syn_Elem :: Set Name
                         ,collectedSigs_Syn_Elem :: [ (Nonterminal, Constructor, SigInfo) ]
                         ,defSets_Syn_Elem :: Map Name (Set Nonterminal,Set Name)
                         ,derivings_Syn_Elem :: Derivings
                         ,errors_Syn_Elem :: Seq Error
                         ,pragmas_Syn_Elem :: Options -> Options
                         ,typeSyns_Syn_Elem :: TypeSyns
                         ,useMap_Syn_Elem :: Map Nonterminal (Map Name (String,String,String))
                         ,wrappers_Syn_Elem :: Set Nonterminal
                         }
wrap_Elem :: (T_Elem) ->
             (Inh_Elem) ->
             (Syn_Elem)
wrap_Elem ((T_Elem (sem))) ((Inh_Elem (i1) (i2) (i3) (i4) (i5) (i6))) =
    let ( s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,s13,s14,s15) =
            (sem (i1) (i2) (i3) (i4) (i5) (i6))
    in  (Syn_Elem (s1) (s2) (s3) (s4) (s5) (s6) (s7) (s8) (s9) (s10) (s11) (s12) (s13) (s14) (s15))
sem_Elem_Attr :: (Pos) ->
                 (T_NontSet) ->
                 (T_Attrs) ->
                 (T_Elem)
sem_Elem_Attr (pos_) ((T_NontSet (names_))) ((T_Attrs (attrs_))) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _namesIcollectedNames :: (Set Name)
                     _namesIerrors :: (Seq Error)
                     _namesInontSet :: (Set Nonterminal)
                     _namesOallFields :: (DataTypes)
                     _namesOallNonterminals :: (Set Nonterminal)
                     _namesOdefinedSets :: (DefinedSets)
                     _attrsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsIerrors :: (Seq Error)
                     _attrsIuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _attrsOallFields :: (DataTypes)
                     _attrsOallNonterminals :: (Set Nonterminal)
                     _attrsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsOnts :: (Set Nonterminal)
                     ( _namesIcollectedNames,_namesIerrors,_namesInontSet) =
                         (names_ (_namesOallFields) (_namesOallNonterminals) (_namesOdefinedSets))
                     ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                         (attrs_ (_attrsOallFields) (_attrsOallNonterminals) (_attrsOattrDecls) (_attrsOnts))
                     -- "Transform.ag"(line 519, column 10)
                     (_attrsOnts@_) =
                         _namesInontSet
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         _namesIcollectedNames
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _namesIerrors Seq.<> _attrsIerrors
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         _attrsIuseMap
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (up)
                     (_lhsOattrDecls@_) =
                         _attrsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (down)
                     (_namesOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_namesOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_namesOdefinedSets@_) =
                         _lhsIdefinedSets
                     -- copy rule (down)
                     (_attrsOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_attrsOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_attrsOattrDecls@_) =
                         _lhsIattrDecls
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Data :: (Pos) ->
                 (T_NontSet) ->
                 (T_Attrs) ->
                 (T_Alts) ->
                 (Bool) ->
                 (T_Elem)
sem_Elem_Data (pos_) ((T_NontSet (names_))) ((T_Attrs (attrs_))) ((T_Alts (alts_))) (ext_) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _namesIcollectedNames :: (Set Name)
                     _namesIerrors :: (Seq Error)
                     _namesInontSet :: (Set Nonterminal)
                     _namesOallFields :: (DataTypes)
                     _namesOallNonterminals :: (Set Nonterminal)
                     _namesOdefinedSets :: (DefinedSets)
                     _attrsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsIerrors :: (Seq Error)
                     _attrsIuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _attrsOallFields :: (DataTypes)
                     _attrsOallNonterminals :: (Set Nonterminal)
                     _attrsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsOnts :: (Set Nonterminal)
                     _altsIcollectedConstructorNames :: (Set Constructor)
                     _altsIcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _altsOallConstructors :: (Map Nonterminal (Set Constructor))
                     _altsOallNonterminals :: (Set Nonterminal)
                     _altsOnts :: (Set Nonterminal)
                     ( _namesIcollectedNames,_namesIerrors,_namesInontSet) =
                         (names_ (_namesOallFields) (_namesOallNonterminals) (_namesOdefinedSets))
                     ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                         (attrs_ (_attrsOallFields) (_attrsOallNonterminals) (_attrsOattrDecls) (_attrsOnts))
                     ( _altsIcollectedConstructorNames,_altsIcollectedFields) =
                         (alts_ (_altsOallConstructors) (_altsOallNonterminals) (_altsOnts))
                     -- "Transform.ag"(line 143, column 10)
                     (_altsOnts@_) =
                         _namesInontSet
                     -- "Transform.ag"(line 327, column 11)
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.fromList
                         [ (n, _altsIcollectedConstructorNames)
                         | n <- Set.toList _namesInontSet
                         ]
                     -- "Transform.ag"(line 518, column 10)
                     (_attrsOnts@_) =
                         _namesInontSet
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         _altsIcollectedFields
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         _namesIcollectedNames
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _namesIerrors Seq.<> _attrsIerrors
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         _attrsIuseMap
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (up)
                     (_lhsOattrDecls@_) =
                         _attrsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (down)
                     (_namesOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_namesOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_namesOdefinedSets@_) =
                         _lhsIdefinedSets
                     -- copy rule (down)
                     (_attrsOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_attrsOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_attrsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (down)
                     (_altsOallConstructors@_) =
                         _lhsIallConstructors
                     -- copy rule (down)
                     (_altsOallNonterminals@_) =
                         _lhsIallNonterminals
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Deriving :: (Pos) ->
                     (T_NontSet) ->
                     ([Name]) ->
                     (T_Elem)
sem_Elem_Deriving (pos_) ((T_NontSet (set_))) (classes_) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _setIcollectedNames :: (Set Name)
                     _setIerrors :: (Seq Error)
                     _setInontSet :: (Set Nonterminal)
                     _setOallFields :: (DataTypes)
                     _setOallNonterminals :: (Set Nonterminal)
                     _setOdefinedSets :: (DefinedSets)
                     ( _setIcollectedNames,_setIerrors,_setInontSet) =
                         (set_ (_setOallFields) (_setOallNonterminals) (_setOdefinedSets))
                     -- "Transform.ag"(line 503, column 14)
                     (_lhsOderivings@_) =
                         Map.fromList [(nt,Set.fromList classes_) | nt <- Set.toList _setInontSet]
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         _setIcollectedNames
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOerrors@_) =
                         _setIerrors
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (down)
                     (_setOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_setOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_setOdefinedSets@_) =
                         _lhsIdefinedSets
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Pragma :: (Pos) ->
                   ([Name]) ->
                   (T_Elem)
sem_Elem_Pragma (pos_) (names_) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     -- "Transform.ag"(line 472, column 13)
                     (_lhsOpragmas@_) =
                         let mk n o = case getName n of
                                        "nocycle"      -> o { withCycle  = False }
                                        "cycle"        -> o { withCycle  = True  }
                                        "nostrictdata" -> o { strictData = False }
                                        "strictdata"   -> o { strictData = True  }
                                        "nostrictwrap" -> o { strictWrap = False }
                                        "strictwrap"   -> o { strictWrap = True  }
                                        "novisit"      -> o { visit      = False }
                                        "visit"        -> o { visit      = True  }
                                        "nocase"       -> o { cases      = False }
                                        "case"         -> o { cases      = True  }
                                        "noseq"        -> o { withSeq    = False }
                                        "seq"          -> o { withSeq    = True  }
                                        "nounbox"      -> o { unbox      = False }
                                        "unbox"        -> o { unbox      = True  }
                                        "nooptimize"   -> o { cases = False , visit = False }
                                        "optimize"     -> o { cases = True  , visit = True  }
                                        _              -> o
                         in  \o -> foldr mk o names_
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         Seq.empty
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Sem :: (Pos) ->
                (T_NontSet) ->
                (T_Attrs) ->
                (T_SemAlts) ->
                (T_Elem)
sem_Elem_Sem (pos_) ((T_NontSet (names_))) ((T_Attrs (attrs_))) ((T_SemAlts (alts_))) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _namesIcollectedNames :: (Set Name)
                     _namesIerrors :: (Seq Error)
                     _namesInontSet :: (Set Nonterminal)
                     _namesOallFields :: (DataTypes)
                     _namesOallNonterminals :: (Set Nonterminal)
                     _namesOdefinedSets :: (DefinedSets)
                     _attrsIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsIerrors :: (Seq Error)
                     _attrsIuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _attrsOallFields :: (DataTypes)
                     _attrsOallNonterminals :: (Set Nonterminal)
                     _attrsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _attrsOnts :: (Set Nonterminal)
                     _altsIcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _altsIcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _altsIerrors :: (Seq Error)
                     _altsOallFields :: (DataTypes)
                     _altsOnts :: (Set Nonterminal)
                     ( _namesIcollectedNames,_namesIerrors,_namesInontSet) =
                         (names_ (_namesOallFields) (_namesOallNonterminals) (_namesOdefinedSets))
                     ( _attrsIattrDecls,_attrsIerrors,_attrsIuseMap) =
                         (attrs_ (_attrsOallFields) (_attrsOallNonterminals) (_attrsOattrDecls) (_attrsOnts))
                     ( _altsIcollectedRules,_altsIcollectedSigs,_altsIerrors) =
                         (alts_ (_altsOallFields) (_altsOnts))
                     -- "Transform.ag"(line 144, column 10)
                     (_altsOnts@_) =
                         _namesInontSet
                     -- "Transform.ag"(line 520, column 10)
                     (_attrsOnts@_) =
                         _namesInontSet
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         _namesIcollectedNames
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         _altsIcollectedRules
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         _altsIcollectedSigs
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _namesIerrors Seq.<> _attrsIerrors Seq.<> _altsIerrors
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         _attrsIuseMap
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (up)
                     (_lhsOattrDecls@_) =
                         _attrsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (down)
                     (_namesOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_namesOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_namesOdefinedSets@_) =
                         _lhsIdefinedSets
                     -- copy rule (down)
                     (_attrsOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_attrsOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_attrsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (down)
                     (_altsOallFields@_) =
                         _lhsIallFields
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Set :: (Pos) ->
                (Name) ->
                (T_NontSet) ->
                (T_Elem)
sem_Elem_Set (pos_) (name_) ((T_NontSet (set_))) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _setIcollectedNames :: (Set Name)
                     _setIerrors :: (Seq Error)
                     _setInontSet :: (Set Nonterminal)
                     _setOallFields :: (DataTypes)
                     _setOallNonterminals :: (Set Nonterminal)
                     _setOdefinedSets :: (DefinedSets)
                     ( _setIcollectedNames,_setIerrors,_setInontSet) =
                         (set_ (_setOallFields) (_setOallNonterminals) (_setOdefinedSets))
                     -- "Transform.ag"(line 304, column 10)
                     (_lhsOcollectedSetNames@_) =
                         Set.single name_
                     -- "Transform.ag"(line 402, column 9)
                     (_lhsOerrors@_) =
                         _errs <> _setIerrors
                     -- "Transform.ag"(line 402, column 9)
                     (_lhsOdefSets@_) =
                         _defSets2
                     -- "Transform.ag"(line 392, column 13)
                     ((_defSets2@_,_errs@_)) =
                         let allUsedNames = Set.unions [ maybe (Set.single n)
                                                               snd
                                                               (Map.lookup n _lhsIdefSets)
                                                       | n <- Set.toList _setIcollectedNames
                                                       ]
                             (nontSet,e1) | Set.member name_ allUsedNames
                                                      = (Set.empty, Seq.single(CyclicSet name_))
                                          | otherwise = (_setInontSet, Seq.empty)
                             (res, e2) = checkDuplicate DupSet  name_ (nontSet,Set.insert name_ allUsedNames) _lhsIdefSets
                         in (res, e1 Seq.<> e2)
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         _setIcollectedNames
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (down)
                     (_setOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_setOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_setOdefinedSets@_) =
                         _lhsIdefinedSets
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Txt :: (Pos) ->
                (Name) ->
                ([String]) ->
                (T_Elem)
sem_Elem_Txt (pos_) (name_) (lines_) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     -- "Transform.ag"(line 153, column 11)
                     (_lhsOblocks@_) =
                         Map.single (getName name_) lines_
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         Seq.empty
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Type :: (Pos) ->
                 (Nonterminal) ->
                 (ComplexType) ->
                 (T_Elem)
sem_Elem_Type (pos_) (name_) (type_) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     -- "Transform.ag"(line 206, column 10)
                     (_lhsOcollectedFields@_) =
                         map (\(x,y)->(name_, x, y)) _expanded
                     -- "Transform.ag"(line 307, column 11)
                     (_lhsOcollectedNames@_) =
                         Set.single name_
                     -- "Transform.ag"(line 378, column 11)
                     (_lhsOtypeSyns@_) =
                         [(name_,_argType)]
                     -- "Transform.ag"(line 374, column 11)
                     (_argType@_) =
                         case type_ of
                          Maybe tp  -> Maybe  (  makeType _lhsIallNonterminals tp)
                          List tp   -> List   (  makeType _lhsIallNonterminals tp)
                          Tuple xs  -> Tuple [(f,makeType _lhsIallNonterminals tp) | (f,tp) <- xs]
                     -- "Transform.ag"(line 361, column 11)
                     (_expanded@_) =
                         case _argType of
                                 List tp -> [(Ident "Cons" pos_, [(Ident "hd" pos_, tp)
                                                                 ,(Ident "tl" pos_, NT name_)
                                                                 ]
                                             )
                                            ,(Ident "Nil" pos_,  [])
                                            ]
                                 Maybe tp -> [(Ident "Just" pos_, [(Ident "just" pos_, tp)
                                                                 ]
                                             )
                                            ,(Ident "Nothing" pos_,  [])
                                            ]
                                 Tuple xs -> [(Ident "Tuple" pos_, xs)]
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         Seq.empty
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOwrappers@_) =
                         Set.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elem_Wrapper :: (Pos) ->
                    (T_NontSet) ->
                    (T_Elem)
sem_Elem_Wrapper (pos_) ((T_NontSet (set_))) =
    (T_Elem (\ _lhsIallConstructors
               _lhsIallFields
               _lhsIallNonterminals
               _lhsIattrDecls
               _lhsIdefSets
               _lhsIdefinedSets ->
                 let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                     _lhsOblocks :: (Blocks)
                     _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                     _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                     _lhsOcollectedNames :: (Set Name)
                     _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                     _lhsOcollectedSetNames :: (Set Name)
                     _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                     _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                     _lhsOderivings :: (Derivings)
                     _lhsOerrors :: (Seq Error)
                     _lhsOpragmas :: (Options -> Options)
                     _lhsOtypeSyns :: (TypeSyns)
                     _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                     _lhsOwrappers :: (Set Nonterminal)
                     _setIcollectedNames :: (Set Name)
                     _setIerrors :: (Seq Error)
                     _setInontSet :: (Set Nonterminal)
                     _setOallFields :: (DataTypes)
                     _setOallNonterminals :: (Set Nonterminal)
                     _setOdefinedSets :: (DefinedSets)
                     ( _setIcollectedNames,_setIerrors,_setInontSet) =
                         (set_ (_setOallFields) (_setOallNonterminals) (_setOdefinedSets))
                     -- "Transform.ag"(line 463, column 13)
                     (_lhsOwrappers@_) =
                         _setInontSet
                     -- use rule
                     (_lhsOblocks@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedConstructorsMap@_) =
                         Map.empty
                     -- use rule
                     (_lhsOcollectedFields@_) =
                         []
                     -- use rule
                     (_lhsOcollectedNames@_) =
                         _setIcollectedNames
                     -- use rule
                     (_lhsOcollectedRules@_) =
                         []
                     -- use rule
                     (_lhsOcollectedSetNames@_) =
                         Set.empty
                     -- use rule
                     (_lhsOcollectedSigs@_) =
                         []
                     -- use rule
                     (_lhsOderivings@_) =
                         Map.empty
                     -- use rule
                     (_lhsOerrors@_) =
                         _setIerrors
                     -- use rule
                     (_lhsOpragmas@_) =
                         id
                     -- use rule
                     (_lhsOtypeSyns@_) =
                         []
                     -- use rule
                     (_lhsOuseMap@_) =
                         Map.empty
                     -- copy rule (chain)
                     (_lhsOattrDecls@_) =
                         _lhsIattrDecls
                     -- copy rule (chain)
                     (_lhsOdefSets@_) =
                         _lhsIdefSets
                     -- copy rule (down)
                     (_setOallFields@_) =
                         _lhsIallFields
                     -- copy rule (down)
                     (_setOallNonterminals@_) =
                         _lhsIallNonterminals
                     -- copy rule (down)
                     (_setOdefinedSets@_) =
                         _lhsIdefinedSets
                 in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
-- Elems -------------------------------------------------------
{-
   inherited attributes:
      allConstructors      : Map Nonterminal (Set Constructor)
      allFields            : DataTypes
      allNonterminals      : Set Nonterminal
      definedSets          : DefinedSets

   chained attributes:
      attrDecls            : Map Nonterminal (Attributes, Attributes)
      defSets              : Map Name (Set Nonterminal,Set Name)

   synthesised attributes:
      blocks               : Blocks
      collectedConstructorsMap : Map Nonterminal (Set Constructor)
      collectedFields      : [(Nonterminal, Constructor, FieldMap)]
      collectedNames       : Set Name
      collectedRules       : [ (Nonterminal, Constructor, RuleInfo)]
      collectedSetNames    : Set Name
      collectedSigs        : [ (Nonterminal, Constructor, SigInfo) ]
      derivings            : Derivings
      errors               : Seq Error
      pragmas              : Options -> Options
      typeSyns             : TypeSyns
      useMap               : Map Nonterminal (Map Name (String,String,String))
      wrappers             : Set Nonterminal

-}
{-
   local variables for Elems.Cons:

-}
{-
   local variables for Elems.Nil:

-}
-- semantic domain
newtype T_Elems = T_Elems ((Map Nonterminal (Set Constructor)) ->
                           (DataTypes) ->
                           (Set Nonterminal) ->
                           (Map Nonterminal (Attributes, Attributes)) ->
                           (Map Name (Set Nonterminal,Set Name)) ->
                           (DefinedSets) ->
                           ( (Map Nonterminal (Attributes, Attributes)),(Blocks),(Map Nonterminal (Set Constructor)),([(Nonterminal, Constructor, FieldMap)]),(Set Name),([ (Nonterminal, Constructor, RuleInfo)]),(Set Name),([ (Nonterminal, Constructor, SigInfo) ]),(Map Name (Set Nonterminal,Set Name)),(Derivings),(Seq Error),(Options -> Options),(TypeSyns),(Map Nonterminal (Map Name (String,String,String))),(Set Nonterminal)))
-- cata
sem_Elems :: (Elems) ->
             (T_Elems)
sem_Elems (list) =
    (Prelude.foldr (sem_Elems_Cons) (sem_Elems_Nil) ((Prelude.map sem_Elem list)))
data Inh_Elems = Inh_Elems {allConstructors_Inh_Elems :: Map Nonterminal (Set Constructor),allFields_Inh_Elems :: DataTypes,allNonterminals_Inh_Elems :: Set Nonterminal,attrDecls_Inh_Elems :: Map Nonterminal (Attributes, Attributes),defSets_Inh_Elems :: Map Name (Set Nonterminal,Set Name),definedSets_Inh_Elems :: DefinedSets}
data Syn_Elems = Syn_Elems {attrDecls_Syn_Elems :: Map Nonterminal (Attributes, Attributes)
                           ,blocks_Syn_Elems :: Blocks
                           ,collectedConstructorsMap_Syn_Elems :: Map Nonterminal (Set Constructor)
                           ,collectedFields_Syn_Elems :: [(Nonterminal, Constructor, FieldMap)]
                           ,collectedNames_Syn_Elems :: Set Name
                           ,collectedRules_Syn_Elems :: [ (Nonterminal, Constructor, RuleInfo)]
                           ,collectedSetNames_Syn_Elems :: Set Name
                           ,collectedSigs_Syn_Elems :: [ (Nonterminal, Constructor, SigInfo) ]
                           ,defSets_Syn_Elems :: Map Name (Set Nonterminal,Set Name)
                           ,derivings_Syn_Elems :: Derivings
                           ,errors_Syn_Elems :: Seq Error
                           ,pragmas_Syn_Elems :: Options -> Options
                           ,typeSyns_Syn_Elems :: TypeSyns
                           ,useMap_Syn_Elems :: Map Nonterminal (Map Name (String,String,String))
                           ,wrappers_Syn_Elems :: Set Nonterminal
                           }
wrap_Elems :: (T_Elems) ->
              (Inh_Elems) ->
              (Syn_Elems)
wrap_Elems ((T_Elems (sem))) ((Inh_Elems (i1) (i2) (i3) (i4) (i5) (i6))) =
    let ( s1,s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s12,s13,s14,s15) =
            (sem (i1) (i2) (i3) (i4) (i5) (i6))
    in  (Syn_Elems (s1) (s2) (s3) (s4) (s5) (s6) (s7) (s8) (s9) (s10) (s11) (s12) (s13) (s14) (s15))
sem_Elems_Cons :: (T_Elem) ->
                  (T_Elems) ->
                  (T_Elems)
sem_Elems_Cons ((T_Elem (hd_))) ((T_Elems (tl_))) =
    (T_Elems (\ _lhsIallConstructors
                _lhsIallFields
                _lhsIallNonterminals
                _lhsIattrDecls
                _lhsIdefSets
                _lhsIdefinedSets ->
                  let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _lhsOblocks :: (Blocks)
                      _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                      _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                      _lhsOcollectedNames :: (Set Name)
                      _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Name)
                      _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                      _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _lhsOderivings :: (Derivings)
                      _lhsOerrors :: (Seq Error)
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOtypeSyns :: (TypeSyns)
                      _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                      _lhsOwrappers :: (Set Nonterminal)
                      _hdIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _hdIblocks :: (Blocks)
                      _hdIcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                      _hdIcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                      _hdIcollectedNames :: (Set Name)
                      _hdIcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                      _hdIcollectedSetNames :: (Set Name)
                      _hdIcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                      _hdIdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _hdIderivings :: (Derivings)
                      _hdIerrors :: (Seq Error)
                      _hdIpragmas :: (Options -> Options)
                      _hdItypeSyns :: (TypeSyns)
                      _hdIuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                      _hdIwrappers :: (Set Nonterminal)
                      _hdOallConstructors :: (Map Nonterminal (Set Constructor))
                      _hdOallFields :: (DataTypes)
                      _hdOallNonterminals :: (Set Nonterminal)
                      _hdOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _hdOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _hdOdefinedSets :: (DefinedSets)
                      _tlIattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _tlIblocks :: (Blocks)
                      _tlIcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                      _tlIcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                      _tlIcollectedNames :: (Set Name)
                      _tlIcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                      _tlIcollectedSetNames :: (Set Name)
                      _tlIcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                      _tlIdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _tlIderivings :: (Derivings)
                      _tlIerrors :: (Seq Error)
                      _tlIpragmas :: (Options -> Options)
                      _tlItypeSyns :: (TypeSyns)
                      _tlIuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                      _tlIwrappers :: (Set Nonterminal)
                      _tlOallConstructors :: (Map Nonterminal (Set Constructor))
                      _tlOallFields :: (DataTypes)
                      _tlOallNonterminals :: (Set Nonterminal)
                      _tlOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _tlOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _tlOdefinedSets :: (DefinedSets)
                      ( _hdIattrDecls,_hdIblocks,_hdIcollectedConstructorsMap,_hdIcollectedFields,_hdIcollectedNames,_hdIcollectedRules,_hdIcollectedSetNames,_hdIcollectedSigs,_hdIdefSets,_hdIderivings,_hdIerrors,_hdIpragmas,_hdItypeSyns,_hdIuseMap,_hdIwrappers) =
                          (hd_ (_hdOallConstructors) (_hdOallFields) (_hdOallNonterminals) (_hdOattrDecls) (_hdOdefSets) (_hdOdefinedSets))
                      ( _tlIattrDecls,_tlIblocks,_tlIcollectedConstructorsMap,_tlIcollectedFields,_tlIcollectedNames,_tlIcollectedRules,_tlIcollectedSetNames,_tlIcollectedSigs,_tlIdefSets,_tlIderivings,_tlIerrors,_tlIpragmas,_tlItypeSyns,_tlIuseMap,_tlIwrappers) =
                          (tl_ (_tlOallConstructors) (_tlOallFields) (_tlOallNonterminals) (_tlOattrDecls) (_tlOdefSets) (_tlOdefinedSets))
                      -- use rule
                      (_lhsOblocks@_) =
                          _hdIblocks `mapUnionWithPlusPlus` _tlIblocks
                      -- use rule
                      (_lhsOcollectedConstructorsMap@_) =
                          _hdIcollectedConstructorsMap `mapUnionWithSetUnion` _tlIcollectedConstructorsMap
                      -- use rule
                      (_lhsOcollectedFields@_) =
                          _hdIcollectedFields ++ _tlIcollectedFields
                      -- use rule
                      (_lhsOcollectedNames@_) =
                          _hdIcollectedNames `Set.union` _tlIcollectedNames
                      -- use rule
                      (_lhsOcollectedRules@_) =
                          _hdIcollectedRules ++ _tlIcollectedRules
                      -- use rule
                      (_lhsOcollectedSetNames@_) =
                          _hdIcollectedSetNames `Set.union` _tlIcollectedSetNames
                      -- use rule
                      (_lhsOcollectedSigs@_) =
                          _hdIcollectedSigs ++ _tlIcollectedSigs
                      -- use rule
                      (_lhsOderivings@_) =
                          _hdIderivings `mergeDerivings` _tlIderivings
                      -- use rule
                      (_lhsOerrors@_) =
                          _hdIerrors Seq.<> _tlIerrors
                      -- use rule
                      (_lhsOpragmas@_) =
                          _hdIpragmas . _tlIpragmas
                      -- use rule
                      (_lhsOtypeSyns@_) =
                          _hdItypeSyns ++ _tlItypeSyns
                      -- use rule
                      (_lhsOuseMap@_) =
                          _hdIuseMap `merge` _tlIuseMap
                      -- use rule
                      (_lhsOwrappers@_) =
                          _hdIwrappers `Set.union` _tlIwrappers
                      -- copy rule (up)
                      (_lhsOattrDecls@_) =
                          _tlIattrDecls
                      -- copy rule (up)
                      (_lhsOdefSets@_) =
                          _tlIdefSets
                      -- copy rule (down)
                      (_hdOallConstructors@_) =
                          _lhsIallConstructors
                      -- copy rule (down)
                      (_hdOallFields@_) =
                          _lhsIallFields
                      -- copy rule (down)
                      (_hdOallNonterminals@_) =
                          _lhsIallNonterminals
                      -- copy rule (down)
                      (_hdOattrDecls@_) =
                          _lhsIattrDecls
                      -- copy rule (down)
                      (_hdOdefSets@_) =
                          _lhsIdefSets
                      -- copy rule (down)
                      (_hdOdefinedSets@_) =
                          _lhsIdefinedSets
                      -- copy rule (down)
                      (_tlOallConstructors@_) =
                          _lhsIallConstructors
                      -- copy rule (down)
                      (_tlOallFields@_) =
                          _lhsIallFields
                      -- copy rule (down)
                      (_tlOallNonterminals@_) =
                          _lhsIallNonterminals
                      -- copy rule (chain)
                      (_tlOattrDecls@_) =
                          _hdIattrDecls
                      -- copy rule (chain)
                      (_tlOdefSets@_) =
                          _hdIdefSets
                      -- copy rule (down)
                      (_tlOdefinedSets@_) =
                          _lhsIdefinedSets
                  in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
sem_Elems_Nil :: (T_Elems)
sem_Elems_Nil  =
    (T_Elems (\ _lhsIallConstructors
                _lhsIallFields
                _lhsIallNonterminals
                _lhsIattrDecls
                _lhsIdefSets
                _lhsIdefinedSets ->
                  let _lhsOattrDecls :: (Map Nonterminal (Attributes, Attributes))
                      _lhsOblocks :: (Blocks)
                      _lhsOcollectedConstructorsMap :: (Map Nonterminal (Set Constructor))
                      _lhsOcollectedFields :: ([(Nonterminal, Constructor, FieldMap)])
                      _lhsOcollectedNames :: (Set Name)
                      _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                      _lhsOcollectedSetNames :: (Set Name)
                      _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                      _lhsOdefSets :: (Map Name (Set Nonterminal,Set Name))
                      _lhsOderivings :: (Derivings)
                      _lhsOerrors :: (Seq Error)
                      _lhsOpragmas :: (Options -> Options)
                      _lhsOtypeSyns :: (TypeSyns)
                      _lhsOuseMap :: (Map Nonterminal (Map Name (String,String,String)))
                      _lhsOwrappers :: (Set Nonterminal)
                      -- use rule
                      (_lhsOblocks@_) =
                          Map.empty
                      -- use rule
                      (_lhsOcollectedConstructorsMap@_) =
                          Map.empty
                      -- use rule
                      (_lhsOcollectedFields@_) =
                          []
                      -- use rule
                      (_lhsOcollectedNames@_) =
                          Set.empty
                      -- use rule
                      (_lhsOcollectedRules@_) =
                          []
                      -- use rule
                      (_lhsOcollectedSetNames@_) =
                          Set.empty
                      -- use rule
                      (_lhsOcollectedSigs@_) =
                          []
                      -- use rule
                      (_lhsOderivings@_) =
                          Map.empty
                      -- use rule
                      (_lhsOerrors@_) =
                          Seq.empty
                      -- use rule
                      (_lhsOpragmas@_) =
                          id
                      -- use rule
                      (_lhsOtypeSyns@_) =
                          []
                      -- use rule
                      (_lhsOuseMap@_) =
                          Map.empty
                      -- use rule
                      (_lhsOwrappers@_) =
                          Set.empty
                      -- copy rule (chain)
                      (_lhsOattrDecls@_) =
                          _lhsIattrDecls
                      -- copy rule (chain)
                      (_lhsOdefSets@_) =
                          _lhsIdefSets
                  in  ( _lhsOattrDecls,_lhsOblocks,_lhsOcollectedConstructorsMap,_lhsOcollectedFields,_lhsOcollectedNames,_lhsOcollectedRules,_lhsOcollectedSetNames,_lhsOcollectedSigs,_lhsOdefSets,_lhsOderivings,_lhsOerrors,_lhsOpragmas,_lhsOtypeSyns,_lhsOuseMap,_lhsOwrappers)))
-- NontSet -----------------------------------------------------
{-
   inherited attributes:
      allFields            : DataTypes
      allNonterminals      : Set Nonterminal
      definedSets          : DefinedSets

   chained attributes:

   synthesised attributes:
      collectedNames       : Set Name
      errors               : Seq Error
      nontSet              : Set Nonterminal

-}
{-
   local variables for NontSet.All:

-}
{-
   local variables for NontSet.Difference:

-}
{-
   local variables for NontSet.Intersect:

-}
{-
   local variables for NontSet.NamedSet:
      nontSet
      errors

-}
{-
   local variables for NontSet.Path:

-}
{-
   local variables for NontSet.Union:

-}
-- semantic domain
newtype T_NontSet = T_NontSet ((DataTypes) ->
                               (Set Nonterminal) ->
                               (DefinedSets) ->
                               ( (Set Name),(Seq Error),(Set Nonterminal)))
-- cata
sem_NontSet :: (NontSet) ->
               (T_NontSet)
sem_NontSet ((All )) =
    (sem_NontSet_All )
sem_NontSet ((Difference (_set1) (_set2))) =
    (sem_NontSet_Difference ((sem_NontSet (_set1))) ((sem_NontSet (_set2))))
sem_NontSet ((Intersect (_set1) (_set2))) =
    (sem_NontSet_Intersect ((sem_NontSet (_set1))) ((sem_NontSet (_set2))))
sem_NontSet ((NamedSet (_name))) =
    (sem_NontSet_NamedSet (_name))
sem_NontSet ((Path (_from) (_to))) =
    (sem_NontSet_Path (_from) (_to))
sem_NontSet ((Union (_set1) (_set2))) =
    (sem_NontSet_Union ((sem_NontSet (_set1))) ((sem_NontSet (_set2))))
data Inh_NontSet = Inh_NontSet {allFields_Inh_NontSet :: DataTypes,allNonterminals_Inh_NontSet :: Set Nonterminal,definedSets_Inh_NontSet :: DefinedSets}
data Syn_NontSet = Syn_NontSet {collectedNames_Syn_NontSet :: Set Name,errors_Syn_NontSet :: Seq Error,nontSet_Syn_NontSet :: Set Nonterminal}
wrap_NontSet :: (T_NontSet) ->
                (Inh_NontSet) ->
                (Syn_NontSet)
wrap_NontSet ((T_NontSet (sem))) ((Inh_NontSet (i1) (i2) (i3))) =
    let ( s1,s2,s3) =
            (sem (i1) (i2) (i3))
    in  (Syn_NontSet (s1) (s2) (s3))
sem_NontSet_All :: (T_NontSet)
sem_NontSet_All  =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    let _lhsOcollectedNames :: (Set Name)
                        _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        -- "Transform.ag"(line 406, column 16)
                        (_lhsOnontSet@_) =
                            _lhsIallNonterminals
                        -- use rule
                        (_lhsOcollectedNames@_) =
                            Set.empty
                        -- use rule
                        (_lhsOerrors@_) =
                            Seq.empty
                    in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet)))
sem_NontSet_Difference :: (T_NontSet) ->
                          (T_NontSet) ->
                          (T_NontSet)
sem_NontSet_Difference ((T_NontSet (set1_))) ((T_NontSet (set2_))) =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    let _lhsOcollectedNames :: (Set Name)
                        _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _set1IcollectedNames :: (Set Name)
                        _set1Ierrors :: (Seq Error)
                        _set1InontSet :: (Set Nonterminal)
                        _set1OallFields :: (DataTypes)
                        _set1OallNonterminals :: (Set Nonterminal)
                        _set1OdefinedSets :: (DefinedSets)
                        _set2IcollectedNames :: (Set Name)
                        _set2Ierrors :: (Seq Error)
                        _set2InontSet :: (Set Nonterminal)
                        _set2OallFields :: (DataTypes)
                        _set2OallNonterminals :: (Set Nonterminal)
                        _set2OdefinedSets :: (DefinedSets)
                        ( _set1IcollectedNames,_set1Ierrors,_set1InontSet) =
                            (set1_ (_set1OallFields) (_set1OallNonterminals) (_set1OdefinedSets))
                        ( _set2IcollectedNames,_set2Ierrors,_set2InontSet) =
                            (set2_ (_set2OallFields) (_set2OallNonterminals) (_set2OdefinedSets))
                        -- "Transform.ag"(line 412, column 16)
                        (_lhsOnontSet@_) =
                            Set.difference    _set1InontSet _set2InontSet
                        -- use rule
                        (_lhsOcollectedNames@_) =
                            _set1IcollectedNames `Set.union` _set2IcollectedNames
                        -- use rule
                        (_lhsOerrors@_) =
                            _set1Ierrors Seq.<> _set2Ierrors
                        -- copy rule (down)
                        (_set1OallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_set1OallNonterminals@_) =
                            _lhsIallNonterminals
                        -- copy rule (down)
                        (_set1OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set2OallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_set2OallNonterminals@_) =
                            _lhsIallNonterminals
                        -- copy rule (down)
                        (_set2OdefinedSets@_) =
                            _lhsIdefinedSets
                    in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet)))
sem_NontSet_Intersect :: (T_NontSet) ->
                         (T_NontSet) ->
                         (T_NontSet)
sem_NontSet_Intersect ((T_NontSet (set1_))) ((T_NontSet (set2_))) =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    let _lhsOcollectedNames :: (Set Name)
                        _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _set1IcollectedNames :: (Set Name)
                        _set1Ierrors :: (Seq Error)
                        _set1InontSet :: (Set Nonterminal)
                        _set1OallFields :: (DataTypes)
                        _set1OallNonterminals :: (Set Nonterminal)
                        _set1OdefinedSets :: (DefinedSets)
                        _set2IcollectedNames :: (Set Name)
                        _set2Ierrors :: (Seq Error)
                        _set2InontSet :: (Set Nonterminal)
                        _set2OallFields :: (DataTypes)
                        _set2OallNonterminals :: (Set Nonterminal)
                        _set2OdefinedSets :: (DefinedSets)
                        ( _set1IcollectedNames,_set1Ierrors,_set1InontSet) =
                            (set1_ (_set1OallFields) (_set1OallNonterminals) (_set1OdefinedSets))
                        ( _set2IcollectedNames,_set2Ierrors,_set2InontSet) =
                            (set2_ (_set2OallFields) (_set2OallNonterminals) (_set2OdefinedSets))
                        -- "Transform.ag"(line 411, column 16)
                        (_lhsOnontSet@_) =
                            Set.intersection  _set1InontSet _set2InontSet
                        -- use rule
                        (_lhsOcollectedNames@_) =
                            _set1IcollectedNames `Set.union` _set2IcollectedNames
                        -- use rule
                        (_lhsOerrors@_) =
                            _set1Ierrors Seq.<> _set2Ierrors
                        -- copy rule (down)
                        (_set1OallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_set1OallNonterminals@_) =
                            _lhsIallNonterminals
                        -- copy rule (down)
                        (_set1OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set2OallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_set2OallNonterminals@_) =
                            _lhsIallNonterminals
                        -- copy rule (down)
                        (_set2OdefinedSets@_) =
                            _lhsIdefinedSets
                    in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet)))
sem_NontSet_NamedSet :: (Nonterminal) ->
                        (T_NontSet)
sem_NontSet_NamedSet (name_) =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    let _lhsOcollectedNames :: (Set Name)
                        _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        -- "Transform.ag"(line 310, column 14)
                        (_lhsOcollectedNames@_) =
                            Set.single name_
                        -- "Transform.ag"(line 407, column 20)
                        ((_nontSet@_,_errors@_)) =
                            case Map.lookup name_ _lhsIdefinedSets of
                                         Nothing  -> (Set.empty, Seq.single (UndefNont name_))
                                         Just set -> (set, Seq.empty)
                        -- use rule
                        (_lhsOerrors@_) =
                            _errors
                        -- copy rule (from local)
                        (_lhsOnontSet@_) =
                            _nontSet
                    in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet)))
sem_NontSet_Path :: (Nonterminal) ->
                    (Nonterminal) ->
                    (T_NontSet)
sem_NontSet_Path (from_) (to_) =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    let _lhsOcollectedNames :: (Set Name)
                        _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        -- "Transform.ag"(line 415, column 16)
                        (_lhsOerrors@_) =
                            let check name | Set.member name _lhsIallNonterminals
                                                       = Seq.empty
                                           | otherwise = Seq.single (UndefNont name)
                            in check from_ <> check to_
                        -- "Transform.ag"(line 413, column 16)
                        (_lhsOnontSet@_) =
                            let table = flattenDatas _lhsIallFields
                            in path table from_ to_
                        -- use rule
                        (_lhsOcollectedNames@_) =
                            Set.empty
                    in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet)))
sem_NontSet_Union :: (T_NontSet) ->
                     (T_NontSet) ->
                     (T_NontSet)
sem_NontSet_Union ((T_NontSet (set1_))) ((T_NontSet (set2_))) =
    (T_NontSet (\ _lhsIallFields
                  _lhsIallNonterminals
                  _lhsIdefinedSets ->
                    let _lhsOcollectedNames :: (Set Name)
                        _lhsOerrors :: (Seq Error)
                        _lhsOnontSet :: (Set Nonterminal)
                        _set1IcollectedNames :: (Set Name)
                        _set1Ierrors :: (Seq Error)
                        _set1InontSet :: (Set Nonterminal)
                        _set1OallFields :: (DataTypes)
                        _set1OallNonterminals :: (Set Nonterminal)
                        _set1OdefinedSets :: (DefinedSets)
                        _set2IcollectedNames :: (Set Name)
                        _set2Ierrors :: (Seq Error)
                        _set2InontSet :: (Set Nonterminal)
                        _set2OallFields :: (DataTypes)
                        _set2OallNonterminals :: (Set Nonterminal)
                        _set2OdefinedSets :: (DefinedSets)
                        ( _set1IcollectedNames,_set1Ierrors,_set1InontSet) =
                            (set1_ (_set1OallFields) (_set1OallNonterminals) (_set1OdefinedSets))
                        ( _set2IcollectedNames,_set2Ierrors,_set2InontSet) =
                            (set2_ (_set2OallFields) (_set2OallNonterminals) (_set2OdefinedSets))
                        -- "Transform.ag"(line 410, column 16)
                        (_lhsOnontSet@_) =
                            Set.union         _set1InontSet _set2InontSet
                        -- use rule
                        (_lhsOcollectedNames@_) =
                            _set1IcollectedNames `Set.union` _set2IcollectedNames
                        -- use rule
                        (_lhsOerrors@_) =
                            _set1Ierrors Seq.<> _set2Ierrors
                        -- copy rule (down)
                        (_set1OallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_set1OallNonterminals@_) =
                            _lhsIallNonterminals
                        -- copy rule (down)
                        (_set1OdefinedSets@_) =
                            _lhsIdefinedSets
                        -- copy rule (down)
                        (_set2OallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_set2OallNonterminals@_) =
                            _lhsIallNonterminals
                        -- copy rule (down)
                        (_set2OdefinedSets@_) =
                            _lhsIdefinedSets
                    in  ( _lhsOcollectedNames,_lhsOerrors,_lhsOnontSet)))
-- Pattern -----------------------------------------------------
{-
   inherited attributes:

   chained attributes:

   synthesised attributes:
      copy                 : SELF
      definedAttrs         : [AttrName]
      patunder             : [AttrName]->Pattern
      stpos                : Pos

-}
{-
   local variables for Pattern.Alias:
      copy

-}
{-
   local variables for Pattern.Constr:
      copy

-}
{-
   local variables for Pattern.Product:
      copy

-}
{-
   local variables for Pattern.Underscore:
      copy

-}
-- semantic domain
newtype T_Pattern = T_Pattern (( (Pattern),([AttrName]),([AttrName]->Pattern),(Pos)))
-- cata
sem_Pattern :: (Pattern) ->
               (T_Pattern)
sem_Pattern ((Alias (_field) (_attr) (_pat))) =
    (sem_Pattern_Alias (_field) (_attr) ((sem_Pattern (_pat))))
sem_Pattern ((Constr (_name) (_pats))) =
    (sem_Pattern_Constr (_name) ((sem_Patterns (_pats))))
sem_Pattern ((Product (_pos) (_pats))) =
    (sem_Pattern_Product (_pos) ((sem_Patterns (_pats))))
sem_Pattern ((Underscore (_pos))) =
    (sem_Pattern_Underscore (_pos))
data Inh_Pattern = Inh_Pattern {}
data Syn_Pattern = Syn_Pattern {copy_Syn_Pattern :: Pattern,definedAttrs_Syn_Pattern :: [AttrName],patunder_Syn_Pattern :: [AttrName]->Pattern,stpos_Syn_Pattern :: Pos}
wrap_Pattern :: (T_Pattern) ->
                (Inh_Pattern) ->
                (Syn_Pattern)
wrap_Pattern ((T_Pattern (sem))) ((Inh_Pattern )) =
    let ( s1,s2,s3,s4) =
            (sem )
    in  (Syn_Pattern (s1) (s2) (s3) (s4))
sem_Pattern_Alias :: (Name) ->
                     (Name) ->
                     (T_Pattern) ->
                     (T_Pattern)
sem_Pattern_Alias (field_) (attr_) ((T_Pattern (pat_))) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOstpos :: (Pos)
                    _patIcopy :: (Pattern)
                    _patIdefinedAttrs :: ([AttrName])
                    _patIpatunder :: ([AttrName]->Pattern)
                    _patIstpos :: (Pos)
                    ( _patIcopy,_patIdefinedAttrs,_patIpatunder,_patIstpos) =
                        (pat_ )
                    -- "Transform.ag"(line 608, column 11)
                    (_lhsOpatunder@_) =
                        \us -> if ((field_,attr_) `elem` us) then Underscore noPos else _copy
                    -- "Transform.ag"(line 607, column 11)
                    (_lhsOdefinedAttrs@_) =
                        (field_, attr_) : _patIdefinedAttrs
                    -- "Transform.ag"(line 622, column 16)
                    (_lhsOstpos@_) =
                        getPos field_
                    -- self rule
                    (_copy@_) =
                        Alias field_ attr_ _patIcopy
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOpatunder,_lhsOstpos)))
sem_Pattern_Constr :: (Constructor) ->
                      (T_Patterns) ->
                      (T_Pattern)
sem_Pattern_Constr (name_) ((T_Patterns (pats_))) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOstpos :: (Pos)
                    _patsIcopy :: (Patterns)
                    _patsIdefinedAttrs :: ([AttrName])
                    _patsIpatunder :: ([AttrName]->Patterns)
                    ( _patsIcopy,_patsIdefinedAttrs,_patsIpatunder) =
                        (pats_ )
                    -- "Transform.ag"(line 610, column 12)
                    (_lhsOpatunder@_) =
                        \us -> Constr name_ (_patsIpatunder us)
                    -- "Transform.ag"(line 620, column 16)
                    (_lhsOstpos@_) =
                        getPos name_
                    -- use rule
                    (_lhsOdefinedAttrs@_) =
                        _patsIdefinedAttrs
                    -- self rule
                    (_copy@_) =
                        Constr name_ _patsIcopy
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOpatunder,_lhsOstpos)))
sem_Pattern_Product :: (Pos) ->
                       (T_Patterns) ->
                       (T_Pattern)
sem_Pattern_Product (pos_) ((T_Patterns (pats_))) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOstpos :: (Pos)
                    _patsIcopy :: (Patterns)
                    _patsIdefinedAttrs :: ([AttrName])
                    _patsIpatunder :: ([AttrName]->Patterns)
                    ( _patsIcopy,_patsIdefinedAttrs,_patsIpatunder) =
                        (pats_ )
                    -- "Transform.ag"(line 611, column 13)
                    (_lhsOpatunder@_) =
                        \us -> Product pos_ (_patsIpatunder us)
                    -- "Transform.ag"(line 621, column 16)
                    (_lhsOstpos@_) =
                        pos_
                    -- use rule
                    (_lhsOdefinedAttrs@_) =
                        _patsIdefinedAttrs
                    -- self rule
                    (_copy@_) =
                        Product pos_ _patsIcopy
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOpatunder,_lhsOstpos)))
sem_Pattern_Underscore :: (Pos) ->
                          (T_Pattern)
sem_Pattern_Underscore (pos_) =
    (T_Pattern (let _lhsOcopy :: (Pattern)
                    _lhsOdefinedAttrs :: ([AttrName])
                    _lhsOpatunder :: ([AttrName]->Pattern)
                    _lhsOstpos :: (Pos)
                    -- "Transform.ag"(line 609, column 16)
                    (_lhsOpatunder@_) =
                        \us -> _copy
                    -- "Transform.ag"(line 623, column 16)
                    (_lhsOstpos@_) =
                        pos_
                    -- use rule
                    (_lhsOdefinedAttrs@_) =
                        []
                    -- self rule
                    (_copy@_) =
                        Underscore pos_
                    -- self rule
                    (_lhsOcopy@_) =
                        _copy
                in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOpatunder,_lhsOstpos)))
-- Patterns ----------------------------------------------------
{-
   inherited attributes:

   chained attributes:

   synthesised attributes:
      copy                 : SELF
      definedAttrs         : [AttrName]
      patunder             : [AttrName]->Patterns

-}
{-
   local variables for Patterns.Cons:
      copy

-}
{-
   local variables for Patterns.Nil:
      copy

-}
-- semantic domain
newtype T_Patterns = T_Patterns (( (Patterns),([AttrName]),([AttrName]->Patterns)))
-- cata
sem_Patterns :: (Patterns) ->
                (T_Patterns)
sem_Patterns (list) =
    (Prelude.foldr (sem_Patterns_Cons) (sem_Patterns_Nil) ((Prelude.map sem_Pattern list)))
data Inh_Patterns = Inh_Patterns {}
data Syn_Patterns = Syn_Patterns {copy_Syn_Patterns :: Patterns,definedAttrs_Syn_Patterns :: [AttrName],patunder_Syn_Patterns :: [AttrName]->Patterns}
wrap_Patterns :: (T_Patterns) ->
                 (Inh_Patterns) ->
                 (Syn_Patterns)
wrap_Patterns ((T_Patterns (sem))) ((Inh_Patterns )) =
    let ( s1,s2,s3) =
            (sem )
    in  (Syn_Patterns (s1) (s2) (s3))
sem_Patterns_Cons :: (T_Pattern) ->
                     (T_Patterns) ->
                     (T_Patterns)
sem_Patterns_Cons ((T_Pattern (hd_))) ((T_Patterns (tl_))) =
    (T_Patterns (let _lhsOcopy :: (Patterns)
                     _lhsOdefinedAttrs :: ([AttrName])
                     _lhsOpatunder :: ([AttrName]->Patterns)
                     _hdIcopy :: (Pattern)
                     _hdIdefinedAttrs :: ([AttrName])
                     _hdIpatunder :: ([AttrName]->Pattern)
                     _hdIstpos :: (Pos)
                     _tlIcopy :: (Patterns)
                     _tlIdefinedAttrs :: ([AttrName])
                     _tlIpatunder :: ([AttrName]->Patterns)
                     ( _hdIcopy,_hdIdefinedAttrs,_hdIpatunder,_hdIstpos) =
                         (hd_ )
                     ( _tlIcopy,_tlIdefinedAttrs,_tlIpatunder) =
                         (tl_ )
                     -- "Transform.ag"(line 615, column 10)
                     (_lhsOpatunder@_) =
                         \us -> (_hdIpatunder us) : (_tlIpatunder us)
                     -- use rule
                     (_lhsOdefinedAttrs@_) =
                         _hdIdefinedAttrs ++ _tlIdefinedAttrs
                     -- self rule
                     (_copy@_) =
                         (:) _hdIcopy _tlIcopy
                     -- self rule
                     (_lhsOcopy@_) =
                         _copy
                 in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOpatunder)))
sem_Patterns_Nil :: (T_Patterns)
sem_Patterns_Nil  =
    (T_Patterns (let _lhsOcopy :: (Patterns)
                     _lhsOdefinedAttrs :: ([AttrName])
                     _lhsOpatunder :: ([AttrName]->Patterns)
                     -- "Transform.ag"(line 614, column 9)
                     (_lhsOpatunder@_) =
                         \us ->  []
                     -- use rule
                     (_lhsOdefinedAttrs@_) =
                         []
                     -- self rule
                     (_copy@_) =
                         []
                     -- self rule
                     (_lhsOcopy@_) =
                         _copy
                 in  ( _lhsOcopy,_lhsOdefinedAttrs,_lhsOpatunder)))
-- SemAlt ------------------------------------------------------
{-
   inherited attributes:
      allFields            : DataTypes
      nts                  : Set Nonterminal

   chained attributes:

   synthesised attributes:
      collectedRules       : [ (Nonterminal, Constructor, RuleInfo)]
      collectedSigs        : [ (Nonterminal, Constructor, SigInfo) ]
      errors               : Seq Error

-}
{-
   local variables for SemAlt.SemAlt:
      coninfo

-}
-- semantic domain
newtype T_SemAlt = T_SemAlt ((DataTypes) ->
                             (Set Nonterminal) ->
                             ( ([ (Nonterminal, Constructor, RuleInfo)]),([ (Nonterminal, Constructor, SigInfo) ]),(Seq Error)))
-- cata
sem_SemAlt :: (SemAlt) ->
              (T_SemAlt)
sem_SemAlt ((SemAlt (_pos) (_constructorSet) (_rules))) =
    (sem_SemAlt_SemAlt (_pos) ((sem_ConstructorSet (_constructorSet))) ((sem_SemDefs (_rules))))
data Inh_SemAlt = Inh_SemAlt {allFields_Inh_SemAlt :: DataTypes,nts_Inh_SemAlt :: Set Nonterminal}
data Syn_SemAlt = Syn_SemAlt {collectedRules_Syn_SemAlt :: [ (Nonterminal, Constructor, RuleInfo)],collectedSigs_Syn_SemAlt :: [ (Nonterminal, Constructor, SigInfo) ],errors_Syn_SemAlt :: Seq Error}
wrap_SemAlt :: (T_SemAlt) ->
               (Inh_SemAlt) ->
               (Syn_SemAlt)
wrap_SemAlt ((T_SemAlt (sem))) ((Inh_SemAlt (i1) (i2))) =
    let ( s1,s2,s3) =
            (sem (i1) (i2))
    in  (Syn_SemAlt (s1) (s2) (s3))
sem_SemAlt_SemAlt :: (Pos) ->
                     (T_ConstructorSet) ->
                     (T_SemDefs) ->
                     (T_SemAlt)
sem_SemAlt_SemAlt (pos_) ((T_ConstructorSet (constructorSet_))) ((T_SemDefs (rules_))) =
    (T_SemAlt (\ _lhsIallFields
                 _lhsInts ->
                   let _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                       _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                       _lhsOerrors :: (Seq Error)
                       _constructorSetIcollectedConstructorNames :: (Set Constructor)
                       _constructorSetIconstructors :: ((Set Constructor->Set Constructor))
                       _constructorSetIerrors :: (Seq Error)
                       _rulesIruleInfos :: ([RuleInfo])
                       _rulesIsigInfos :: ([SigInfo] )
                       ( _constructorSetIcollectedConstructorNames,_constructorSetIconstructors,_constructorSetIerrors) =
                           (constructorSet_ )
                       ( _rulesIruleInfos,_rulesIsigInfos) =
                           (rules_ )
                       -- "Transform.ag"(line 587, column 12)
                       (_lhsOcollectedSigs@_) =
                           [ (nt,con,ts)
                           | (nt, conset, _) <- _coninfo
                           , con <- Set.toList conset
                           , ts <- _rulesIsigInfos
                           ]
                       -- "Transform.ag"(line 581, column 12)
                       (_lhsOcollectedRules@_) =
                           [ (nt,con,r)
                           | (nt, conset, _) <- _coninfo
                           , con <- Set.toList conset
                           , r <- _rulesIruleInfos
                           ]
                       -- "Transform.ag"(line 576, column 12)
                       (_lhsOerrors@_) =
                           Seq.fromList
                              [ UndefAlt nt con
                              | (nt, conset, conkeys) <- _coninfo
                              , con <- Set.toList (Set.difference conset conkeys)
                              ]
                       -- "Transform.ag"(line 569, column 12)
                       (_coninfo@_) =
                           [ (nt, conset, conkeys)
                           | nt  <- Set.toList _lhsInts
                           , let conmap = Map.findWithDefault Map.empty nt _lhsIallFields
                           , let conkeys = Set.fromList (Map.keys conmap)
                           , let conset  = _constructorSetIconstructors conkeys
                           ]
                   in  ( _lhsOcollectedRules,_lhsOcollectedSigs,_lhsOerrors)))
-- SemAlts -----------------------------------------------------
{-
   inherited attributes:
      allFields            : DataTypes
      nts                  : Set Nonterminal

   chained attributes:

   synthesised attributes:
      collectedRules       : [ (Nonterminal, Constructor, RuleInfo)]
      collectedSigs        : [ (Nonterminal, Constructor, SigInfo) ]
      errors               : Seq Error

-}
{-
   local variables for SemAlts.Cons:

-}
{-
   local variables for SemAlts.Nil:

-}
-- semantic domain
newtype T_SemAlts = T_SemAlts ((DataTypes) ->
                               (Set Nonterminal) ->
                               ( ([ (Nonterminal, Constructor, RuleInfo)]),([ (Nonterminal, Constructor, SigInfo) ]),(Seq Error)))
-- cata
sem_SemAlts :: (SemAlts) ->
               (T_SemAlts)
sem_SemAlts (list) =
    (Prelude.foldr (sem_SemAlts_Cons) (sem_SemAlts_Nil) ((Prelude.map sem_SemAlt list)))
data Inh_SemAlts = Inh_SemAlts {allFields_Inh_SemAlts :: DataTypes,nts_Inh_SemAlts :: Set Nonterminal}
data Syn_SemAlts = Syn_SemAlts {collectedRules_Syn_SemAlts :: [ (Nonterminal, Constructor, RuleInfo)],collectedSigs_Syn_SemAlts :: [ (Nonterminal, Constructor, SigInfo) ],errors_Syn_SemAlts :: Seq Error}
wrap_SemAlts :: (T_SemAlts) ->
                (Inh_SemAlts) ->
                (Syn_SemAlts)
wrap_SemAlts ((T_SemAlts (sem))) ((Inh_SemAlts (i1) (i2))) =
    let ( s1,s2,s3) =
            (sem (i1) (i2))
    in  (Syn_SemAlts (s1) (s2) (s3))
sem_SemAlts_Cons :: (T_SemAlt) ->
                    (T_SemAlts) ->
                    (T_SemAlts)
sem_SemAlts_Cons ((T_SemAlt (hd_))) ((T_SemAlts (tl_))) =
    (T_SemAlts (\ _lhsIallFields
                  _lhsInts ->
                    let _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                        _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                        _lhsOerrors :: (Seq Error)
                        _hdIcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                        _hdIcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                        _hdIerrors :: (Seq Error)
                        _hdOallFields :: (DataTypes)
                        _hdOnts :: (Set Nonterminal)
                        _tlIcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                        _tlIcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                        _tlIerrors :: (Seq Error)
                        _tlOallFields :: (DataTypes)
                        _tlOnts :: (Set Nonterminal)
                        ( _hdIcollectedRules,_hdIcollectedSigs,_hdIerrors) =
                            (hd_ (_hdOallFields) (_hdOnts))
                        ( _tlIcollectedRules,_tlIcollectedSigs,_tlIerrors) =
                            (tl_ (_tlOallFields) (_tlOnts))
                        -- use rule
                        (_lhsOcollectedRules@_) =
                            _hdIcollectedRules ++ _tlIcollectedRules
                        -- use rule
                        (_lhsOcollectedSigs@_) =
                            _hdIcollectedSigs ++ _tlIcollectedSigs
                        -- use rule
                        (_lhsOerrors@_) =
                            _hdIerrors Seq.<> _tlIerrors
                        -- copy rule (down)
                        (_hdOallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_hdOnts@_) =
                            _lhsInts
                        -- copy rule (down)
                        (_tlOallFields@_) =
                            _lhsIallFields
                        -- copy rule (down)
                        (_tlOnts@_) =
                            _lhsInts
                    in  ( _lhsOcollectedRules,_lhsOcollectedSigs,_lhsOerrors)))
sem_SemAlts_Nil :: (T_SemAlts)
sem_SemAlts_Nil  =
    (T_SemAlts (\ _lhsIallFields
                  _lhsInts ->
                    let _lhsOcollectedRules :: ([ (Nonterminal, Constructor, RuleInfo)])
                        _lhsOcollectedSigs :: ([ (Nonterminal, Constructor, SigInfo) ])
                        _lhsOerrors :: (Seq Error)
                        -- use rule
                        (_lhsOcollectedRules@_) =
                            []
                        -- use rule
                        (_lhsOcollectedSigs@_) =
                            []
                        -- use rule
                        (_lhsOerrors@_) =
                            Seq.empty
                    in  ( _lhsOcollectedRules,_lhsOcollectedSigs,_lhsOerrors)))
-- SemDef ------------------------------------------------------
{-
   inherited attributes:

   chained attributes:

   synthesised attributes:
      ruleInfos            : [RuleInfo]
      sigInfos             : [SigInfo] 

-}
{-
   local variables for SemDef.Def:

-}
{-
   local variables for SemDef.TypeDef:

-}
-- semantic domain
newtype T_SemDef = T_SemDef (( ([RuleInfo]),([SigInfo] )))
-- cata
sem_SemDef :: (SemDef) ->
              (T_SemDef)
sem_SemDef ((Def (_pattern) (_rhs) (_owrt))) =
    (sem_SemDef_Def ((sem_Pattern (_pattern))) (_rhs) (_owrt))
sem_SemDef ((TypeDef (_ident) (_tp))) =
    (sem_SemDef_TypeDef (_ident) (_tp))
data Inh_SemDef = Inh_SemDef {}
data Syn_SemDef = Syn_SemDef {ruleInfos_Syn_SemDef :: [RuleInfo],sigInfos_Syn_SemDef :: [SigInfo] }
wrap_SemDef :: (T_SemDef) ->
               (Inh_SemDef) ->
               (Syn_SemDef)
wrap_SemDef ((T_SemDef (sem))) ((Inh_SemDef )) =
    let ( s1,s2) =
            (sem )
    in  (Syn_SemDef (s1) (s2))
sem_SemDef_Def :: (T_Pattern) ->
                  (Expression) ->
                  (Bool) ->
                  (T_SemDef)
sem_SemDef_Def ((T_Pattern (pattern_))) (rhs_) (owrt_) =
    (T_SemDef (let _lhsOruleInfos :: ([RuleInfo])
                   _lhsOsigInfos :: ([SigInfo] )
                   _patternIcopy :: (Pattern)
                   _patternIdefinedAttrs :: ([AttrName])
                   _patternIpatunder :: ([AttrName]->Pattern)
                   _patternIstpos :: (Pos)
                   ( _patternIcopy,_patternIdefinedAttrs,_patternIpatunder,_patternIstpos) =
                       (pattern_ )
                   -- "Transform.ag"(line 596, column 10)
                   (_lhsOruleInfos@_) =
                       [ (_patternIpatunder, rhs_, _patternIdefinedAttrs, owrt_, show _patternIstpos) ]
                   -- use rule
                   (_lhsOsigInfos@_) =
                       []
               in  ( _lhsOruleInfos,_lhsOsigInfos)))
sem_SemDef_TypeDef :: (Identifier) ->
                      (Type) ->
                      (T_SemDef)
sem_SemDef_TypeDef (ident_) (tp_) =
    (T_SemDef (let _lhsOruleInfos :: ([RuleInfo])
                   _lhsOsigInfos :: ([SigInfo] )
                   -- "Transform.ag"(line 599, column 14)
                   (_lhsOsigInfos@_) =
                       [ (ident_, tp_) ]
                   -- use rule
                   (_lhsOruleInfos@_) =
                       []
               in  ( _lhsOruleInfos,_lhsOsigInfos)))
-- SemDefs -----------------------------------------------------
{-
   inherited attributes:

   chained attributes:

   synthesised attributes:
      ruleInfos            : [RuleInfo]
      sigInfos             : [SigInfo] 

-}
{-
   local variables for SemDefs.Cons:

-}
{-
   local variables for SemDefs.Nil:

-}
-- semantic domain
newtype T_SemDefs = T_SemDefs (( ([RuleInfo]),([SigInfo] )))
-- cata
sem_SemDefs :: (SemDefs) ->
               (T_SemDefs)
sem_SemDefs (list) =
    (Prelude.foldr (sem_SemDefs_Cons) (sem_SemDefs_Nil) ((Prelude.map sem_SemDef list)))
data Inh_SemDefs = Inh_SemDefs {}
data Syn_SemDefs = Syn_SemDefs {ruleInfos_Syn_SemDefs :: [RuleInfo],sigInfos_Syn_SemDefs :: [SigInfo] }
wrap_SemDefs :: (T_SemDefs) ->
                (Inh_SemDefs) ->
                (Syn_SemDefs)
wrap_SemDefs ((T_SemDefs (sem))) ((Inh_SemDefs )) =
    let ( s1,s2) =
            (sem )
    in  (Syn_SemDefs (s1) (s2))
sem_SemDefs_Cons :: (T_SemDef) ->
                    (T_SemDefs) ->
                    (T_SemDefs)
sem_SemDefs_Cons ((T_SemDef (hd_))) ((T_SemDefs (tl_))) =
    (T_SemDefs (let _lhsOruleInfos :: ([RuleInfo])
                    _lhsOsigInfos :: ([SigInfo] )
                    _hdIruleInfos :: ([RuleInfo])
                    _hdIsigInfos :: ([SigInfo] )
                    _tlIruleInfos :: ([RuleInfo])
                    _tlIsigInfos :: ([SigInfo] )
                    ( _hdIruleInfos,_hdIsigInfos) =
                        (hd_ )
                    ( _tlIruleInfos,_tlIsigInfos) =
                        (tl_ )
                    -- use rule
                    (_lhsOruleInfos@_) =
                        _hdIruleInfos ++ _tlIruleInfos
                    -- use rule
                    (_lhsOsigInfos@_) =
                        _hdIsigInfos ++ _tlIsigInfos
                in  ( _lhsOruleInfos,_lhsOsigInfos)))
sem_SemDefs_Nil :: (T_SemDefs)
sem_SemDefs_Nil  =
    (T_SemDefs (let _lhsOruleInfos :: ([RuleInfo])
                    _lhsOsigInfos :: ([SigInfo] )
                    -- use rule
                    (_lhsOruleInfos@_) =
                        []
                    -- use rule
                    (_lhsOsigInfos@_) =
                        []
                in  ( _lhsOruleInfos,_lhsOsigInfos)))


