/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#include "toolOptions.h"

#include <visu_tools.h>

struct Option_stuct
{
  /* The name of the option, copied on creation and
     used as key in a table of options. */
  gchar *name;

  /* A short description of the option. */
  gchar *label;

  /* The kind of the option. */
  OptionTypes type;

  /* TRUE if the value has been set. */
  gboolean set;

  /* Value. */
  gboolean valueBool;
  int      valueInt;
  float    valueFloat;
};


Option* toolOptionsNew_optionBoolean(const gchar *name, const gchar *label)
{
  Option *option;

  g_return_val_if_fail(name && name[0] && label, (Option*)0);

  option = g_malloc(sizeof(Option));
  option->name = g_strdup(name);
  option->label = g_strdup(label);
  option->set = FALSE;
  option->type = OPTION_BOOLEAN;
  return option;
}
Option* toolOptionsNew_optionInteger(const gchar *name, const gchar *label)
{
  Option *option;

  g_return_val_if_fail(name && name[0] && label, (Option*)0);

  option = g_malloc(sizeof(Option));
  option->name = g_strdup(name);
  option->label = g_strdup(label);
  option->set = FALSE;
  option->type = OPTION_INTEGER;
  return option;
}
Option* toolOptionsNew_optionFloat(const gchar *name, const gchar *label)
{
  Option *option;

  g_return_val_if_fail(name && name[0] && label, (Option*)0);

  option = g_malloc(sizeof(Option));
  option->name = g_strdup(name);
  option->label = g_strdup(label);
  option->set = FALSE;
  option->type = OPTION_FLOAT;
  return option;
}

void toolOptionsFree_option(gpointer data)
{
  Option *option;

  g_return_if_fail(data);
  option = (Option*)data;

  g_free(option->name);
  g_free(option->label);
  g_free(option);
}

gchar* toolOptionsGet_name(Option *option)
{
  g_return_val_if_fail(option, (gchar*)0);

  return option->name;
}
gchar* toolOptionsGet_label(Option *option)
{
  g_return_val_if_fail(option, (gchar*)0);

  return option->label;
}
OptionTypes toolOptionsGet_type(Option *option)
{
  g_return_val_if_fail(option, 0);

  return option->type;
}

void toolOptionsSet_valueBoolean(Option *option, gboolean value)
{
  g_return_if_fail(option && option->type == OPTION_BOOLEAN);

  option->set = TRUE;
  option->valueBool = value;
}
void toolOptionsSet_valueInteger(Option *option, int value)
{
  g_return_if_fail(option && option->type == OPTION_INTEGER);

  option->set = TRUE;
  option->valueInt = value;
}
void toolOptionsSet_valueFloat  (Option *option, float value)
{
  g_return_if_fail(option && option->type == OPTION_FLOAT);

  option->set = TRUE;
  option->valueFloat = value;
}

gboolean toolOptionsGet_valueBoolean(Option *option, gboolean *value)
{
  g_return_val_if_fail(option && option->type == OPTION_BOOLEAN && value, FALSE);

  if (!option->set)
    return FALSE;
  *value = option->valueBool;
  return TRUE;
}
gboolean toolOptionsGet_valueInteger(Option *option, int *value)
{
  g_return_val_if_fail(option && option->type == OPTION_INTEGER && value, FALSE);

  if (!option->set)
    return FALSE;
  *value = option->valueInt;
  return TRUE;
}
gboolean toolOptionsGet_valueFloat  (Option *option, float *value)
{
  g_return_val_if_fail(option && option->type == OPTION_FLOAT && value, FALSE);

  if (!option->set)
    return FALSE;
  *value = option->valueFloat;
  return TRUE;
}
gchar* toolOptionsGet_valueAndLabel(Option *option)
{
  gchar *markup;
  
  g_return_val_if_fail(option, (gchar*)0);
  if (option->set)
    switch (option->type)
      {
      case OPTION_BOOLEAN:
        markup = g_markup_printf_escaped("%d (<span size=\"smaller\">%s</span>)",
                                         (int)option->valueBool, option->label);
        break;
      case OPTION_INTEGER:
        markup = g_markup_printf_escaped("%d (<span size=\"smaller\">%s</span>)",
                                         option->valueInt, option->label);
        break;
      case OPTION_FLOAT:
        markup = g_markup_printf_escaped("%g (<span size=\"smaller\">%s</span>)",
                                         option->valueFloat, option->label);
        break;
      default:
        g_warning("Wrong type for option.");
        markup = (gchar*)0;
      }
  else
    markup = g_markup_printf_escaped("unset value (<span size=\"smaller\">%s</span>)",
                                     option->label);

  return markup;
}
