/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef FOG_H
#define FOG_H

#include <visu_extension.h>
#include <visu_tools.h>


/**
 * initExtensionFog
 *
 * It initialises all variables of the OpenGL extension.
 * It creates all resources and parameters introduced by
 * this extension.
 * This method should be added in the %listInitExtensionFunc to
 * be called automatically by the initOpenGLExtensions() at V_Sim
 * startup.
 *
 * Returns a pointer to the OpenGLExtension it created or
 * NULL otherwise.
 */
OpenGLExtension* initExtensionFogAndBGColor();

/**
 * setFogRGBValues:
 * @rgb: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #MASK_RGB_R, #MASK_RGB_G, #MASK_RGB_B, #MASK_RGB_ALL or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the parameter fog_specific_color.
 * This color is actually used only if fog_color_is_specific is set to 1,
 * use setFogColorSpecific() to do that.
 *
 * Returns 0 if redrawing is not necessary.
 * 1 if the rendering window must be redrawn.
 */
int setFogRGBValues(float rgb[3], int mask);
/**
 * setFogIsOn:
 * @value: 1 if fog must be rendered, 0 otherwise.
 *
 * Method used to change the value of the parameter fog_is_on.
 *
 * Returns 0 if redrawing is not necessary.
 * 1 if the rendering window must be redrawn.
 */
int setFogIsOn(int value);
/**
 * setFogColorSpecific:
 * @value: 1 if fog is rendered with its own color specified
 * by setFogRGBValues() or 0 if the fog uses the background
 * color.
 *
 * Method used to change the value of the parameter fog_color_is_specific.
 *
 * Returns: 1 if createFog() should be called. In all cases, 'OpenGLAskForReDraw'
 *          signal should then be emitted.
 */
int setFogColorSpecific(int value);
/**
 * MASK_FOG_START:
 *
 * Value used by the second parameter of setFogStartEndValues() to
 * specified the value that must be changed. This actually changes
 * the fog_start value.
 */
#define MASK_FOG_START (1 << 0)
/**
 * MASK_FOG_END:
 *
 * Value used by the second parameter of setFogStartEndValues() to
 * specified the value that must be changed. This actually changes
 * the fog_end value.
 */
#define MASK_FOG_END (1 << 1)
/**
 * setFogStartEndValues:
 * @startEnd: a two floats array with values (0 <= values <= 1) for the
 * beging and the ending of the fog position. Only values specified by the mask
 * are really relevant.
 * @mask: use #MASK_FOG_START, #MASK_FOG_END to indicate what values in
 * the startEnd array must be taken into account.
 *
 * Method used to change the value of the parameters fog_start and
 * fog_end.
 *
 * Returns: 1 if createFog() should be called and then 'OpenGLAskForReDraw'
 *          signal be emitted.
 */
int setFogStartEndValues(float startEnd[2], int mask);

/**
 * getFogRedValue:
 *
 * Returns: the red value of the specific color of the fog.
 */
float getFogRedValue();
/**
 * getFogGreenValue:
 *
 * Returns: the green value of the specific color of the fog.
 */
float getFogGreenValue();
/**
 * getFogBlueValue:
 *
 * Returns: the blue value of the specific color of the fog.
 */
float getFogBlueValue();
/**
 * isFogOn:
 *
 * Returns: 1 if the fog is rendered, 0 otherwise.
 */
int isFogOn();
/**
 * getFogColorSpecific:
 *
 * Returns: 1 if the fog uses its own color or 0 if it uses
 * the color of the background.
 */
int getFogColorSpecific();
/**
 * getFogStart:
 *
 * Returns: the position where the fog starts.
 */
float getFogStart();
/**
 * getFogEnd:
 *
 * Returns: the position where the fog ends.
 */
float getFogEnd();
/**
 * setBgRGBValues:
 * @rgb: a three floats array with values (0 <= values <= 1) for the
 * red, the green and the blue color. Only values specified by the mask
 * are really relevant.
 * @mask: use #MASK_RGB_R, #MASK_RGB_G, #MASK_RGB_B, #MASK_RGB_ALL or a
 * combinaison to indicate what values in the rgb array must be taken
 * into account.
 *
 * Method used to change the value of the parameter background_color.
 *
 * Returns 0 if redrawing is not necessary.
 * 1 if the rendering window must be redrawn.
 */
int setBgRGBValues(float rgb[3], int mask);
/**
 * getBgRedValue:
 *
 * Returns: the red value of the current background color.
 */
float getBgRedValue();
/**
 * getBgGreenValue:
 *
 * Returns: the gree value of the current background color.
 */
float getBgGreenValue();
/**
 * getBgBlueValue:
 *
 * Returns: the blue value of the current background color.
 */
float getBgBlueValue();

void createFog(VisuData *data);
void createFogColor();




/****************/
/* Private part */
/****************/

OpenGLExtension* extensionFog;



#endif
