/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_NUMERICALENTRYWIDGET_H
#define GTK_NUMERICALENTRYWIDGET_H

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtkentry.h>

#include <visu_tools.h>

G_BEGIN_DECLS
/**
 * NUMERICAL_ENTRY_TYPE
 *
 * Return the associated #GType to the NumericalEntry objects.
 */
#define NUMERICAL_ENTRY_TYPE         (numericalEntry_get_type ())
/**
 * NUMERICAL_ENTRY:
 *
 * Cast the given object to a #NumericalEntry object.
 */
#define NUMERICAL_ENTRY(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), NUMERICAL_ENTRY_TYPE, NumericalEntry))
/**
 * NUMERICAL_ENTRY_CLASS
 *
 * Cast the given class to a #NumericalEntryClass object.
 */
#define NUMERICAL_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NUMERICAL_ENTRY_TYPE, NumericalEntryClass))
/**
 * IS_NUMERICAL_ENTRY
 *
 * Return if the given object is a valid #NumericalEntry object.
 */
#define IS_NUMERICAL_ENTRY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NUMERICAL_ENTRY_TYPE))
/**
 * IS_NUMERICAL_ENTRY_CLASS
 *
 * Return if the given class is a valid #NumericalEntryClass class.
 */
#define IS_NUMERICAL_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NUMERICAL_ENTRY_TYPE))

/**
 * NumericalEntry_struct
 *
 * Private structure to store informations of a #NumericalEntry object.
 */
struct NumericalEntry_struct;
/**
 * NumericalEntryClass_struct
 *
 * Private structure to store informations of a #NumericalEntryClass object.
 */
struct NumericalEntryClass_struct;

/**
 * NumericalEntry
 *
 * Short form for a #NumericalEntry_struct structure.
 */
typedef struct NumericalEntry_struct        NumericalEntry;
/* typedef struct NumericalEntryPrivate_struct NumericalEntryPrivate; */
/**
 * NumericalEntryClass
 *
 * Short form for a #NumericalEntryClass_struct structure.
 */
typedef struct NumericalEntryClass_struct   NumericalEntryClass;

/**
 * numericalEntry_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #NumericalEntry objects.
 */
GType          numericalEntry_get_type        (void);
/**
 * numericalEntry_new :
 * @value: the initial value.
 *
 * A #NumericalEntry widget is like a #GtkEntry widget, but it only accepts
 * double precision values (written in plain format, e.g. 1.23456, or scientific
 * notation, e.g. 1.2345e6). The widget can(t be blank and there is always
 * a value printed in it. If the user erase the current value or enter something
 * that is not a recognised double precision value, the widget returns to its previous
 * valid value.
 *
 * Returns: a newly created #NumericalEntry widget.
 */
GtkWidget* numericalEntry_new(double value);
/**
 * numericalEntrySet_value:
 * @numericalEntry: a #NumericalEntry widget ;
 * @value: a double precision value.
 *
 * Use this method to set the value for the given #numericalEntry widget.
 */
void numericalEntrySet_value(NumericalEntry* numericalEntry, double value);
/**
 * numericalEntryGet_value:
 * @numericalEntry: a #NumericalEntry widget.
 *
 * You can get the value contained in the given @numericalEntry using this method.
 *
 * Returns: the double precision value printed in the #NumericalEntry.
 */
double numericalEntryGet_value(NumericalEntry *numericalEntry);


G_END_DECLS

#endif
