/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "gtk_about.h"

#include "visu_basic.h"
#include "visu_plugins.h"

enum
  {
    GTK_PLUGINS_COLUMN_ICON,
    GTK_PLUGINS_COLUMN_NAME,
    GTK_PLUGINS_COLUMN_DESCRIPTION,
    GTK_PLUGINS_COLUMN_AUTHORS,
    N_GTK_PLUGINS_COLUMNS
  };
void buildPluginsTab();


/* Initialise the about window, connect the
   signals, give names to widgets... */
void initAboutWindow()
{
  aboutWindow = (GtkWidget*)0;
}

/* create the window. */
void buildAboutWindow()
{
  GtkWidget *wd;
  GIOChannel *licence, *authors, *readme;
  gchar *buffer;
  GtkTextBuffer *text;
  GtkTextIter startIter;
  GtkTextTag *monoTag;
  gsize taille;
  GIOStatus res;
  GError *err;
  gchar *chemin;

  DBG_fprintf(stderr, "Gtk About : creating the dialog window.\n");
  aboutWindow = create_infoDialog();
  gtk_widget_set_name(aboutWindow, "message");

  wd = lookup_widget(aboutWindow, "labelInfoVersion");
  gtk_label_set_text(GTK_LABEL(wd), V_SIM_VERSION);
  wd = lookup_widget(aboutWindow, "labelInfoReleaseDate");
  gtk_label_set_text(GTK_LABEL(wd), V_SIM_RELEASE_DATE);
  wd = lookup_widget(aboutWindow, "labelInfoWebSite");
  gtk_label_set_markup(GTK_LABEL(wd), V_SIM_WEB_SITE);

  wd = lookup_widget(aboutWindow, "notebookAbout");
  gtk_widget_set_name(wd, "message_notebook");

  /* Create the interior of the tabs. */
  chemin = g_build_filename(v_sim_legal_dir, V_SIM_LICENCE_FILE, NULL);
  licence = g_io_channel_new_file(chemin, "r", (GError**)0);
  if (!licence)
    g_warning("Can't find the licence file, normally"
	      " it should be in '%s'.\n", chemin);
  else
    {
      g_io_channel_set_encoding(licence, "iso-8859-15", (GError**)0);
      buffer = (gchar*)0;
      err = (GError*)0;
      res = g_io_channel_read_to_end (licence, &buffer, &taille, &err);
      if (!buffer)
	/* Can't read the licence file (first %s) and give the return error string (second %s) */
	g_warning("INTERNAL ERROR! Can't read the licence file (%s)."
		  " Repported error :\n%s\n", chemin, err->message);
      else
	{
	  g_io_channel_shutdown (licence, FALSE, (GError**)0);
	  g_io_channel_unref (licence);

	  wd = lookup_widget(aboutWindow, "textviewLicence");
	  text = gtk_text_view_get_buffer(GTK_TEXT_VIEW(wd));
	  gtk_text_buffer_get_start_iter(text, &startIter);
	  monoTag = gtk_text_buffer_create_tag(text, "typewriter", "family", "monospace", NULL);
	  gtk_text_buffer_insert_with_tags(text, &startIter, buffer, -1, monoTag, NULL);
	  
	  g_free (buffer);
	}
    }
  g_free(chemin);

  chemin = g_build_filename(v_sim_legal_dir, V_SIM_README_FILE, NULL);
  readme = g_io_channel_new_file(chemin, "r", (GError**)0);
  if (!readme)
    g_warning("Can't find the readme file, normally it"
	      " should be in '%s'.\n", chemin);
  else
    {
      g_io_channel_set_encoding(readme, "iso-8859-15", (GError**)0);
      buffer = (gchar*)0;
      err = (GError*)0;
      res = g_io_channel_read_to_end (readme, &buffer, &taille, &err);
      if (!buffer)
	g_warning("Can't read the readme file (%s)."
		  " Repported error :\n%s\n", chemin, err->message);
      else
	{
	  g_io_channel_shutdown (readme, FALSE, (GError**)0);
	  g_io_channel_unref (readme);

	  wd = lookup_widget(aboutWindow, "textviewReadme");
	  text = gtk_text_view_get_buffer(GTK_TEXT_VIEW(wd));
	  gtk_text_buffer_set_text (text, buffer, -1);
	  
	  g_free (buffer);
	}
    }
  g_free(chemin);

  chemin = g_build_filename(v_sim_legal_dir, V_SIM_AUTHORS_FILE, NULL);
  authors = g_io_channel_new_file(chemin, "r", (GError**)0);
  if (!authors)
    g_warning("Can't find the authors file, normally"
	      " it should be in '%s'.\n", chemin);
  else
    {
      g_io_channel_set_encoding(authors, "iso-8859-15", (GError**)0);
      buffer = (gchar*)0;
      err = (GError*)0;
      res = g_io_channel_read_to_end (authors, &buffer, &taille, &err);
      if (!buffer)
	g_warning("Can't read the authors file (%s)."
		  " Repported error :\n%s\n", chemin, err->message);
      else
	{
	  g_io_channel_shutdown (authors, FALSE, (GError**)0);
	  g_io_channel_unref (authors);

	  wd = lookup_widget(aboutWindow, "textviewAuthors");
	  text = gtk_text_view_get_buffer(GTK_TEXT_VIEW(wd));
	  gtk_text_buffer_get_start_iter(text, &startIter);
	  monoTag = gtk_text_buffer_create_tag(text, "typewriter", "family", "monospace", NULL);
	  gtk_text_buffer_insert_with_tags(text, &startIter, buffer, -1, monoTag, NULL);
	  
	  g_free (buffer);
	}
    }
  g_free(chemin);

  buildPluginsTab();
}

void buildPluginsTab()
{
  GtkListStore *liststore;
  GtkTreeIter iter;
  GList *pnt;
  GtkWidget *tree, *wd;
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GdkPixbuf *pixbuf;

  liststore = gtk_list_store_new(N_GTK_PLUGINS_COLUMNS,
				 GDK_TYPE_PIXBUF,
				 G_TYPE_STRING,
				 G_TYPE_STRING,
				 G_TYPE_STRING);
  gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(liststore),
				       GTK_PLUGINS_COLUMN_NAME, GTK_SORT_ASCENDING);

  pnt = visuPluginsGet_listLoaded();
  while(pnt)
    {
      if (((VisuPlugin*)pnt->data)->getIcon)
	pixbuf = gdk_pixbuf_new_from_file_at_size(((VisuPlugin*)pnt->data)->getIcon(),
						  32, 32, (GError**)0);
      else
	pixbuf = (GdkPixbuf*)0;
      gtk_list_store_append(liststore, &iter);
      gtk_list_store_set(liststore, &iter,
			 GTK_PLUGINS_COLUMN_ICON, pixbuf,
			 GTK_PLUGINS_COLUMN_NAME, ((VisuPlugin*)pnt->data)->name,
			 GTK_PLUGINS_COLUMN_DESCRIPTION, ((VisuPlugin*)pnt->data)->getDescription(),
			 GTK_PLUGINS_COLUMN_AUTHORS, ((VisuPlugin*)pnt->data)->getAuthors(),
			 -1);
      pnt = g_list_next(pnt);
    }

  /* Build the treeview. */
  tree= gtk_tree_view_new_with_model(GTK_TREE_MODEL(liststore));
  
  gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(tree)), GTK_SELECTION_NONE);
  gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree), TRUE);

  renderer = gtk_cell_renderer_pixbuf_new();
  column = gtk_tree_view_column_new_with_attributes("", renderer,
						    "pixbuf", GTK_PLUGINS_COLUMN_ICON,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  renderer = gtk_cell_renderer_text_new();
  g_object_set(renderer, "weight", 600, "weight-set", TRUE, NULL);
  column = gtk_tree_view_column_new_with_attributes(_("Name"), renderer,
						    "text", GTK_PLUGINS_COLUMN_NAME,
						    NULL);
  gtk_tree_view_column_set_alignment(column, 0.5);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  renderer = gtk_cell_renderer_text_new();
  g_object_set(renderer, "xalign", 0.5, NULL);
  column = gtk_tree_view_column_new_with_attributes(_("Description"), renderer,
						    "markup", GTK_PLUGINS_COLUMN_DESCRIPTION,
						    NULL);
  gtk_tree_view_column_set_expand(column, TRUE);
  gtk_tree_view_column_set_alignment(column, 0.5);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes(_("Authors"), renderer,
						    "text", GTK_PLUGINS_COLUMN_AUTHORS,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

  gtk_widget_show(tree);

  wd = lookup_widget(aboutWindow, "scrolledwindowPlugins");
  gtk_container_add(GTK_CONTAINER(wd), tree);
}
